/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.simpleflatmapper.jdbc.JdbcColumnKey;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.test.JdbcMapperFactoryHelper;
import org.simpleflatmapper.jdbc.test.MockDbObjectResultSet;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.FieldMapperErrorHandler;
import org.simpleflatmapper.map.MapperBuilderErrorHandler;
import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.map.SourceMapper;
import org.simpleflatmapper.map.error.LogFieldMapperErrorHandler;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.ContextualSourceFieldMapperImpl;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.getter.FieldGetter;
import org.simpleflatmapper.reflect.primitive.LongGetter;
import org.simpleflatmapper.test.beans.DbObject;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.ListCollector;

public class JdbcMapperBuilderTest {
    @Test
    public void testInstantiateBuilderOnType() throws SQLException {
        JdbcMapperBuilder builder = new JdbcMapperBuilder(DbObject.class);
        ((JdbcMapperBuilder)builder.addMapping("id")).addMapping("name");
        JdbcMapper mapper = (JdbcMapper)builder.mapper();
        List l = ((ListCollector)mapper.forEach((ResultSet)new MockDbObjectResultSet(1), (CheckedConsumer)new ListCollector())).getList();
        Assert.assertEquals((long)1L, (long)l.size());
        Assert.assertEquals((long)1L, (long)((DbObject)l.get(0)).getId());
        Assert.assertEquals((Object)"name1", (Object)((DbObject)l.get(0)).getName());
    }

    @Test
    public void testWithWrongColumn() throws MappingException, SQLException {
        JdbcMapperBuilder builder = ((JdbcMapperFactory)JdbcMapperFactoryHelper.asm().mapperBuilderErrorHandler(MapperBuilderErrorHandler.NULL)).newBuilder(DbObject.class);
        ((JdbcMapperBuilder)((JdbcMapperBuilder)builder.addMapping("no_id")).addMapping("no_name")).addMapping("email");
        JdbcMapper mapper = (JdbcMapper)builder.mapper();
        List l = ((ListCollector)mapper.forEach((ResultSet)new MockDbObjectResultSet(1), (CheckedConsumer)new ListCollector())).getList();
        Assert.assertEquals((long)1L, (long)l.size());
        Assert.assertEquals((long)0L, (long)((DbObject)l.get(0)).getId());
        Assert.assertNull((Object)((DbObject)l.get(0)).getName());
        Assert.assertEquals((Object)"email1", (Object)((DbObject)l.get(0)).getEmail());
    }

    @Test
    public void testAsmFactoryJdbcMapperCache() throws Exception {
        SourceMapper<ResultSet, DbObject> mapper1 = this.getSubMapper((JdbcMapper<DbObject>)((JdbcMapper)((JdbcMapperBuilder)((JdbcMapperBuilder)JdbcMapperFactoryHelper.asm().newBuilder(DbObject.class).addMapping("id")).addMapping("name")).mapper()));
        SourceMapper<ResultSet, DbObject> mapper2 = this.getSubMapper((JdbcMapper<DbObject>)((JdbcMapper)((JdbcMapperBuilder)((JdbcMapperBuilder)JdbcMapperFactoryHelper.asm().newBuilder(DbObject.class).addMapping("id")).addMapping("name")).mapper()));
        FieldMapperColumnDefinition columnDefinition = FieldMapperColumnDefinition.customGetter(new StaticLongGetter(3L));
        SourceMapper<ResultSet, DbObject> mapper3 = this.getSubMapper((JdbcMapper<DbObject>)((JdbcMapper)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperFactory)JdbcMapperFactoryHelper.asm().fieldMapperErrorHandler((FieldMapperErrorHandler)new LogFieldMapperErrorHandler())).newBuilder(DbObject.class).addMapping("id", (ColumnDefinition)columnDefinition)).addMapping("name")).mapper()));
        Assert.assertNotSame(mapper1, mapper2);
        Assert.assertSame(mapper1.getClass(), mapper2.getClass());
        Assert.assertNotSame(mapper1.getClass(), mapper3.getClass());
        Assert.assertTrue((boolean)mapper1.getClass().getSimpleName().startsWith("AsmMapperFrom"));
        Assert.assertTrue((boolean)mapper2.getClass().getSimpleName().startsWith("AsmMapperFrom"));
        Assert.assertTrue((boolean)mapper3.getClass().getSimpleName().startsWith("AsmMapperFrom"));
    }

    private SourceMapper<ResultSet, DbObject> getSubMapper(JdbcMapper<DbObject> mapper) throws Exception {
        Field mapperField;
        Field setRowMapperField = mapper.getClass().getDeclaredField("setRowMapper");
        setRowMapperField.setAccessible(true);
        Object setRowMapper = setRowMapperField.get(mapper);
        try {
            mapperField = setRowMapper.getClass().getDeclaredField("mapper");
        }
        catch (NoSuchFieldException e) {
            mapperField = setRowMapper.getClass().getSuperclass().getDeclaredField("mapper");
        }
        mapperField.setAccessible(true);
        SourceMapper mapper1 = (SourceMapper)new FieldGetter(mapperField).get(setRowMapper);
        if (mapper1 instanceof ContextualSourceFieldMapperImpl) {
            return ((ContextualSourceFieldMapperImpl)mapper1).getDelegate();
        }
        return mapper1;
    }

    @Test
    public void test501ZoneId() throws MappingException, SQLException {
        this.test501((JdbcMapperBuilder<C501>)JdbcMapperFactoryHelper.asm().newBuilder(C501.class));
        this.test501((JdbcMapperBuilder<C501>)JdbcMapperFactoryHelper.noAsm().newBuilder(C501.class));
    }

    private void test501(JdbcMapperBuilder<C501> builder) throws SQLException {
        try {
            builder.addMapping("zone_id", 1, 12);
            JdbcMapper mapper = (JdbcMapper)builder.mapper();
            String zoneId = ZoneId.getAvailableZoneIds().iterator().next();
            ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
            Mockito.when((Object)rs.next()).thenReturn((Object)true, (Object[])new Boolean[]{false});
            Mockito.when((Object)rs.getString(1)).thenReturn((Object)zoneId);
            List l = ((ListCollector)mapper.forEach(rs, (CheckedConsumer)new ListCollector())).getList();
            Assert.assertEquals((long)1L, (long)l.size());
            Assert.assertEquals((Object)ZoneId.of(zoneId), (Object)((C501)l.get((int)0)).zoneId);
        }
        catch (Throwable e) {
            System.out.println("XXXXXX = " + e);
            e.printStackTrace(System.out);
            throw e;
        }
    }

    @Test
    public void test509ZoneIdvsStr() throws SQLException {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.noAsm().newBuilder(C509.class);
        builder.addMapping("zoneId", 1, 12);
        JdbcMapper mapper = (JdbcMapper)builder.mapper();
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.next()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)rs.getString(1)).thenReturn((Object)"UTC");
        List l = ((ListCollector)mapper.forEach(rs, (CheckedConsumer)new ListCollector())).getList();
        Assert.assertEquals((long)1L, (long)l.size());
        Assert.assertEquals((Object)"UTC", (Object)((C509)l.get(0)).zoneId.getId());
    }

    @Test
    public void test544() {
        String VALUES_VAL = "values_val";
        String VALUES = "values";
        JdbcColumnKey valuesKeys = new JdbcColumnKey("values", 1, 12);
        ((JdbcMapperBuilder)((JdbcMapperFactory)JdbcMapperFactory.newInstance().addAlias("values", "values_val")).newBuilder(C544.class).addMapping((FieldKey)valuesKeys, new Object[0])).mapper();
    }

    public static class C544 {
        private final List<String> values;

        public C544(List<String> values) {
            this.values = values;
        }
    }

    public static class C509 {
        private ZoneId zoneId;

        public ZoneId getZoneId() {
            return this.zoneId;
        }

        public void setZoneId(ZoneId zoneId) {
            throw new UnsupportedOperationException();
        }

        public void setZoneId(CharSequence zoneId) {
            this.zoneId = ZoneId.of(zoneId.toString());
        }
    }

    public static class C501 {
        public final ZoneId zoneId;

        public C501(ZoneId zoneId) {
            this.zoneId = zoneId;
        }
    }

    static class StaticLongGetter<T>
    implements LongGetter<T>,
    Getter<T, Long> {
        private final long l;

        StaticLongGetter(long l) {
            this.l = l;
        }

        public Long get(T target) throws Exception {
            return this.l;
        }

        public long getLong(T target) throws Exception {
            return this.l;
        }
    }
}

