/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.ResultSet;
import java.sql.Timestamp;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.test.JdbcMapperFactoryHelper;
import org.simpleflatmapper.test.beans.DbConstructorObject;

public class JdbcMapperConstructorInjectionTest {
    @Test
    public void testChooseSmallestMatchingConstructor() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(DbConstructorObject.class);
        builder.addMapping("prop1");
        JdbcMapper mapper = (JdbcMapper)builder.mapper();
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.getString(1)).thenReturn((Object)"propValue");
        DbConstructorObject o = (DbConstructorObject)mapper.map(rs);
        Assert.assertEquals((Object)"propValue", (Object)o.getProp1());
        Assert.assertNull((Object)o.getProp2());
        Assert.assertNull((Object)o.getProp3());
        Assert.assertEquals((long)0L, (long)o.getC());
    }

    @Test
    public void testConstructorProp1Prop2() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(DbConstructorObject.class);
        builder.addMapping("prop1");
        builder.addMapping("prop2");
        JdbcMapper mapper = (JdbcMapper)builder.mapper();
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.getString(1)).thenReturn((Object)"propValue1");
        Mockito.when((Object)rs.getString(2)).thenReturn((Object)"propValue2");
        DbConstructorObject o = (DbConstructorObject)mapper.map(rs);
        Assert.assertEquals((Object)"propValue1", (Object)o.getProp1());
        Assert.assertEquals((Object)"propValue2", (Object)o.getProp2());
        Assert.assertNull((Object)o.getProp3());
        Assert.assertEquals((long)1L, (long)o.getC());
    }

    @Test
    public void testConstructorProp1Prop3() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(DbConstructorObject.class);
        builder.addMapping("prop1");
        builder.addMapping("prop3");
        JdbcMapper mapper = (JdbcMapper)builder.mapper();
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.getString(1)).thenReturn((Object)"propValue1");
        Mockito.when((Object)rs.getTimestamp(2)).thenReturn((Object)ts);
        Mockito.when((Object)rs.getObject(2)).thenReturn((Object)ts);
        DbConstructorObject o = (DbConstructorObject)mapper.map(rs);
        Assert.assertEquals((Object)"propValue1", (Object)o.getProp1());
        Assert.assertNull((Object)o.getProp2());
        Assert.assertEquals((Object)ts, (Object)o.getProp3());
        Assert.assertEquals((long)2L, (long)o.getC());
    }

    @Test
    public void testConstructorProp3() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(DbConstructorObject.class);
        builder.addMapping("prop3");
        JdbcMapper mapper = (JdbcMapper)builder.mapper();
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.getTimestamp(1)).thenReturn((Object)ts);
        Mockito.when((Object)rs.getObject(1)).thenReturn((Object)ts);
        DbConstructorObject o = (DbConstructorObject)mapper.map(rs);
        Assert.assertNull((Object)o.getProp1());
        Assert.assertNull((Object)o.getProp2());
        Assert.assertEquals((Object)ts, (Object)o.getProp3());
        Assert.assertEquals((long)2L, (long)o.getC());
    }

    @Test
    public void testConstructorProp1Prop2Prop3() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(DbConstructorObject.class);
        builder.addMapping("prop1");
        builder.addMapping("prop2");
        try {
            builder.addMapping("prop3");
            Assert.fail((String)"Expect exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testChooseSmallestMatchingConstructorNoAsm() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.noAsm().newBuilder(DbConstructorObject.class);
        builder.addMapping("prop1");
        JdbcMapper mapper = (JdbcMapper)builder.mapper();
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.getString(1)).thenReturn((Object)"propValue");
        DbConstructorObject o = (DbConstructorObject)mapper.map(rs);
        Assert.assertEquals((Object)"propValue", (Object)o.getProp1());
        Assert.assertNull((Object)o.getProp2());
        Assert.assertNull((Object)o.getProp3());
        Assert.assertEquals((long)0L, (long)o.getC());
    }

    @Test
    public void testConstructorProp1Prop2NoAsm() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.noAsm().newBuilder(DbConstructorObject.class);
        builder.addMapping("prop1");
        builder.addMapping("prop2");
        JdbcMapper mapper = (JdbcMapper)builder.mapper();
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.getString(1)).thenReturn((Object)"propValue1");
        Mockito.when((Object)rs.getString(2)).thenReturn((Object)"propValue2");
        DbConstructorObject o = (DbConstructorObject)mapper.map(rs);
        Assert.assertEquals((Object)"propValue1", (Object)o.getProp1());
        Assert.assertEquals((Object)"propValue2", (Object)o.getProp2());
        Assert.assertNull((Object)o.getProp3());
        Assert.assertEquals((long)1L, (long)o.getC());
    }

    @Test
    public void testConstructorProp1Prop3NoAsm() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.noAsm().newBuilder(DbConstructorObject.class);
        builder.addMapping("prop1");
        builder.addMapping("prop3");
        JdbcMapper mapper = (JdbcMapper)builder.mapper();
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.getString(1)).thenReturn((Object)"propValue1");
        Mockito.when((Object)rs.getTimestamp(2)).thenReturn((Object)ts);
        Mockito.when((Object)rs.getObject(2)).thenReturn((Object)ts);
        DbConstructorObject o = (DbConstructorObject)mapper.map(rs);
        Assert.assertEquals((Object)"propValue1", (Object)o.getProp1());
        Assert.assertNull((Object)o.getProp2());
        Assert.assertEquals((Object)ts, (Object)o.getProp3());
        Assert.assertEquals((long)2L, (long)o.getC());
    }

    @Test
    public void testConstructorProp3NoAsm() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.noAsm().newBuilder(DbConstructorObject.class);
        builder.addMapping("prop3");
        JdbcMapper mapper = (JdbcMapper)builder.mapper();
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.getTimestamp(1)).thenReturn((Object)ts);
        Mockito.when((Object)rs.getObject(1)).thenReturn((Object)ts);
        DbConstructorObject o = (DbConstructorObject)mapper.map(rs);
        Assert.assertNull((Object)o.getProp1());
        Assert.assertNull((Object)o.getProp2());
        Assert.assertEquals((Object)ts, (Object)o.getProp3());
        Assert.assertEquals((long)2L, (long)o.getC());
    }
}

