/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.junit.Test;
import org.simpleflatmapper.jdbc.DynamicJdbcMapper;
import org.simpleflatmapper.jdbc.JdbcColumnKey;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.test.JdbcMapperDbObjectTest;
import org.simpleflatmapper.jdbc.test.JdbcMapperFactoryHelper;
import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.map.property.GetterProperty;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.getter.GetterFactory;
import org.simpleflatmapper.test.beans.DbFinalObject;
import org.simpleflatmapper.test.beans.DbObject;
import org.simpleflatmapper.test.jdbc.DbHelper;
import org.simpleflatmapper.test.jdbc.TestRowHandler;

public class JdbcMapperCustomMappingTest {
    @Test
    public void testColumnAlias() throws Exception {
        JdbcMapperFactory mapperFactory = JdbcMapperFactoryHelper.asm();
        mapperFactory.addAlias("not_id_column", "id");
        DynamicJdbcMapper mapper = mapperFactory.newMapper(DbObject.class);
        DbHelper.testQuery((TestRowHandler)new TestRowHandler<PreparedStatement>((JdbcMapper)mapper){
            final /* synthetic */ JdbcMapper val$mapper;
            {
                this.val$mapper = jdbcMapper;
            }

            public void handle(PreparedStatement t) throws Exception {
                ResultSet r = t.executeQuery();
                r.next();
                DbHelper.assertDbObjectMapping((DbObject)((DbObject)this.val$mapper.map(r)));
            }
        }, (String)"select id, name, email, creation_time, type_ordinal, type_name from TEST_DB_OBJECT where id = 1 ".replace("id,", "id as not_id_column,"));
    }

    @Test
    public void testColumnAliasStatic() throws Exception {
        JdbcMapperFactory mapperFactory = JdbcMapperFactoryHelper.asm();
        mapperFactory.addAlias("not_id_column", "id");
        final JdbcMapper mapper = (JdbcMapper)JdbcMapperDbObjectTest.addColumn(mapperFactory.newBuilder(DbObject.class)).mapper();
        DbHelper.testQuery((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement t) throws Exception {
                ResultSet r = t.executeQuery();
                r.next();
                DbHelper.assertDbObjectMapping((DbObject)((DbObject)mapper.map(r)));
            }
        }, (String)"select id, name, email, creation_time, type_ordinal, type_name from TEST_DB_OBJECT where id = 1 ".replace("id,", "id as not_id_column,"));
    }

    @Test
    public void testCustomMappingStatic() throws SQLException, Exception {
        JdbcMapperFactory mapperFactory = JdbcMapperFactoryHelper.asm();
        mapperFactory.addCustomFieldMapper("id", (FieldMapper)new FieldMapper<ResultSet, DbObject>(){

            public void mapTo(ResultSet source, DbObject target, MappingContext<? super ResultSet> mappingContext) throws MappingException {
                target.setId(1L);
            }
        });
        final JdbcMapper mapper = (JdbcMapper)JdbcMapperDbObjectTest.addColumn(mapperFactory.newBuilder(DbObject.class)).mapper();
        DbHelper.testQuery((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement t) throws Exception {
                ResultSet r = t.executeQuery();
                r.next();
                DbHelper.assertDbObjectMapping((DbObject)((DbObject)mapper.map(r)));
            }
        }, (String)"select id, name, email, creation_time, type_ordinal, type_name from TEST_DB_OBJECT where id = 1 ".replace("id,", "33 as id,"));
    }

    @Test
    public void testCustomMapping() throws SQLException, Exception {
        JdbcMapperFactory mapperFactory = JdbcMapperFactoryHelper.asm();
        mapperFactory.addCustomFieldMapper("id", (FieldMapper)new FieldMapper<ResultSet, DbObject>(){

            public void mapTo(ResultSet source, DbObject target, MappingContext<? super ResultSet> mappingContext) throws MappingException {
                target.setId(1L);
            }
        });
        DynamicJdbcMapper mapper = mapperFactory.newMapper(DbObject.class);
        DbHelper.testQuery((TestRowHandler)new TestRowHandler<PreparedStatement>((JdbcMapper)mapper){
            final /* synthetic */ JdbcMapper val$mapper;
            {
                this.val$mapper = jdbcMapper;
            }

            public void handle(PreparedStatement t) throws Exception {
                ResultSet r = t.executeQuery();
                r.next();
                DbHelper.assertDbObjectMapping((DbObject)((DbObject)this.val$mapper.map(r)));
            }
        }, (String)"select id, name, email, creation_time, type_ordinal, type_name from TEST_DB_OBJECT where id = 1 ".replace("id,", "33 as id,"));
    }

    @Test
    public void testCustomReaderOnSetter() throws SQLException, Exception {
        JdbcMapperFactory mapperFactory = JdbcMapperFactoryHelper.asm().addCustomGetter("id", (Getter)new Getter<ResultSet, Long>(){

            public Long get(ResultSet target) throws Exception {
                return 1L;
            }
        });
        DynamicJdbcMapper mapper = mapperFactory.newMapper(DbObject.class);
        DbHelper.testQuery((TestRowHandler)new TestRowHandler<PreparedStatement>((JdbcMapper)mapper){
            final /* synthetic */ JdbcMapper val$mapper;
            {
                this.val$mapper = jdbcMapper;
            }

            public void handle(PreparedStatement t) throws Exception {
                ResultSet r = t.executeQuery();
                r.next();
                DbHelper.assertDbObjectMapping((DbObject)((DbObject)this.val$mapper.map(r)));
            }
        }, (String)"select id, name, email, creation_time, type_ordinal, type_name from TEST_DB_OBJECT where id = 1 ".replace("id,", "33 as id,"));
    }

    @Test
    public void testCustomReaderOnSetterStatic() throws Exception {
        final JdbcMapper mapper = (JdbcMapper)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)JdbcMapperFactoryHelper.asm().newBuilder(DbObject.class).addMapping("id", new Object[]{new GetterProperty((Getter)new Getter<ResultSet, Long>(){

            public Long get(ResultSet target) throws Exception {
                return 1L;
            }
        })})).addMapping("name")).addMapping("email")).addMapping("creation_time")).addMapping("type_ordinal")).addMapping("type_name")).mapper();
        DbHelper.testQuery((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement t) throws Exception {
                ResultSet r = t.executeQuery();
                r.next();
                DbHelper.assertDbObjectMapping((DbObject)((DbObject)mapper.map(r)));
            }
        }, (String)"select id, name, email, creation_time, type_ordinal, type_name from TEST_DB_OBJECT where id = 1 ".replace("id,", "33 as id,"));
    }

    @Test
    public void testCustomGetterFactory() throws SQLException, Exception {
        final JdbcMapper mapper = (JdbcMapper)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)JdbcMapperFactoryHelper.asm().newBuilder(DbObject.class).addMapping("id", (ColumnDefinition)FieldMapperColumnDefinition.customGetterFactory((GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type target, JdbcColumnKey key, Object ... properties) {
                return new Getter<ResultSet, Long>(){

                    public Long get(ResultSet target) throws Exception {
                        return 1L;
                    }
                };
            }
        }))).addMapping("name")).addMapping("email")).addMapping("creation_time")).addMapping("type_ordinal")).addMapping("type_name")).mapper();
        DbHelper.testQuery((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement t) throws Exception {
                ResultSet r = t.executeQuery();
                r.next();
                DbHelper.assertDbObjectMapping((DbObject)((DbObject)mapper.map(r)));
            }
        }, (String)"select id, name, email, creation_time, type_ordinal, type_name from TEST_DB_OBJECT where id = 1 ".replace("id,", "33 as id,"));
    }

    @Test
    public void testCustomReaderOnConstructor() throws SQLException, Exception {
        JdbcMapperFactory mapperFactory = JdbcMapperFactoryHelper.asm().addCustomGetter("id", (Getter)new Getter<ResultSet, Long>(){

            public Long get(ResultSet target) throws Exception {
                return 1L;
            }
        });
        DynamicJdbcMapper mapper = mapperFactory.newMapper(DbFinalObject.class);
        DbHelper.testQuery((TestRowHandler)new TestRowHandler<PreparedStatement>((JdbcMapper)mapper){
            final /* synthetic */ JdbcMapper val$mapper;
            {
                this.val$mapper = jdbcMapper;
            }

            public void handle(PreparedStatement t) throws Exception {
                ResultSet r = t.executeQuery();
                r.next();
                DbHelper.assertDbObjectMapping((DbFinalObject)((DbFinalObject)this.val$mapper.map(r)));
            }
        }, (String)"select id, name, email, creation_time, type_ordinal, type_name from TEST_DB_OBJECT where id = 1 ".replace("id,", "33 as id,"));
    }
}

