/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;
import org.simpleflatmapper.jdbc.DynamicJdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.test.JdbcMapperFactoryHelper;
import org.simpleflatmapper.map.property.DefaultValueProperty;
import org.simpleflatmapper.test.beans.DbFinalObject;
import org.simpleflatmapper.test.beans.DbObject;
import org.simpleflatmapper.test.jdbc.DbHelper;
import org.simpleflatmapper.test.jdbc.TestRowHandler;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.ListCollector;

public class JdbcMapperDbObjectTest {
    @Test
    public void testDefaultValue() throws Exception {
        DynamicJdbcMapper mapper = ((JdbcMapperFactory)JdbcMapperFactory.newInstance().addColumnProperty("name", new Object[]{new DefaultValueProperty((Object)"defaultName")})).newMapper(DbObject.class);
        DbHelper.testQuery((TestRowHandler)new TestRowHandler<PreparedStatement>((JdbcMapper)mapper){
            final /* synthetic */ JdbcMapper val$mapper;
            {
                this.val$mapper = jdbcMapper;
            }

            public void handle(PreparedStatement preparedStatement) throws Exception {
                ResultSet rs = preparedStatement.executeQuery();
                rs.next();
                DbObject object = (DbObject)this.val$mapper.map(rs);
                Assert.assertEquals((long)1L, (long)object.getId());
                Assert.assertEquals((Object)"namers", (Object)object.getName());
            }
        }, (String)"SELECT id, 'namers' as name from TEST_DB_OBJECT where id = 1");
        DbHelper.testQuery((TestRowHandler)new TestRowHandler<PreparedStatement>((JdbcMapper)mapper){
            final /* synthetic */ JdbcMapper val$mapper;
            {
                this.val$mapper = jdbcMapper;
            }

            public void handle(PreparedStatement preparedStatement) throws Exception {
                ResultSet rs = preparedStatement.executeQuery();
                rs.next();
                DbObject object = (DbObject)this.val$mapper.map(rs);
                Assert.assertEquals((long)1L, (long)object.getId());
                Assert.assertEquals((Object)"defaultName", (Object)object.getName());
            }
        }, (String)"SELECT id from TEST_DB_OBJECT where id = 1");
        DbHelper.testQuery((TestRowHandler)new TestRowHandler<PreparedStatement>((JdbcMapper)mapper){
            final /* synthetic */ JdbcMapper val$mapper;
            {
                this.val$mapper = jdbcMapper;
            }

            public void handle(PreparedStatement preparedStatement) throws Exception {
                ResultSet rs = preparedStatement.executeQuery();
                rs.next();
                DbObject object = (DbObject)this.val$mapper.map(rs);
                Assert.assertEquals((long)1L, (long)object.getId());
                Assert.assertEquals((Object)"defaultName", (Object)object.getName());
            }
        }, (String)"SELECT id, null as name from TEST_DB_OBJECT where id = 1");
    }

    @Test
    public void testColumn() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(DbObject.class);
        JdbcMapperDbObjectTest.addColumn(builder);
        JdbcMapper mapper = (JdbcMapper)builder.mapper();
        this.testDbObjectMapper((JdbcMapper<DbObject>)mapper);
    }

    public static <T> JdbcMapperBuilder<T> addColumn(JdbcMapperBuilder<T> builder) {
        builder.addMapping("id");
        builder.addMapping("name");
        builder.addMapping("email");
        builder.addMapping("creation_time");
        builder.addMapping("type_ordinal");
        builder.addMapping("type_name");
        return builder;
    }

    @Test
    public void testColumnFinalProperty() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(DbFinalObject.class);
        JdbcMapperDbObjectTest.addColumn(builder);
        final JdbcMapper mapper = (JdbcMapper)builder.mapper();
        DbHelper.testDbObjectFromDb((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement ps) throws Exception {
                List objects = ((ListCollector)mapper.forEach(ps.executeQuery(), (CheckedConsumer)new ListCollector())).getList();
                Assert.assertEquals((long)1L, (long)objects.size());
                DbHelper.assertDbObjectMapping((DbFinalObject)((DbFinalObject)objects.get(0)));
            }
        });
    }

    private void testDbObjectMapper(final JdbcMapper<DbObject> mapper) throws Exception {
        DbHelper.testDbObjectFromDb((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement ps) throws Exception {
                List objects = ((ListCollector)mapper.forEach(ps.executeQuery(), (CheckedConsumer)new ListCollector())).getList();
                Assert.assertEquals((long)1L, (long)objects.size());
                DbHelper.assertDbObjectMapping((DbObject)((DbObject)objects.get(0)));
            }
        });
    }

    @Test
    public void testDbObjectMapperWithIterator() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(DbObject.class);
        this.testMapperBuilderWithIterator((JdbcMapperBuilder<DbObject>)builder);
    }

    @Test
    public void testDbObjectMapperWithIteratorNoAsm() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.noAsm().newBuilder(DbObject.class);
        this.testMapperBuilderWithIterator((JdbcMapperBuilder<DbObject>)builder);
    }

    private void testMapperBuilderWithIterator(JdbcMapperBuilder<DbObject> builder) throws Exception {
        JdbcMapperDbObjectTest.addColumn(builder);
        final JdbcMapper mapper = (JdbcMapper)builder.mapper();
        DbHelper.testDbObjectFromDb((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement ps) throws Exception {
                Iterator objects = mapper.iterator(ps.executeQuery());
                Assert.assertTrue((boolean)objects.hasNext());
                DbHelper.assertDbObjectMapping((DbObject)((DbObject)objects.next()));
                Assert.assertFalse((boolean)objects.hasNext());
            }
        });
    }

    @Test
    public void testDbObjectMapperWithStream() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(DbObject.class);
        JdbcMapperDbObjectTest.addColumn(builder);
        final JdbcMapper mapper = (JdbcMapper)builder.mapper();
        DbHelper.testDbObjectFromDb((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement ps) throws Exception {
                mapper.stream(ps.executeQuery()).forEach(new Consumer<DbObject>(){

                    @Override
                    public void accept(DbObject o) {
                        try {
                            DbHelper.assertDbObjectMapping((DbObject)o);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        });
    }

    @Test
    public void testDbObjectMapperWithStreamNoAsm() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.noAsm().newBuilder(DbObject.class);
        JdbcMapperDbObjectTest.addColumn(builder);
        final JdbcMapper mapper = (JdbcMapper)builder.mapper();
        DbHelper.testDbObjectFromDb((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement ps) throws Exception {
                mapper.stream(ps.executeQuery()).forEach(new Consumer<DbObject>(){

                    @Override
                    public void accept(DbObject o) {
                        try {
                            DbHelper.assertDbObjectMapping((DbObject)o);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        });
    }

    @Test
    public void testDbObjectMapperWithStreamTryAdvance() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(DbObject.class);
        JdbcMapperDbObjectTest.addColumn(builder);
        final JdbcMapper mapper = (JdbcMapper)builder.mapper();
        DbHelper.testDbObjectFromDb((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement ps) throws Exception {
                mapper.stream(ps.executeQuery()).limit(1L).forEach(new Consumer<DbObject>(){

                    @Override
                    public void accept(DbObject o) {
                        try {
                            DbHelper.assertDbObjectMapping((DbObject)o);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        });
    }

    @Test
    public void testDbObjectMapperWithStreamTryAdvanceNoAsm() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.noAsm().newBuilder(DbObject.class);
        JdbcMapperDbObjectTest.addColumn(builder);
        final JdbcMapper mapper = (JdbcMapper)builder.mapper();
        DbHelper.testDbObjectFromDb((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement ps) throws Exception {
                mapper.stream(ps.executeQuery()).limit(1L).forEach(new Consumer<DbObject>(){

                    @Override
                    public void accept(DbObject o) {
                        try {
                            DbHelper.assertDbObjectMapping((DbObject)o);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        });
    }
}

