/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.io.IOException;
import java.sql.ResultSet;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.test.JdbcMapperFactoryHelper;
import org.simpleflatmapper.map.FieldMapperErrorHandler;
import org.simpleflatmapper.map.MapperBuilderErrorHandler;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.error.LogFieldMapperErrorHandler;
import org.simpleflatmapper.map.mapper.MapperImpl;
import org.simpleflatmapper.reflect.BiInstantiator;
import org.simpleflatmapper.test.beans.DbObject;
import org.simpleflatmapper.test.beans.Foo;

public class JdbcMapperErrorTest {
    @Test
    public void testHandleMapperErrorSetterNotFound() throws NoSuchMethodException, SecurityException, IOException {
        MapperBuilderErrorHandler errorHandler = (MapperBuilderErrorHandler)Mockito.mock(MapperBuilderErrorHandler.class);
        JdbcMapperBuilder builder = ((JdbcMapperFactory)JdbcMapperFactoryHelper.asm().mapperBuilderErrorHandler(errorHandler)).newBuilder(DbObject.class);
        builder.addMapping("id", 1);
        builder.addMapping("notthere1", 2);
        ((MapperBuilderErrorHandler)Mockito.verify((Object)errorHandler)).propertyNotFound(DbObject.class, "notthere1");
        builder.addMapping("notthere3");
        ((MapperBuilderErrorHandler)Mockito.verify((Object)errorHandler)).propertyNotFound(DbObject.class, "notthere3");
    }

    @Test
    public void testHandleMapperErrorGetterNotFound() throws NoSuchMethodException, SecurityException, IOException {
        MapperBuilderErrorHandler errorHandler = (MapperBuilderErrorHandler)Mockito.mock(MapperBuilderErrorHandler.class);
        JdbcMapperBuilder builder = ((JdbcMapperFactory)JdbcMapperFactoryHelper.asm().mapperBuilderErrorHandler(errorHandler)).newBuilder(MyClass.class);
        builder.addMapping("prop", 1);
        builder.mapper();
        ((MapperBuilderErrorHandler)Mockito.verify((Object)errorHandler)).accessorNotFound("Could not find Getter for ColumnKey [columnName=prop, columnIndex=1, sqlType=-99999] returning type class org.simpleflatmapper.test.beans.Foo path prop. See https://github.com/arnaudroger/SimpleFlatMapper/wiki/Errors_CSFM_GETTER_NOT_FOUND");
    }

    @Test
    public void setChangeFieldMapperErrorHandler() throws NoSuchMethodException, SecurityException, IOException {
        JdbcMapperBuilder builder = ((JdbcMapperFactory)JdbcMapperFactoryHelper.asm().fieldMapperErrorHandler((FieldMapperErrorHandler)new LogFieldMapperErrorHandler())).newBuilder(DbObject.class);
        builder.addMapping("id");
    }

    @Test
    public void testInstantiatorError() {
        MapperImpl mapper = new MapperImpl(null, null, (BiInstantiator)new BiInstantiator<ResultSet, MappingContext<? super ResultSet>, DbObject>(){

            public DbObject newInstance(ResultSet s, MappingContext<? super ResultSet> context) throws Exception {
                throw new IOException();
            }
        });
        try {
            mapper.map(null, null);
            Assert.fail((String)"Expected error");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IOException));
        }
    }

    public static class MyClass {
        public Foo prop;
    }
}

