/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.simpleflatmapper.converter.Context;
import org.simpleflatmapper.jdbc.DynamicJdbcMapper;
import org.simpleflatmapper.jdbc.JdbcColumnKey;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.test.JdbcMapperFactoryHelper;
import org.simpleflatmapper.jdbc.test.MockDbObjectResultSet;
import org.simpleflatmapper.map.ConsumerErrorHandler;
import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.FieldMapperErrorHandler;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.getter.GetterFactory;
import org.simpleflatmapper.test.beans.DbFinalObject;
import org.simpleflatmapper.test.beans.DbObject;
import org.simpleflatmapper.test.beans.DbObjectWithAlias;
import org.simpleflatmapper.test.beans.DbObjectWithEmptyAlias;
import org.simpleflatmapper.test.jdbc.DbHelper;
import org.simpleflatmapper.test.jdbc.TestRowHandler;
import org.simpleflatmapper.tuple.Tuple2;
import org.simpleflatmapper.tuple.Tuples;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.ListCollector;
import org.simpleflatmapper.util.TypeReference;

public class JdbcMapperFactoryTest {
    JdbcMapperFactory asmFactory = JdbcMapperFactoryHelper.asm();
    JdbcMapperFactory nonAsmFactory = JdbcMapperFactoryHelper.noAsm();

    @Test
    public void testFactoryOnTuples() {
        Assert.assertNotNull((Object)this.asmFactory.newMapper((Type)Tuples.typeDef((Type[])new Type[]{Date.class, Date.class})));
        Assert.assertNotNull((Object)this.asmFactory.newBuilder((Type)Tuples.typeDef((Type[])new Type[]{Date.class, Date.class})));
    }

    @Test
    public void testFactoryOnReferenceType() throws SQLException {
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData metaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)rs.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getColumnCount()).thenReturn((Object)2);
        Mockito.when((Object)metaData.getColumnLabel(1)).thenReturn((Object)"e0");
        Mockito.when((Object)metaData.getColumnLabel(2)).thenReturn((Object)"e1");
        Mockito.when((Object)metaData.getColumnType(1)).thenReturn((Object)12);
        Mockito.when((Object)metaData.getColumnType(2)).thenReturn((Object)12);
        Mockito.when((Object)rs.next()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)rs.getString(1)).thenReturn((Object)"v1");
        Mockito.when((Object)rs.getString(2)).thenReturn((Object)"v2");
        Tuple2 tuple2 = (Tuple2)JdbcMapperFactoryHelper.asm().newMapper((TypeReference)new TypeReference<Tuple2<String, String>>(){}).iterator(rs).next();
        Assert.assertEquals((Object)"v1", (Object)tuple2.first());
        Assert.assertEquals((Object)"v2", (Object)tuple2.second());
    }

    @Test
    public void testFactoryOnReferenceTypeStatic() throws SQLException {
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.next()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)rs.getString(1)).thenReturn((Object)"v1");
        Mockito.when((Object)rs.getString(2)).thenReturn((Object)"v2");
        Tuple2 tuple2 = (Tuple2)((JdbcMapper)((JdbcMapperBuilder)((JdbcMapperBuilder)JdbcMapperFactoryHelper.asm().newBuilder((TypeReference)new TypeReference<Tuple2<String, String>>(){}).addMapping("e0")).addMapping("e1")).mapper()).iterator(rs).next();
        Assert.assertEquals((Object)"v1", (Object)tuple2.first());
        Assert.assertEquals((Object)"v2", (Object)tuple2.second());
    }

    @Test
    public void testAsmDbObjectMappingFromDbWithMetaData() throws Exception {
        DbHelper.testDbObjectFromDb((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement ps) throws Exception {
                ResultSet rs = ps.executeQuery();
                JdbcMapper mapper = JdbcMapperFactoryTest.this.asmFactory.newMapper(DbObject.class, rs.getMetaData());
                JdbcMapperFactoryTest.this.assertMapPsDbObject(rs, (JdbcMapper<DbObject>)mapper);
            }
        });
    }

    @Test
    public void testAsmDbObjectWithAliasMappingFromDbWithMetaData() throws Exception {
        DbHelper.testDbObjectFromDb((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement ps) throws Exception {
                ResultSet rs = ps.executeQuery();
                JdbcMapper mapper = JdbcMapperFactoryTest.this.asmFactory.newMapper(DbObjectWithAlias.class, rs.getMetaData());
                JdbcMapperFactoryTest.this.assertMapPsDbObjectWithAlias(rs, (JdbcMapper<DbObjectWithAlias>)mapper);
            }
        });
    }

    @Test
    public void testAsmDbObjectWithEmptyAliasMappingFromDbWithMetaData() throws Exception {
        DbHelper.testDbObjectFromDb((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement ps) throws Exception {
                ResultSet rs = ps.executeQuery();
                JdbcMapper mapper = JdbcMapperFactoryTest.this.asmFactory.newMapper(DbObjectWithEmptyAlias.class, rs.getMetaData());
                JdbcMapperFactoryTest.this.assertMapPsDbObjectWithEmptyAlias(rs, (JdbcMapper<DbObjectWithEmptyAlias>)mapper);
            }
        });
    }

    @Test
    public void testNonAsmDbObjectMappingFromDbWithMetaData() throws Exception {
        DbHelper.testDbObjectFromDb((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement ps) throws Exception {
                ResultSet rs = ps.executeQuery();
                JdbcMapper mapper = JdbcMapperFactoryTest.this.nonAsmFactory.newMapper(DbObject.class, rs.getMetaData());
                JdbcMapperFactoryTest.this.assertMapPsDbObject(rs, (JdbcMapper<DbObject>)mapper);
            }
        });
    }

    @Test
    public void testAsmDbObjectMappingFromDbDynamic() throws SQLException, Exception, ParseException {
        DbHelper.testDbObjectFromDb((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement ps) throws Exception {
                DynamicJdbcMapper mapper = JdbcMapperFactoryTest.this.asmFactory.newMapper(DbObject.class);
                JdbcMapperFactoryTest.this.assertMapPsDbObject(ps.executeQuery(), (JdbcMapper<DbObject>)((JdbcMapper)mapper));
            }
        });
    }

    @Test
    public void testNonAsmDbObjectMappingFromDbDynamic() throws SQLException, Exception, ParseException {
        DbHelper.testDbObjectFromDb((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement ps) throws Exception {
                DynamicJdbcMapper mapper = JdbcMapperFactoryTest.this.nonAsmFactory.newMapper(DbObject.class);
                JdbcMapperFactoryTest.this.assertMapPsDbObject(ps.executeQuery(), (JdbcMapper<DbObject>)((JdbcMapper)mapper));
            }
        });
    }

    @Test
    public void testAsmFinalDbObjectMappingFromDbDynamic() throws SQLException, Exception, ParseException {
        DbHelper.testDbObjectFromDb((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement ps) throws Exception {
                DynamicJdbcMapper mapper = JdbcMapperFactoryTest.this.asmFactory.newMapper(DbFinalObject.class);
                JdbcMapperFactoryTest.this.assertMapPsFinalDbObject(ps.executeQuery(), (JdbcMapper<DbFinalObject>)((JdbcMapper)mapper));
            }
        });
    }

    @Test
    public void testNonAsmFinalDbObjectMappingFromDbDynamic() throws SQLException, Exception, ParseException {
        DbHelper.testDbObjectFromDb((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement ps) throws Exception {
                DynamicJdbcMapper mapper = JdbcMapperFactoryTest.this.nonAsmFactory.newMapper(DbFinalObject.class);
                JdbcMapperFactoryTest.this.assertMapPsFinalDbObject(ps.executeQuery(), (JdbcMapper<DbFinalObject>)((JdbcMapper)mapper));
            }
        });
    }

    @Test
    public void testFieldErrorHandling() throws SQLException, Exception, ParseException {
        FieldMapperErrorHandler fieldMapperErrorHandler = (FieldMapperErrorHandler)Mockito.mock(FieldMapperErrorHandler.class);
        final Exception exception = new Exception("Error!");
        JdbcMapper mapper = (JdbcMapper)((JdbcMapperBuilder)((JdbcMapperFactory)JdbcMapperFactoryHelper.asm().fieldMapperErrorHandler(fieldMapperErrorHandler)).addCustomFieldMapper("id", (FieldMapper)new FieldMapper<ResultSet, DbObject>(){

            public void mapTo(ResultSet source, DbObject target, MappingContext<? super ResultSet> mappingContext) throws Exception {
                throw exception;
            }
        }).newBuilder(DbObject.class).addMapping("id")).mapper();
        List list = ((ListCollector)mapper.forEach((ResultSet)new MockDbObjectResultSet(1), (CheckedConsumer)new ListCollector())).getList();
        Assert.assertNotNull(list.get(0));
        ((FieldMapperErrorHandler)Mockito.verify((Object)fieldMapperErrorHandler)).errorMappingField((Object)((JdbcColumnKey)Mockito.eq((Object)new JdbcColumnKey("id", 1))), Mockito.any(), Mockito.same((Object)((DbObject)list.get(0))), (Exception)Mockito.same((Object)exception), (Context)Mockito.any(Context.class));
    }

    @Test
    public void testFieldErrorHandlingOnResultSet() throws SQLException, Exception, ParseException {
        FieldMapperErrorHandler fieldMapperErrorHandler = (FieldMapperErrorHandler)Mockito.mock(FieldMapperErrorHandler.class);
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        SQLException exception = new SQLException("Error!");
        JdbcMapper mapper = (JdbcMapper)((JdbcMapperBuilder)((JdbcMapperFactory)JdbcMapperFactoryHelper.asm().fieldMapperErrorHandler(fieldMapperErrorHandler)).newBuilder(DbObject.class).addMapping("id")).mapper();
        Mockito.when((Object)rs.next()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)rs.getLong(1)).thenThrow(new Throwable[]{exception});
        List list = ((ListCollector)mapper.forEach(rs, (CheckedConsumer)new ListCollector())).getList();
        Assert.assertNotNull(list.get(0));
        ((FieldMapperErrorHandler)Mockito.verify((Object)fieldMapperErrorHandler)).errorMappingField((Object)((JdbcColumnKey)Mockito.eq((Object)new JdbcColumnKey("id", 1))), Mockito.any(), Mockito.same((Object)((DbObject)list.get(0))), (Exception)Mockito.same((Object)exception), (Context)Mockito.any(Context.class));
    }

    @Test
    public void testSetCheckedConsumerError() throws SQLException {
        ConsumerErrorHandler errorHandler = (ConsumerErrorHandler)Mockito.mock(ConsumerErrorHandler.class);
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.next()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when((Object)rs.getLong(1)).thenReturn((Object)1L);
        final SQLException exception = new SQLException("Error!");
        JdbcMapper mapper = (JdbcMapper)((JdbcMapperBuilder)((JdbcMapperFactory)JdbcMapperFactoryHelper.asm().consumerErrorHandler(errorHandler)).newBuilder(DbObject.class).addMapping("id")).mapper();
        mapper.forEach(rs, (CheckedConsumer)new CheckedConsumer<DbObject>(){

            public void accept(DbObject dbObject) throws Exception {
                throw exception;
            }
        });
        ((ConsumerErrorHandler)Mockito.verify((Object)errorHandler, (VerificationMode)Mockito.times((int)2))).handlerError((Throwable)Mockito.same((Object)exception), Mockito.any(DbObject.class));
    }

    @Test
    public void testCustomGetterFactory() throws SQLException {
        JdbcMapper mapper = (JdbcMapper)((JdbcMapperBuilder)JdbcMapperFactoryHelper.asm().getterFactory((GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type target, JdbcColumnKey key, Object ... properties) {
                return new Getter(){

                    public Object get(Object target) throws Exception {
                        return "Hello!";
                    }
                };
            }
        }).newBuilder(DbObject.class).addMapping("name")).mapper();
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.next()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        DbObject object = (DbObject)mapper.iterator(rs).next();
        Assert.assertEquals((Object)"Hello!", (Object)object.getName());
    }

    private void assertMapPsDbObject(ResultSet rs, JdbcMapper<DbObject> mapper) throws Exception, ParseException {
        List list = ((ListCollector)mapper.forEach(rs, (CheckedConsumer)new ListCollector())).getList();
        Assert.assertEquals((long)1L, (long)list.size());
        DbHelper.assertDbObjectMapping((DbObject)((DbObject)list.get(0)));
    }

    private void assertMapPsDbObjectWithAlias(ResultSet rs, JdbcMapper<DbObjectWithAlias> mapper) throws Exception, ParseException {
        List list = ((ListCollector)mapper.forEach(rs, (CheckedConsumer)new ListCollector())).getList();
        Assert.assertEquals((long)1L, (long)list.size());
        DbHelper.assertDbObjectWithAliasMapping((DbObjectWithAlias)((DbObjectWithAlias)list.get(0)));
    }

    private void assertMapPsDbObjectWithEmptyAlias(ResultSet rs, JdbcMapper<DbObjectWithEmptyAlias> mapper) throws Exception, ParseException {
        List list = ((ListCollector)mapper.forEach(rs, (CheckedConsumer)new ListCollector())).getList();
        Assert.assertEquals((long)1L, (long)list.size());
        DbHelper.assertDbObjectWithEmptyAliasMapping((DbObjectWithEmptyAlias)((DbObjectWithEmptyAlias)list.get(0)));
    }

    private void assertMapPsFinalDbObject(ResultSet rs, JdbcMapper<DbFinalObject> mapper) throws Exception, ParseException {
        List list = ((ListCollector)mapper.forEach(rs, (CheckedConsumer)new ListCollector())).getList();
        Assert.assertEquals((long)1L, (long)list.size());
        DbHelper.assertDbObjectMapping((DbFinalObject)((DbFinalObject)list.get(0)));
    }
}

