/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.test.JdbcMapperFactoryHelper;
import org.simpleflatmapper.test.beans.DbFinalListObject;
import org.simpleflatmapper.test.beans.DbListObject;
import org.simpleflatmapper.test.beans.DbListOfString;
import org.simpleflatmapper.test.beans.DbObject;
import org.simpleflatmapper.test.jdbc.DbHelper;
import org.simpleflatmapper.test.jdbc.TestRowHandler;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.ListCollector;
import org.simpleflatmapper.util.TypeReference;

public class JdbcMapperListTest {
    private static final String QUERY = "select 12 as id,  1 as objects_1_id, 'name 1' as objects_1_name, 'name1@mail.com' as objects_1_email, TIMESTAMP'2014-03-04 11:10:03' as objects_1_creation_time, 2 as objects_1_type_ordinal, 'type4' as objects_1_type_name,  1 as objects_2_id, 'name 1' as objects_2_name, 'name1@mail.com' as objects_2_email, TIMESTAMP'2014-03-04 11:10:03' as objects_2_creation_time, 2 as objects_2_type_ordinal, 'type4' as objects_2_type_name  from TEST_DB_OBJECT ";
    private static final String QUERY_LIST = "select  1 as objects_1_id, 'name 1' as objects_1_name, 'name1@mail.com' as objects_1_email, TIMESTAMP'2014-03-04 11:10:03' as objects_1_creation_time, 2 as objects_1_type_ordinal, 'type4' as objects_1_type_name,  1 as objects_2_id, 'name 1' as objects_2_name, 'name1@mail.com' as objects_2_email, TIMESTAMP'2014-03-04 11:10:03' as objects_2_creation_time, 2 as objects_2_type_ordinal, 'type4' as objects_2_type_name  from TEST_DB_OBJECT ";
    private static final String QUERY_STRING_LIST = "select 12 as id,  'value1' as objects_1, 'value2' as objects_2 from TEST_DB_OBJECT ";
    private static final String QUERY_STRING_LIST_NULL = "select 12 as id,  null as objects_0 from TEST_DB_OBJECT ";

    @Test
    public void testMapInnerObjectWithStaticMapperNoAsm() throws Exception {
        DbHelper.testQuery((TestRowHandler)new TestDbListObject(false), (String)QUERY);
    }

    @Test
    public void testMapInnerObjectWithStaticMapperAsm() throws Exception {
        DbHelper.testQuery((TestRowHandler)new TestDbListObject(true), (String)QUERY);
    }

    @Test
    public void testMapInnerFinalObjectWithStaticMapperNoAsm() throws Exception {
        DbHelper.testQuery((TestRowHandler)new TestDbFinalListObject(false), (String)QUERY);
    }

    @Test
    public void testMapInnerFinalObjectWithStaticMapperAsm() throws Exception {
        DbHelper.testQuery((TestRowHandler)new TestDbFinalListObject(true), (String)QUERY);
    }

    @Test
    public void testMapDbListOfStringNoAsm() throws Exception {
        DbHelper.testQuery((TestRowHandler)new TestDbListString(false), (String)QUERY_STRING_LIST);
    }

    @Test
    public void testMapListOfStringAsm() throws Exception {
        DbHelper.testQuery((TestRowHandler)new TestDbListString(true), (String)QUERY_STRING_LIST);
    }

    @Test
    public void testMapTestListObjectNoAsm() throws Exception {
        DbHelper.testQuery((TestRowHandler)new TestListObject(false), (String)QUERY_LIST);
    }

    @Test
    public void testMapTestListObjectAsm() throws Exception {
        DbHelper.testQuery((TestRowHandler)new TestListObject(true), (String)QUERY_LIST);
    }

    @Test
    public void testIssue458Asm() throws Exception {
        this.testIssue458(true);
    }

    @Test
    public void testIssue458NoAsm() throws Exception {
        this.testIssue458(false);
    }

    private void testIssue458(boolean useAsm) throws SQLException {
        JdbcMapper mapper = (JdbcMapper)((JdbcMapperFactory)((JdbcMapperFactory)JdbcMapperFactory.newInstance().useAsm(useAsm)).addKeys(new String[]{"id", "photos_name", "videos_name"})).newBuilder(Col.class).addMapping("id", 1, 4).addMapping("name", 2, 12).addMapping("photos_name", 3, 12).addMapping("videos_name", 4, 12).mapper();
        Connection dbConnection = DbHelper.getDbConnection((DbHelper.TargetDB)DbHelper.TargetDB.POSTGRESQL);
        if (dbConnection == null) {
            return;
        }
        Statement statement = dbConnection.createStatement();
        ResultSet rs = statement.executeQuery("with \n\tcols(id, name, photos, videos) AS (VALUES(2, 'trees', 'some_photo.jpg', 'videos'), (2, 'trees', 'some_photo2.jpg', 'videos'), (4, 'flowers', null, 'some_videos.mpg'))\nselect id, name, photos, videos\nfrom cols\norder by id");
        List list = ((ListCollector)mapper.forEach(rs, (CheckedConsumer)new ListCollector())).getList();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Col)list.get(0)).id);
        Assert.assertEquals((Object)"trees", (Object)((Col)list.get(0)).name);
        Assert.assertEquals(Arrays.asList("some_photo.jpg", "some_photo2.jpg"), (Object)((Col)list.get(0)).photos);
        Assert.assertEquals(Arrays.asList("videos"), (Object)((Col)list.get(0)).videos);
        Assert.assertEquals((long)4L, (long)((Col)list.get(1)).id);
        Assert.assertEquals((Object)"flowers", (Object)((Col)list.get(1)).name);
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((Col)list.get(1)).photos);
        Assert.assertEquals(Arrays.asList("some_videos.mpg"), (Object)((Col)list.get(1)).videos);
        dbConnection.close();
    }

    public static final class Col {
        private final int id;
        private final String name;
        private final List<String> photos;
        private final List<String> videos;

        public Col(int id, String name, List<String> photos, List<String> videos) {
            this.id = id;
            this.name = name;
            this.photos = photos;
            this.videos = videos;
        }
    }

    public static final class Media {
        private final String name;

        public Media(String name) {
            this.name = name;
        }
    }

    private static final class TestDbListStringWithNull
    implements TestRowHandler<PreparedStatement> {
        private final boolean asm;

        public TestDbListStringWithNull(boolean asm) {
            this.asm = asm;
        }

        public void handle(PreparedStatement t) throws Exception {
            ResultSet rs = t.executeQuery();
            JdbcMapper mapper = (JdbcMapper)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperFactory)JdbcMapperFactoryHelper.asm().useAsm(this.asm)).newBuilder(DbListOfString.class).addKey("id")).addKey("objects_0")).addMapping(rs.getMetaData()).mapper();
            List strings = ((ListCollector)mapper.forEach(rs, (CheckedConsumer)new ListCollector())).getList();
            Assert.assertEquals((long)1L, (long)strings.size());
            Assert.assertEquals((long)12L, (long)((DbListOfString)strings.get(0)).getId());
            Assert.assertEquals((long)1L, (long)((DbListOfString)strings.get(0)).getObjects().size());
        }
    }

    private static final class TestDbListString
    implements TestRowHandler<PreparedStatement> {
        private final boolean asm;

        public TestDbListString(boolean asm) {
            this.asm = asm;
        }

        public void handle(PreparedStatement t) throws Exception {
            ResultSet rs = t.executeQuery();
            JdbcMapper mapper = (JdbcMapper)((JdbcMapperFactory)JdbcMapperFactoryHelper.asm().useAsm(this.asm)).newBuilder(DbListOfString.class).addMapping(rs.getMetaData()).mapper();
            rs.next();
            DbListOfString object = (DbListOfString)mapper.map(rs);
            Assert.assertEquals((long)12L, (long)object.getId());
            Assert.assertEquals((long)3L, (long)object.getObjects().size());
            Assert.assertNull(object.getObjects().get(0));
            Assert.assertEquals((Object)"value1", object.getObjects().get(1));
            Assert.assertEquals((Object)"value2", object.getObjects().get(2));
        }
    }

    private static final class TestListObject
    implements TestRowHandler<PreparedStatement> {
        private final boolean asm;
        private List<DbObject> list;

        public TestListObject(boolean asm) {
            this.asm = asm;
        }

        public void handle(PreparedStatement t) throws Exception {
            ResultSet rs = t.executeQuery();
            JdbcMapper mapper = (JdbcMapper)((JdbcMapperFactory)JdbcMapperFactoryHelper.asm().useAsm(this.asm)).newBuilder((TypeReference)new TypeReference<List<DbObject>>(){}).addMapping(rs.getMetaData()).mapper();
            rs.next();
            this.list = (List)mapper.map(rs);
            Assert.assertEquals((long)3L, (long)this.list.size());
            Assert.assertNull((Object)this.list.get(0));
            DbHelper.assertDbObjectMapping((DbObject)this.list.get(1));
            DbHelper.assertDbObjectMapping((DbObject)this.list.get(2));
        }
    }

    private static final class TestDbListObject
    implements TestRowHandler<PreparedStatement> {
        private final boolean asm;

        public TestDbListObject(boolean asm) {
            this.asm = asm;
        }

        public void handle(PreparedStatement t) throws Exception {
            ResultSet rs = t.executeQuery();
            JdbcMapper mapper = (JdbcMapper)((JdbcMapperFactory)JdbcMapperFactoryHelper.asm().useAsm(this.asm)).newBuilder(DbListObject.class).addMapping(rs.getMetaData()).mapper();
            rs.next();
            DbListObject object = (DbListObject)mapper.map(rs);
            Assert.assertEquals((long)12L, (long)object.getId());
            Assert.assertEquals((long)3L, (long)object.getObjects().size());
            Assert.assertNull(object.getObjects().get(0));
            DbHelper.assertDbObjectMapping((DbObject)((DbObject)object.getObjects().get(1)));
            DbHelper.assertDbObjectMapping((DbObject)((DbObject)object.getObjects().get(2)));
        }
    }

    private static final class TestDbFinalListObject
    implements TestRowHandler<PreparedStatement> {
        private final boolean asm;

        public TestDbFinalListObject(boolean asm) {
            this.asm = asm;
        }

        public void handle(PreparedStatement t) throws Exception {
            ResultSet rs = t.executeQuery();
            JdbcMapper mapper = (JdbcMapper)((JdbcMapperFactory)JdbcMapperFactoryHelper.asm().useAsm(this.asm)).newBuilder(DbFinalListObject.class).addMapping(rs.getMetaData()).mapper();
            rs.next();
            DbFinalListObject object = (DbFinalListObject)mapper.map(rs);
            Assert.assertEquals((long)12L, (long)object.getId());
            Assert.assertEquals((long)3L, (long)object.getObjects().size());
            Assert.assertNull(object.getObjects().get(0));
            DbHelper.assertDbObjectMapping((DbObject)((DbObject)object.getObjects().get(1)));
            DbHelper.assertDbObjectMapping((DbObject)((DbObject)object.getObjects().get(2)));
        }
    }
}

