/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.test.JdbcMapperFactoryHelper;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.test.beans.Db1DeepObject;
import org.simpleflatmapper.test.beans.Db2DeepObject;
import org.simpleflatmapper.test.beans.DbFinal1DeepObject;
import org.simpleflatmapper.test.beans.DbFinalObject;
import org.simpleflatmapper.test.beans.DbObject;
import org.simpleflatmapper.test.jdbc.DbHelper;
import org.simpleflatmapper.test.jdbc.TestRowHandler;

public class JdbcMapperSubObjectTest {
    private static final String QUERY = "select 33 as id, 'value' as value,  id as db_object_id, name as db_object_name, email as db_object_email, creation_time as db_object_creation_time, type_ordinal as db_object_type_ordinal, type_name as db_object_type_name from TEST_DB_OBJECT where id = 1 ";

    @Test
    public void testMapInnerObjectWithStaticMapper() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(Db1DeepObject.class);
        this.addColumns(builder);
        final JdbcMapper mapper = (JdbcMapper)builder.mapper();
        DbHelper.testQuery((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement t) throws Exception {
                ResultSet rs = t.executeQuery();
                rs.next();
                Db1DeepObject object = (Db1DeepObject)mapper.map(rs);
                Assert.assertEquals((long)33L, (long)object.getId());
                Assert.assertEquals((Object)"value", (Object)object.getValue());
                DbHelper.assertDbObjectMapping((DbObject)object.getDbObject());
            }
        }, (String)QUERY);
    }

    @Test
    public void testMapInnerObjectWithColumnDefinition() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(Db1DeepObject.class);
        FieldMapperColumnDefinition columnDefinition = FieldMapperColumnDefinition.customGetter((Getter)new Getter<ResultSet, String>(){

            public String get(ResultSet target) throws Exception {
                return "ov1";
            }
        });
        builder.addMapping("db_object_name", (ColumnDefinition)columnDefinition);
        JdbcMapper mapper = (JdbcMapper)builder.mapper();
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.getString(1)).thenReturn((Object)"name1");
        Mockito.when((Object)rs.next()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Db1DeepObject next = (Db1DeepObject)mapper.iterator(rs).next();
        Assert.assertEquals((Object)"ov1", (Object)next.getDbObject().getName());
    }

    @Test
    public void testMapInnerFinalObjectWithStaticMapper() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(DbFinal1DeepObject.class);
        this.addColumns(builder);
        final JdbcMapper mapper = (JdbcMapper)builder.mapper();
        DbHelper.testQuery((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement t) throws Exception {
                ResultSet rs = t.executeQuery();
                rs.next();
                DbFinal1DeepObject object = (DbFinal1DeepObject)mapper.map(rs);
                Assert.assertEquals((long)33L, (long)object.getId());
                Assert.assertEquals((Object)"value", (Object)object.getValue());
                DbHelper.assertDbObjectMapping((DbFinalObject)object.getDbObject());
            }
        }, (String)QUERY);
    }

    @Test
    public void testMapInnerObject2LevelWithStaticMapper() throws Exception {
        final JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(Db2DeepObject.class);
        DbHelper.testQuery((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement t) throws Exception {
                ResultSet rs = t.executeQuery();
                JdbcMapper mapper = (JdbcMapper)builder.addMapping(rs.getMetaData()).mapper();
                rs.next();
                Db2DeepObject object = (Db2DeepObject)mapper.map(rs);
                Assert.assertEquals((long)33L, (long)object.getId());
                Assert.assertEquals((long)32L, (long)object.getDb1Object().getId());
                Assert.assertEquals((Object)"value12", (Object)object.getDb1Object().getValue());
                DbHelper.assertDbObjectMapping((DbObject)object.getDb1Object().getDbObject());
            }
        }, (String)"select 33 as id, 32 as db1_object_id,  'value12' as db1_object_value,  id as db1_object_db_object_id, name as db1_object_db_object_name, email as db1_object_db_object_email, creation_time as db1_object_db_object_creation_time, type_ordinal as db1_object_db_object_type_ordinal, type_name as db1_object_db_object_type_name from TEST_DB_OBJECT where id = 1 ");
    }

    public void addColumns(JdbcMapperBuilder<?> builder) {
        builder.addMapping("id");
        builder.addMapping("value");
        builder.addMapping("db_object_id");
        builder.addMapping("db_object_name");
        builder.addMapping("db_object_email");
        builder.addMapping("db_object_creation_time");
        builder.addMapping("db_object_type_ordinal");
        builder.addMapping("db_object_type_name");
    }
}

