/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.simpleflatmapper.jdbc.DynamicJdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.test.JdbcMapperFactoryHelper;
import org.simpleflatmapper.test.beans.DbObject;

public class JdbcMapperToStringTest {
    @Test
    public void testStaticJdbcMapperNoAsm() {
        JdbcMapper mapper = (JdbcMapper)((JdbcMapperBuilder)((JdbcMapperBuilder)JdbcMapperFactoryHelper.noAsm().newBuilder(DbObject.class).addMapping("id")).addMapping("name")).mapper();
        Assert.assertTrue((boolean)mapper.toString().startsWith("JdbcMapperImpl"));
    }

    @Test
    public void testStaticJdbcMapperAsm() {
        JdbcMapper mapper = (JdbcMapper)((JdbcMapperBuilder)((JdbcMapperBuilder)JdbcMapperFactoryHelper.asm().newBuilder(DbObject.class).addMapping("id")).addMapping("name")).mapper();
        String input = mapper.toString();
        Assert.assertTrue((boolean)input.startsWith("JdbcMapperImpl"));
    }

    @Test
    public void testDynamicJdbcMapperNoAsm() throws SQLException {
        DynamicJdbcMapper mapper = JdbcMapperFactoryHelper.noAsm().newMapper(DbObject.class);
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData metaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)rs.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getColumnCount()).thenReturn((Object)1);
        Mockito.when((Object)metaData.getColumnLabel(1)).thenReturn((Object)"id");
        mapper.iterator(rs);
        Assert.assertNotNull((Object)mapper.toString());
    }
}

