/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.test.JdbcMapperFactoryHelper;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.test.jdbc.DbHelper;
import org.simpleflatmapper.test.jdbc.TestRowHandler;
import org.simpleflatmapper.tuple.Tuple2;
import org.simpleflatmapper.tuple.Tuple3;
import org.simpleflatmapper.tuple.Tuple4;
import org.simpleflatmapper.tuple.Tuple5;
import org.simpleflatmapper.tuple.Tuples;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.ListCollector;
import org.simpleflatmapper.util.TypeReference;

public class JdbcMapperTupleTest {
    @Test
    public void testTuple2OnString() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder((Type)Tuples.typeDef((Type[])new Type[]{String.class, String.class}));
        builder.addMapping("element0");
        builder.addMapping("element1");
        final JdbcMapper mapper = (JdbcMapper)builder.mapper();
        DbHelper.testQuery((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(PreparedStatement preparedStatement) throws Exception {
                ResultSet rs = preparedStatement.executeQuery();
                try {
                    List list = ((ListCollector)mapper.forEach(rs, (CheckedConsumer)new ListCollector())).getList();
                    Assert.assertEquals((long)1L, (long)list.size());
                    Tuple2 tuple2 = (Tuple2)list.get(0);
                    Assert.assertEquals((Object)"1", (Object)tuple2.getElement0());
                    Assert.assertEquals((Object)"2", (Object)tuple2.getElement1());
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }, (String)"select '1', '2' from  TEST_DB_OBJECT where id = 1");
    }

    @Test
    public void testTuple3OnString() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder((Type)Tuples.typeDef((Type[])new Type[]{String.class, String.class, Long.class}));
        builder.addMapping("element0");
        builder.addMapping("element1");
        builder.addMapping("element2");
        final JdbcMapper mapper = (JdbcMapper)builder.mapper();
        DbHelper.testQuery((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(PreparedStatement preparedStatement) throws Exception {
                ResultSet rs = preparedStatement.executeQuery();
                try {
                    List list = ((ListCollector)mapper.forEach(rs, (CheckedConsumer)new ListCollector())).getList();
                    Assert.assertEquals((long)1L, (long)list.size());
                    Tuple3 tuple = (Tuple3)list.get(0);
                    Assert.assertEquals((Object)"1", (Object)tuple.getElement0());
                    Assert.assertEquals((Object)"2", (Object)tuple.getElement1());
                    Assert.assertEquals((long)3L, (long)((Long)tuple.getElement2()));
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }, (String)"select '1', '2', 3 from  TEST_DB_OBJECT where id = 1");
    }

    @Test
    public void testTuple4OnString() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder((Type)Tuples.typeDef((Type[])new Type[]{String.class, String.class, Long.class, Integer.class}));
        builder.addMapping("element0");
        builder.addMapping("element1");
        builder.addMapping("element2");
        builder.addMapping("element3");
        final JdbcMapper mapper = (JdbcMapper)builder.mapper();
        DbHelper.testQuery((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(PreparedStatement preparedStatement) throws Exception {
                ResultSet rs = preparedStatement.executeQuery();
                try {
                    List list = ((ListCollector)mapper.forEach(rs, (CheckedConsumer)new ListCollector())).getList();
                    Assert.assertEquals((long)1L, (long)list.size());
                    Tuple4 tuple = (Tuple4)list.get(0);
                    Assert.assertEquals((Object)"1", (Object)tuple.getElement0());
                    Assert.assertEquals((Object)"2", (Object)tuple.getElement1());
                    Assert.assertEquals((long)3L, (long)((Long)tuple.getElement2()));
                    Assert.assertEquals((long)4L, (long)((Integer)tuple.getElement3()).intValue());
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }, (String)"select '1', '2', 3, 4 from  TEST_DB_OBJECT where id = 1");
    }

    @Test
    public void testTuple5OnString() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder((Type)Tuples.typeDef((Type[])new Type[]{String.class, String.class, Long.class, Integer.class, Float.class}));
        builder.addMapping("element0");
        builder.addMapping("element1");
        builder.addMapping("element2");
        builder.addMapping("element3");
        builder.addMapping("element4");
        final JdbcMapper mapper = (JdbcMapper)builder.mapper();
        DbHelper.testQuery((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(PreparedStatement preparedStatement) throws Exception {
                ResultSet rs = preparedStatement.executeQuery();
                try {
                    List list = ((ListCollector)mapper.forEach(rs, (CheckedConsumer)new ListCollector())).getList();
                    Assert.assertEquals((long)1L, (long)list.size());
                    Tuple5 tuple = (Tuple5)list.get(0);
                    Assert.assertEquals((Object)"1", (Object)tuple.first());
                    Assert.assertEquals((Object)"2", (Object)tuple.second());
                    Assert.assertEquals((long)3L, (long)((Long)tuple.third()));
                    Assert.assertEquals((long)4L, (long)((Integer)tuple.fourth()).intValue());
                    Assert.assertEquals((double)3.3, (double)((Float)tuple.fifth()).floatValue(), (double)1.0E-4);
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }, (String)"select '1', '2', 3, 4, 3.3 from  TEST_DB_OBJECT where id = 1");
    }

    @Test
    public void testIssue450() throws Exception {
        JdbcMapper mapper = (JdbcMapper)((JdbcMapperFactory)((JdbcMapperFactory)JdbcMapperFactory.newInstance().reflectionService(ReflectionService.newInstance().withSelfScoreFullName(true))).addKeys(new String[]{"resource_id", "id"})).newBuilder((TypeReference)new TypeReference<Tuple2<Integer, List<Privilege>>>(){}).addMapping("id", 1, 4).addMapping("name", 2, 12).addMapping("resource_id", 3, 4).mapper();
        Connection dbConnection = DbHelper.getDbConnection((DbHelper.TargetDB)DbHelper.TargetDB.POSTGRESQL);
        if (dbConnection == null) {
            return;
        }
        Statement statement = dbConnection.createStatement();
        ResultSet rs = statement.executeQuery("with \n\tresource_privileges(resource_id, privilege_id) AS (VALUES(1, 10), (2, 10), (3, 11)),\n\tprivilege (id, name) as (values(10, 'write'), ('11', 'read'))\nselect privilege.id, privilege.name, resource_privileges.resource_id\nfrom privilege join resource_privileges on resource_privileges.privilege_id = privilege.id\norder by resource_privileges.resource_id");
        List list = ((ListCollector)mapper.forEach(rs, (CheckedConsumer)new ListCollector())).getList();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)10, (Object)((Tuple2)list.get(0)).first());
        Assert.assertEquals((Object)11, (Object)((Tuple2)list.get(1)).first());
        Assert.assertEquals((long)2L, (long)((List)((Tuple2)list.get(0)).second()).size());
        Assert.assertEquals((long)1L, (long)((List)((Tuple2)list.get(1)).second()).size());
        dbConnection.close();
    }

    public static class Privilege {
        public int id;
        public String name;
    }
}

