/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.test.JdbcMapperFactoryHelper;
import org.simpleflatmapper.tuple.Tuple2;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.ListCollector;
import org.simpleflatmapper.util.TypeReference;

public class JoinJdbcMapperOnTupleTest {
    private JdbcMapperFactory asmJdbcMapperFactory = (JdbcMapperFactory)JdbcMapperFactoryHelper.asm().addKeys(new String[]{"0_id", "1_id"});
    private JdbcMapperFactory noAsmJdbcMapperFactory = (JdbcMapperFactory)JdbcMapperFactoryHelper.noAsm().addKeys(new String[]{"0_id", "1_id"});
    final String[] columns = new String[]{"0_id", "0_name", "1_id", "1_name"};
    final Object[][] rows = new Object[][]{{1, "professor1", 3, "student3"}, {1, "professor1", 4, "student4"}, {2, "professor2", 4, "student4"}, {3, "professor3", null, null}};
    final Object[][] rowsInverted = new Object[][]{{3, "student3", 1, "professor1"}, {4, "student4", 1, "professor1"}, {4, "student4", 2, "professor2"}, {null, null, 3, "professor3"}};

    @Test
    public void testTupleJoin() throws Exception {
        this.validateBuilder((JdbcMapperBuilder<Tuple2<Person, List<Person>>>)this.asmJdbcMapperFactory.newBuilder((TypeReference)new TypeReference<Tuple2<Person, List<Person>>>(){}));
    }

    @Test
    public void testTupleJoinNoAsm() throws Exception {
        this.validateBuilder((JdbcMapperBuilder<Tuple2<Person, List<Person>>>)this.noAsmJdbcMapperFactory.newBuilder((TypeReference)new TypeReference<Tuple2<Person, List<Person>>>(){}));
    }

    @Test
    public void testTupleJoinInverted() throws Exception {
        this.validateBuilderInverted((JdbcMapperBuilder<Tuple2<List<Person>, Person>>)this.asmJdbcMapperFactory.newBuilder((TypeReference)new TypeReference<Tuple2<List<Person>, Person>>(){}));
    }

    @Test
    public void testTupleJoinNoAsmInverted() throws Exception {
        this.validateBuilderInverted((JdbcMapperBuilder<Tuple2<List<Person>, Person>>)this.noAsmJdbcMapperFactory.newBuilder((TypeReference)new TypeReference<Tuple2<List<Person>, Person>>(){}));
    }

    public static ResultSet setUpResultSetMock(final String[] columns, final Object[][] rows) throws SQLException {
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData metaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)metaData.getColumnCount()).thenReturn((Object)columns.length);
        Mockito.when((Object)metaData.getColumnLabel(Matchers.anyInt())).then((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocationOnMock) throws Throwable {
                return columns[-1 + (Integer)invocationOnMock.getArguments()[0]];
            }
        });
        Mockito.when((Object)rs.getMetaData()).thenReturn((Object)metaData);
        final AtomicInteger ai = new AtomicInteger();
        Mockito.when((Object)rs.next()).then((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocationOnMock) throws Throwable {
                return ai.getAndIncrement() < rows.length;
            }
        });
        Answer<Object> getValue = new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                Object[] row = rows[ai.get() - 1];
                Integer col = -1 + (Integer)invocationOnMock.getArguments()[0];
                return row[col];
            }
        };
        Mockito.when((Object)rs.getInt(Matchers.anyInt())).then((Answer)getValue);
        Mockito.when((Object)rs.getString(Matchers.anyInt())).then((Answer)getValue);
        Mockito.when((Object)rs.getObject(Matchers.anyInt())).then((Answer)getValue);
        return rs;
    }

    public static void validateProfessors(List<Tuple2<Person, List<Person>>> professors) {
        Assert.assertEquals((String)"we get 3 professors from the resultset", (long)3L, (long)professors.size());
        Person professor = (Person)professors.get(0).getElement0();
        List students = (List)professors.get(0).getElement1();
        JoinJdbcMapperOnTupleTest.assertPersonEquals(1, "professor1", professor);
        Assert.assertEquals((String)"has 2 students", (long)2L, (long)students.size());
        JoinJdbcMapperOnTupleTest.assertPersonEquals(3, "student3", (Person)students.get(0));
        JoinJdbcMapperOnTupleTest.assertPersonEquals(4, "student4", (Person)students.get(1));
        professor = (Person)professors.get(1).first();
        students = (List)professors.get(1).second();
        JoinJdbcMapperOnTupleTest.assertPersonEquals(2, "professor2", professor);
        Assert.assertEquals((String)"has 1 student", (long)1L, (long)students.size());
        JoinJdbcMapperOnTupleTest.assertPersonEquals(4, "student4", (Person)students.get(0));
        professor = (Person)professors.get(2).first();
        students = (List)professors.get(2).second();
        JoinJdbcMapperOnTupleTest.assertPersonEquals(3, "professor3", professor);
        Assert.assertTrue((String)"professor3 has no students", (boolean)students.isEmpty());
    }

    private void validateProfessorsInverted(List<Tuple2<List<Person>, Person>> professors) {
        Assert.assertEquals((String)"we get 3 professors from the resultset", (long)3L, (long)professors.size());
        Person professor = (Person)professors.get(0).getElement1();
        List students = (List)professors.get(0).getElement0();
        JoinJdbcMapperOnTupleTest.assertPersonEquals(1, "professor1", professor);
        Assert.assertEquals((String)"has 2 students", (long)2L, (long)students.size());
        JoinJdbcMapperOnTupleTest.assertPersonEquals(3, "student3", (Person)students.get(0));
        JoinJdbcMapperOnTupleTest.assertPersonEquals(4, "student4", (Person)students.get(1));
        professor = (Person)professors.get(1).getElement1();
        students = (List)professors.get(1).getElement0();
        JoinJdbcMapperOnTupleTest.assertPersonEquals(2, "professor2", professor);
        Assert.assertEquals((String)"has 1 student", (long)1L, (long)students.size());
        JoinJdbcMapperOnTupleTest.assertPersonEquals(4, "student4", (Person)students.get(0));
        professor = (Person)professors.get(2).getElement1();
        students = (List)professors.get(2).getElement0();
        JoinJdbcMapperOnTupleTest.assertPersonEquals(3, "professor3", professor);
        Assert.assertTrue((String)"professor3 has no students", (boolean)students.isEmpty());
    }

    public static void assertPersonEquals(int id, String name, Person person) {
        Assert.assertEquals((long)id, (long)person.getId());
        Assert.assertEquals((Object)name, (Object)person.getName());
    }

    private void validateBuilder(JdbcMapperBuilder<Tuple2<Person, List<Person>>> builder) throws Exception {
        for (int i = 0; i < this.columns.length; ++i) {
            builder.addMapping(this.columns[i]);
        }
        JdbcMapper mapper = (JdbcMapper)builder.mapper();
        List professors = ((ListCollector)mapper.forEach(JoinJdbcMapperOnTupleTest.setUpResultSetMock(this.columns, this.rows), (CheckedConsumer)new ListCollector())).getList();
        JoinJdbcMapperOnTupleTest.validateProfessors(professors);
    }

    private void validateBuilderInverted(JdbcMapperBuilder<Tuple2<List<Person>, Person>> builder) throws Exception {
        for (int i = 0; i < this.columns.length; ++i) {
            builder.addMapping(this.columns[i]);
        }
        JdbcMapper mapper = (JdbcMapper)builder.mapper();
        List professors = ((ListCollector)mapper.forEach(JoinJdbcMapperOnTupleTest.setUpResultSetMock(this.columns, this.rowsInverted), (CheckedConsumer)new ListCollector())).getList();
        this.validateProfessorsInverted(professors);
    }

    public static class Person {
        private int id;
        private String name;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

