/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.simpleflatmapper.jdbc.DynamicJdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.test.JdbcMapperFactoryHelper;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.test.beans.Professor;
import org.simpleflatmapper.test.beans.ProfessorC;
import org.simpleflatmapper.test.beans.ProfessorField;
import org.simpleflatmapper.test.beans.ProfessorGS;
import org.simpleflatmapper.test.jdbc.JoinTest;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.ListCollector;

public class JoinJdbcMapperTest {
    private JdbcMapperFactory asmJdbcMapperFactory = (JdbcMapperFactory)JdbcMapperFactoryHelper.asm().addKeys(new String[]{"id", "students_id"});
    private JdbcMapperFactory noAsmJdbcMapperFactory = (JdbcMapperFactory)JdbcMapperFactoryHelper.noAsm().addKeys(new String[]{"id", "students_id"});
    private JdbcMapperFactory userJdbcMapperFactory = (JdbcMapperFactory)JdbcMapperFactoryHelper.noAsm().addKeys(new String[]{"uuid"});

    @Test
    public void testJoinTableFields() throws Exception {
        this.validateMapper((JdbcMapper)this.asmJdbcMapperFactory.newMapper(ProfessorField.class));
    }

    @Test
    public void testJoinTableGSNoAsm() throws Exception {
        this.validateMapper((JdbcMapper)this.noAsmJdbcMapperFactory.newMapper(ProfessorGS.class));
    }

    @Test
    public void testJoinTableGS() throws Exception {
        this.validateMapper((JdbcMapper)this.asmJdbcMapperFactory.newMapper(ProfessorGS.class));
    }

    @Test
    public void testJoinTableGS2Joins() throws Exception {
        this.validateMapper((JdbcMapper)this.asmJdbcMapperFactory.newMapper(ProfessorGS.class));
    }

    @Test
    public void testJoinTableC() throws Exception {
        this.validateMapper((JdbcMapper)this.asmJdbcMapperFactory.newMapper(ProfessorC.class));
    }

    @Test
    public void testJoinTableCNoAsm() throws Exception {
        DynamicJdbcMapper mapper = this.noAsmJdbcMapperFactory.newMapper(ProfessorC.class);
        this.validateMapper((JdbcMapper)mapper);
        Assert.assertNotNull((Object)mapper.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinTableCNoAsmMultiThread() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(4);
        try {
            DynamicJdbcMapper mapper = this.noAsmJdbcMapperFactory.newMapper(ProfessorC.class);
            ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(100);
            for (int i = 0; i < 300; ++i) {
                futures.add(executor.submit(new Callable<Object>((JdbcMapper)mapper){
                    final /* synthetic */ JdbcMapper val$mapper;
                    {
                        this.val$mapper = jdbcMapper;
                    }

                    @Override
                    public Object call() throws Exception {
                        JoinJdbcMapperTest.this.validateMapper(this.val$mapper);
                        return null;
                    }
                }));
            }
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            executor.shutdown();
        }
    }

    @Test
    public void testJoinTableGSManualMapping() throws Exception {
        JdbcMapper mapper = (JdbcMapper)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)JdbcMapperFactoryHelper.asm().newBuilder(ProfessorGS.class).addKey("id")).addMapping("name")).addKey("students_id")).addMapping("students_name")).addMapping("students_phones_value")).mapper();
        this.validateMapper(mapper);
    }

    private ResultSet setUpResultSetMock() throws SQLException {
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData metaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        final String[] columns = new String[]{"id", "name", "students_id", "students_name", "students_phones_value"};
        Mockito.when((Object)metaData.getColumnCount()).thenReturn((Object)columns.length);
        Mockito.when((Object)metaData.getColumnLabel(Matchers.anyInt())).then((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocationOnMock) throws Throwable {
                return columns[-1 + (Integer)invocationOnMock.getArguments()[0]];
            }
        });
        Mockito.when((Object)rs.getMetaData()).thenReturn((Object)metaData);
        final AtomicInteger ai = new AtomicInteger();
        Mockito.when((Object)rs.next()).then((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocationOnMock) throws Throwable {
                return ai.getAndIncrement() < JoinTest.ROWS.length;
            }
        });
        Answer<Object> getValue = new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                Object[] row = JoinTest.ROWS[ai.get() - 1];
                Integer col = -1 + (Integer)invocationOnMock.getArguments()[0];
                return row[col];
            }
        };
        Mockito.when((Object)rs.getInt(Matchers.anyInt())).then((Answer)getValue);
        Mockito.when((Object)rs.getString(Matchers.anyInt())).then((Answer)getValue);
        Mockito.when((Object)rs.getObject(Matchers.anyInt())).then((Answer)getValue);
        return rs;
    }

    private <T extends Professor<?>> void validateMapper(JdbcMapper<T> mapper) throws Exception {
        ArrayList<Professor> professors = ((ListCollector)mapper.forEach(this.setUpResultSetMock(), (CheckedConsumer)new ListCollector())).getList();
        JoinTest.validateProfessors((List)professors);
        JoinTest.validateProfessors(mapper.stream(this.setUpResultSetMock()).collect(Collectors.toList()));
        JoinTest.validateProfessors(mapper.stream(this.setUpResultSetMock()).limit(3L).collect(Collectors.toList()));
        Iterator iterator = mapper.iterator(this.setUpResultSetMock());
        professors = new ArrayList<Professor>();
        while (iterator.hasNext()) {
            professors.add((Professor)iterator.next());
        }
        JoinTest.validateProfessors(professors);
        ResultSet rs = this.setUpResultSetMock();
        rs.next();
        MappingContext mappingContext = mapper.newMappingContext((Object)rs);
        mappingContext.broke((Object)rs);
        Professor professor = (Professor)mapper.map((Object)rs, mappingContext);
        JoinTest.validateProfessorMap((Professor)professor);
        rs.next();
        mappingContext.broke((Object)rs);
        rs.next();
        mappingContext.broke((Object)rs);
    }

    @Test
    public void testUser() throws SQLException {
        JdbcMapper mapper = (JdbcMapper)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)this.userJdbcMapperFactory.newBuilder(User.class).addKey("id")).addMapping("name")).addMapping("roles_name")).mapper();
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.next()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when((Object)rs.getInt(1)).thenReturn((Object)1, (Object[])new Integer[]{1});
        Mockito.when((Object)rs.getString(2)).thenReturn((Object)"n1", (Object[])new String[]{"n1"});
        Mockito.when((Object)rs.getString(3)).thenReturn((Object)"r1", (Object[])new String[]{"r2"});
        Iterator iterator = mapper.iterator(rs);
        User u = (User)iterator.next();
        Assert.assertEquals((long)1L, (long)u.id);
        Assert.assertEquals((Object)"n1", (Object)u.name);
        Assert.assertEquals((long)2L, (long)u.roles.size());
    }

    public static class Role {
        public String name;
    }

    public static class User {
        public int id;
        public String name;
        public Set<Role> roles;
    }
}

