/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.simpleflatmapper.jdbc.Crud;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.impl.ColumnMeta;
import org.simpleflatmapper.jdbc.impl.CrudFactory;
import org.simpleflatmapper.jdbc.impl.CrudMeta;
import org.simpleflatmapper.jdbc.impl.DatabaseMeta;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.test.beans.DbObject;

public class MysqlCrudTest {
    @Test
    public void testBatch() throws SQLException {
        int i;
        Connection connection = (Connection)Mockito.mock(Connection.class);
        PreparedStatement ps = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)connection.prepareStatement("INSERT INTO `TEST`(id) VALUES(?), (?), (?), (?), (?), (?), (?), (?), (?), (?)")).thenReturn((Object)ps);
        Crud objectCrud = CrudFactory.newInstance((ClassMeta)ReflectionService.newInstance().getClassMeta(DbObject.class), (ClassMeta)ReflectionService.newInstance().getClassMeta(Long.class), (CrudMeta)new CrudMeta(new DatabaseMeta("MySQL", 5, 5), null, "TEST", new ColumnMeta[]{new ColumnMeta("id", 4, true, null)}), (JdbcMapperFactory)JdbcMapperFactory.newInstance());
        ArrayList<DbObject> values = new ArrayList<DbObject>();
        for (i = 0; i < 10; ++i) {
            values.add(DbObject.newInstance());
        }
        objectCrud.create(connection, values);
        for (i = 0; i < 10; ++i) {
            ((PreparedStatement)Mockito.verify((Object)ps)).setLong(i + 1, ((DbObject)values.get(i)).getId());
        }
        ((PreparedStatement)Mockito.verify((Object)ps)).executeUpdate();
    }

    @Test
    public void testSplitBatch() throws SQLException {
        int i;
        Connection connection = (Connection)Mockito.mock(Connection.class);
        PreparedStatement ps = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        PreparedStatement ps2 = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)connection.prepareStatement("INSERT INTO `TEST`(id) VALUES(?), (?), (?), (?), (?), (?), (?), (?), (?), (?)")).thenReturn((Object)ps);
        Mockito.when((Object)connection.prepareStatement("INSERT INTO `TEST`(id) VALUES(?), (?), (?), (?), (?)")).thenReturn((Object)ps2);
        Mockito.when((Object)ps.executeUpdate()).thenThrow(new Throwable[]{MysqlCrudTest.getPacketTooBigException()});
        Crud objectCrud = CrudFactory.newInstance((ClassMeta)ReflectionService.newInstance().getClassMeta(DbObject.class), (ClassMeta)ReflectionService.newInstance().getClassMeta(Long.class), (CrudMeta)new CrudMeta(new DatabaseMeta("MySQL", 5, 5), null, "TEST", new ColumnMeta[]{new ColumnMeta("id", 4, true, null)}), (JdbcMapperFactory)JdbcMapperFactory.newInstance());
        int batchsize = 10;
        ArrayList<DbObject> values = new ArrayList<DbObject>();
        for (i = 0; i < 10; ++i) {
            values.add(DbObject.newInstance());
        }
        objectCrud.create(connection, values);
        for (i = 0; i < 10; ++i) {
            ((PreparedStatement)Mockito.verify((Object)ps)).setLong(i + 1, ((DbObject)values.get(i)).getId());
        }
        ((PreparedStatement)Mockito.verify((Object)ps)).executeUpdate();
        for (i = 0; i < 5; ++i) {
            ArgumentCaptor captor = ArgumentCaptor.forClass(Long.class);
            ((PreparedStatement)Mockito.verify((Object)ps2, (VerificationMode)Mockito.times((int)2))).setLong(Matchers.eq((int)(i + 1)), (Long)captor.capture());
            List allValues = captor.getAllValues();
            Assert.assertEquals((long)((DbObject)values.get(i)).getId(), (long)((Long)allValues.get(0)));
            Assert.assertEquals((long)((DbObject)values.get(i + 5)).getId(), (long)((Long)allValues.get(1)));
        }
        ((PreparedStatement)Mockito.verify((Object)ps)).executeUpdate();
    }

    public static SQLException getPacketTooBigException() {
        try {
            return (SQLException)Class.forName("com.mysql.cj.jdbc.exceptions.PacketTooBigException").getConstructor(Long.TYPE, Long.TYPE).newInstance(60L, 60L);
        }
        catch (Exception e) {
            try {
                return (SQLException)Class.forName("com.mysql.jdbc.PacketTooBigException").getConstructor(Long.TYPE, Long.TYPE).newInstance(60L, 60L);
            }
            catch (Exception e1) {
                throw new Error(e1);
            }
        }
    }
}

