/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.simpleflatmapper.jdbc.Crud;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.test.KeyCapture;
import org.simpleflatmapper.jdbc.test.MysqlCrudTest;
import org.simpleflatmapper.test.beans.DbObject;
import org.simpleflatmapper.test.jdbc.DbHelper;

public class MysqlMultiRowsBatchInsertCrudTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBatchInsertCreateOneQuery() throws SQLException {
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)DbHelper.TargetDB.MYSQL);
        if (connection == null) {
            System.err.println("Db MySQL not available");
            return;
        }
        try {
            Crud objectCrud = JdbcMapperFactory.newInstance().crud(DbObject.class, Long.class).table(connection, "TEST_DB_OBJECT");
            Connection mockConnection = (Connection)Mockito.mock(Connection.class);
            PreparedStatement preparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
            ArgumentCaptor queryCapture = ArgumentCaptor.forClass(String.class);
            Mockito.when((Object)mockConnection.prepareStatement((String)queryCapture.capture())).thenReturn((Object)preparedStatement);
            objectCrud.create(mockConnection, Arrays.asList(DbObject.newInstance(), DbObject.newInstance()));
            Assert.assertEquals((Object)"INSERT INTO test_db_object(id, name, email, creation_Time, type_ordinal, type_name) VALUES(?, ?, ?, ?, ?, ?), (?, ?, ?, ?, ?, ?)".toLowerCase(), (Object)((String)queryCapture.getValue()).toLowerCase());
            ((PreparedStatement)Mockito.verify((Object)preparedStatement, (VerificationMode)Mockito.never())).addBatch();
            ((PreparedStatement)Mockito.verify((Object)preparedStatement, (VerificationMode)Mockito.never())).executeBatch();
            ((PreparedStatement)Mockito.verify((Object)preparedStatement)).executeUpdate();
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBatchUpsertCreateOneQuery() throws SQLException {
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)DbHelper.TargetDB.MYSQL);
        if (connection == null) {
            System.err.println("Db MySQL not available");
            return;
        }
        try {
            Crud objectCrud = JdbcMapperFactory.newInstance().crud(DbObject.class, Long.class).table(connection, "TEST_DB_OBJECT");
            Connection mockConnection = (Connection)Mockito.mock(Connection.class);
            PreparedStatement preparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
            ArgumentCaptor queryCapture = ArgumentCaptor.forClass(String.class);
            Mockito.when((Object)mockConnection.prepareStatement((String)queryCapture.capture())).thenReturn((Object)preparedStatement);
            objectCrud.createOrUpdate(mockConnection, Arrays.asList(DbObject.newInstance(), DbObject.newInstance()));
            Assert.assertEquals((Object)"INSERT INTO test_db_object(id, name, email, creation_Time, type_ordinal, type_name) VALUES(?, ?, ?, ?, ?, ?), (?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE name = VALUES(name), email = VALUES(email), creation_Time = VALUES(creation_Time), type_ordinal = VALUES(type_ordinal), type_name = VALUES(type_name)".toLowerCase(), (Object)((String)queryCapture.getValue()).toLowerCase());
            ((PreparedStatement)Mockito.verify((Object)preparedStatement, (VerificationMode)Mockito.never())).addBatch();
            ((PreparedStatement)Mockito.verify((Object)preparedStatement, (VerificationMode)Mockito.never())).executeBatch();
            ((PreparedStatement)Mockito.verify((Object)preparedStatement)).executeUpdate();
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBatchUpsertOnDb() throws SQLException {
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)DbHelper.TargetDB.MYSQL);
        if (connection == null) {
            System.err.println("Db MySQL not available");
            return;
        }
        try {
            Crud objectCrud = JdbcMapperFactory.newInstance().crud(DbObject.class, Long.class).table(connection, "TEST_DB_OBJECT");
            DbObject object1 = DbObject.newInstance();
            DbObject object2 = DbObject.newInstance();
            objectCrud.create(connection, (Object)object1);
            object1.setName("BatchUpdate");
            object2.setName("BatchUpdate");
            objectCrud.createOrUpdate(connection, Arrays.asList(object1, object2));
            ResultSet resultSet = connection.createStatement().executeQuery("SELECT count(*) FROM TEST_DB_OBJECT WHERE name = 'BatchUpdate'");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((long)2L, (long)resultSet.getInt(1));
            Assert.assertEquals((Object)object1, (Object)objectCrud.read(connection, (Object)object1.getId()));
            Assert.assertEquals((Object)object2, (Object)objectCrud.read(connection, (Object)object2.getId()));
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsert() throws SQLException {
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)DbHelper.TargetDB.MYSQL);
        if (connection == null) {
            System.err.println("Db MySQL not available");
            return;
        }
        try {
            Crud objectCrud = JdbcMapperFactory.newInstance().crud(DbObject.class, Long.class).table(connection, "TEST_DB_OBJECT");
            DbObject object = DbObject.newInstance();
            objectCrud.createOrUpdate(connection, (Object)object);
            Assert.assertEquals((Object)object, (Object)objectCrud.read(connection, (Object)object.getId()));
            object.setEmail("Updated Email");
            objectCrud.createOrUpdate(connection, (Object)object);
            Assert.assertEquals((Object)object, (Object)objectCrud.read(connection, (Object)object.getId()));
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertAutoIncUniqueIndexOnIndex() throws SQLException {
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)DbHelper.TargetDB.MYSQL);
        if (connection == null) {
            System.err.println("Db MySQL not available");
            return;
        }
        try {
            Crud objectCrud = JdbcMapperFactory.newInstance().crud(DbObject.class, Long.class).table(connection, "TEST_DB_OBJECT_AUTOINC_NAMEINDEX");
            DbObject object = DbObject.newInstance();
            Long key = (Long)((KeyCapture)objectCrud.createOrUpdate(connection, (Object)object, new KeyCapture())).getKey();
            Assert.assertNotNull((Object)key);
            object.setId(key.longValue());
            Assert.assertEquals((Object)object, (Object)objectCrud.read(connection, (Object)object.getId()));
            object.setEmail("Updated Email " + key);
            key = (Long)((KeyCapture)objectCrud.createOrUpdate(connection, (Object)object, new KeyCapture())).getKey();
            System.out.println("key = " + key + " current id " + object.getId());
            ResultSet resultSet = connection.createStatement().executeQuery("SELECT count(*) FROM TEST_DB_OBJECT_AUTOINC_NAMEINDEX WHERE email = '" + object.getEmail() + "'");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((long)1L, (long)resultSet.getInt(1));
            Assert.assertEquals((Object)object, (Object)objectCrud.read(connection, (Object)object.getId()));
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBatchInsertSizeReducer() throws SQLException {
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)DbHelper.TargetDB.MYSQL);
        if (connection == null) {
            System.err.println("Db MySQL not available");
            return;
        }
        try {
            Crud objectCrud = JdbcMapperFactory.newInstance().crud(DbObject.class, Long.class).table(connection, "TEST_DB_OBJECT");
            Connection mockConnection = (Connection)Mockito.mock(Connection.class);
            PreparedStatement preparedStatementFail = (PreparedStatement)Mockito.mock(PreparedStatement.class);
            PreparedStatement preparedStatementSucceed = (PreparedStatement)Mockito.mock(PreparedStatement.class);
            ArrayList<DbObject> values = new ArrayList<DbObject>();
            for (int i = 0; i < 101; ++i) {
                values.add(DbObject.newInstance());
            }
            Mockito.when((Object)mockConnection.prepareStatement(Matchers.anyString())).thenReturn((Object)preparedStatementFail, (Object[])new PreparedStatement[]{preparedStatementFail, preparedStatementSucceed});
            Mockito.when((Object)preparedStatementFail.executeUpdate()).thenThrow(new Throwable[]{MysqlCrudTest.getPacketTooBigException()});
            objectCrud.create(mockConnection, values);
            ((PreparedStatement)Mockito.verify((Object)preparedStatementFail, (VerificationMode)Mockito.times((int)2))).executeUpdate();
            ((PreparedStatement)Mockito.verify((Object)preparedStatementSucceed, (VerificationMode)Mockito.times((int)5))).executeUpdate();
        }
        finally {
            connection.close();
        }
    }
}

