/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.simpleflatmapper.jdbc.Crud;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.map.property.AutoGeneratedProperty;
import org.simpleflatmapper.map.property.KeyProperty;
import org.simpleflatmapper.test.beans.DbObject;
import org.simpleflatmapper.test.jdbc.DbHelper;
import org.simpleflatmapper.util.CheckedConsumer;

public class PostgresqlCrudTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBatchUpsertOnDb() throws SQLException {
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)DbHelper.TargetDB.POSTGRESQL);
        if (connection == null) {
            System.err.println("Db Postgresql not available");
            return;
        }
        System.out.println("connection = " + connection.getMetaData().getDatabaseMajorVersion() + "." + connection.getMetaData().getDatabaseMinorVersion());
        if (connection.getMetaData().getDatabaseMajorVersion() != 9 || connection.getMetaData().getDatabaseMinorVersion() < 5) {
            System.err.println("Db Postgresql 9.5 not available");
            return;
        }
        try {
            Crud objectCrud = JdbcMapperFactory.newInstance().crud(DbObject.class, Long.class).table(connection, "TEST_DB_OBJECT");
            DbObject object1 = DbObject.newInstance();
            DbObject object2 = DbObject.newInstance();
            objectCrud.create(connection, (Object)object1);
            object1.setName("BatchUpdate");
            object2.setName("BatchUpdate");
            objectCrud.createOrUpdate(connection, Arrays.asList(object1, object2));
            ResultSet resultSet = connection.createStatement().executeQuery("SELECT count(*) FROM TEST_DB_OBJECT WHERE name = 'BatchUpdate'");
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((long)2L, (long)resultSet.getInt(1));
            Assert.assertEquals((Object)object1, (Object)objectCrud.read(connection, (Object)object1.getId()));
            Assert.assertEquals((Object)object2, (Object)objectCrud.read(connection, (Object)object2.getId()));
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsert() throws SQLException {
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)DbHelper.TargetDB.POSTGRESQL);
        if (connection == null) {
            System.err.println("Db MySQL not available");
            return;
        }
        if (connection.getMetaData().getDatabaseMajorVersion() != 9 || connection.getMetaData().getDatabaseMinorVersion() < 5) {
            System.err.println("Db Postgresql 9.5 not available");
            return;
        }
        try {
            Crud objectCrud = JdbcMapperFactory.newInstance().crud(DbObject.class, Long.class).table(connection, "TEST_DB_OBJECT");
            DbObject object = DbObject.newInstance();
            objectCrud.createOrUpdate(connection, (Object)object);
            Assert.assertEquals((Object)object, (Object)objectCrud.read(connection, (Object)object.getId()));
            object.setEmail("Updated Email");
            objectCrud.createOrUpdate(connection, (Object)object);
            Assert.assertEquals((Object)object, (Object)objectCrud.read(connection, (Object)object.getId()));
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUUID() throws SQLException {
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)DbHelper.TargetDB.POSTGRESQL);
        if (connection == null) {
            System.err.println("Db POSTGRESQL not available");
            return;
        }
        try {
            Crud objectCrud = ((JdbcMapperFactory)JdbcMapperFactory.newInstance().addKeys(new String[]{"uid"})).crud(MyEntity.class, UUID.class).table(connection, "TEST_UUID");
            MyEntity object = new MyEntity();
            object.setId(1);
            object.setUid(UUID.randomUUID());
            object.setName("n1");
            objectCrud.create(connection, (Object)object);
            Assert.assertEquals((Object)object, (Object)objectCrud.read(connection, (Object)object.getUid()));
            object.setName("Updated Email");
            objectCrud.update(connection, (Object)object);
            Assert.assertEquals((Object)object, (Object)objectCrud.read(connection, (Object)object.getUid()));
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSerial() throws SQLException {
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)DbHelper.TargetDB.POSTGRESQL);
        if (connection == null) {
            System.err.println("Db POSTGRESQL not available");
            return;
        }
        try {
            try (Statement st = connection.createStatement();){
                st.execute("CREATE TABLE IF NOT EXISTS test_db_object_serial(  id bigserial primary key, name varchar(100),  email varchar(100), creation_Time timestamp, type_ordinal int, type_name varchar(10)  )");
            }
            Crud objectCrud = ((JdbcMapperFactory)JdbcMapperFactory.newInstance().addKeys(new String[]{"id"})).crud(DbObject.class, Long.class).table(connection, "test_db_object_serial");
            DbObject object = DbObject.newInstance();
            object.setId(-22225L);
            Long key = (objectCrud.create((Connection)connection, (Object)object, (CheckedConsumer)new CheckedConsumer<Long>(){
                Long key;

                public void accept(Long aLong) throws Exception {
                    this.key = aLong;
                }
            })).key;
            Assert.assertFalse((boolean)key.equals(object.getId()));
            object.setId(key.longValue());
            Assert.assertEquals((Object)object, (Object)objectCrud.read(connection, (Object)key));
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManualAutogenerated() throws SQLException {
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)DbHelper.TargetDB.POSTGRESQL);
        if (connection == null) {
            System.err.println("Db POSTGRESQL not available");
            return;
        }
        try {
            try (Statement st = connection.createStatement();){
                st.execute("DROP TABLE IF EXISTS test_db_object_dv");
                st.execute("CREATE TABLE test_db_object_dv(  id bigint DEFAULT 3, name varchar(100),  email varchar(100), creation_Time timestamp, type_ordinal int, type_name varchar(10)  )");
            }
            Crud objectCrud = ((JdbcMapperFactory)JdbcMapperFactory.newInstance().addColumnProperty("id", new Object[]{KeyProperty.DEFAULT, AutoGeneratedProperty.DEFAULT})).crud(DbObject.class, Long.class).table(connection, "test_db_object_dv");
            DbObject object = DbObject.newInstance();
            object.setId(-22225L);
            Long key = (objectCrud.create((Connection)connection, (Object)object, (CheckedConsumer)new CheckedConsumer<Long>(){
                Long key;

                public void accept(Long aLong) throws Exception {
                    this.key = aLong;
                }
            })).key;
            Assert.assertFalse((boolean)key.equals(object.getId()));
            object.setId(key.longValue());
            Assert.assertEquals((Object)object, (Object)objectCrud.read(connection, (Object)key));
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManualAutogeneratedFromSeq() throws SQLException {
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)DbHelper.TargetDB.POSTGRESQL);
        if (connection == null) {
            System.err.println("Db POSTGRESQL not available");
            return;
        }
        try {
            try (Statement st = connection.createStatement();){
                st.execute("DROP TABLE IF EXISTS test_db_object_seq");
                st.execute("DROP SEQUENCE IF EXISTS test_seq_seq");
                st.execute("CREATE SEQUENCE test_seq_seq");
                st.execute("CREATE TABLE test_db_object_seq(  id bigint primary key, name varchar(100),  email varchar(100), creation_Time timestamp, type_ordinal int, type_name varchar(10)  )");
            }
            Crud objectCrud = ((JdbcMapperFactory)JdbcMapperFactory.newInstance().addColumnProperty("id", new Object[]{KeyProperty.DEFAULT, AutoGeneratedProperty.of((String)"nextval('test_seq_seq')")})).crud(DbObject.class, Long.class).table(connection, "test_db_object_seq");
            DbObject object = DbObject.newInstance();
            object.setId(-22225L);
            Long key = (objectCrud.create((Connection)connection, (Object)object, (CheckedConsumer)new CheckedConsumer<Long>(){
                Long key;

                public void accept(Long aLong) throws Exception {
                    this.key = aLong;
                }
            })).key;
            Assert.assertFalse((boolean)key.equals(object.getId()));
            object.setId(key.longValue());
            Assert.assertEquals((Object)object, (Object)objectCrud.read(connection, (Object)key));
            object = DbObject.newInstance();
            object.setId(-22225L);
            key = (objectCrud.create((Connection)connection, Arrays.asList(new DbObject[]{object}), (CheckedConsumer)new CheckedConsumer<Long>(){
                Long key;

                public void accept(Long aLong) throws Exception {
                    if (this.key != null) {
                        throw new IllegalArgumentException();
                    }
                    this.key = aLong;
                }
            })).key;
            Assert.assertFalse((boolean)key.equals(object.getId()));
            object.setId(key.longValue());
            Assert.assertEquals((Object)object, (Object)objectCrud.read(connection, (Object)key));
            object = DbObject.newInstance();
            object.setId(-22225L);
            try {
                key = (objectCrud.createOrUpdate((Connection)connection, (Object)object, (CheckedConsumer)new CheckedConsumer<Long>(){
                    Long key;

                    public void accept(Long aLong) throws Exception {
                        this.key = aLong;
                    }
                })).key;
                Assert.assertFalse((boolean)key.equals(object.getId()));
                object.setId(key.longValue());
                Assert.assertEquals((Object)object, (Object)objectCrud.read(connection, (Object)key));
                key = (objectCrud.createOrUpdate((Connection)connection, Arrays.asList(new DbObject[]{object}), (CheckedConsumer)new CheckedConsumer<Long>(){
                    Long key;

                    public void accept(Long aLong) throws Exception {
                        if (this.key != null) {
                            throw new IllegalArgumentException();
                        }
                        this.key = aLong;
                    }
                })).key;
                Assert.assertFalse((boolean)key.equals(object.getId()));
                object.setId(key.longValue());
                Assert.assertEquals((Object)object, (Object)objectCrud.read(connection, (Object)key));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        finally {
            connection.close();
        }
    }

    public static class MyEntity {
        private int _id;
        private UUID _uid;
        private String _name;

        public int getId() {
            return this._id;
        }

        public void setId(int value) {
            this._id = value;
        }

        public UUID getUid() {
            return this._uid;
        }

        public void setUid(UUID value) {
            this._uid = value;
        }

        public String getName() {
            return this._name;
        }

        public void setName(String value) {
            this._name = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyEntity myEntity = (MyEntity)o;
            if (this._id != myEntity._id) {
                return false;
            }
            if (this._uid != null ? !this._uid.equals(myEntity._uid) : myEntity._uid != null) {
                return false;
            }
            return this._name != null ? this._name.equals(myEntity._name) : myEntity._name == null;
        }

        public int hashCode() {
            int result = this._id;
            result = 31 * result + (this._uid != null ? this._uid.hashCode() : 0);
            result = 31 * result + (this._name != null ? this._name.hashCode() : 0);
            return result;
        }
    }
}

