/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalTime;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.simpleflatmapper.jdbc.JdbcColumnKey;
import org.simpleflatmapper.jdbc.impl.PreparedStatementSetterFactory;
import org.simpleflatmapper.jdbc.test.impl.getter.ResultSetGetterFactoryTest;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.MapperBuilderErrorHandler;
import org.simpleflatmapper.map.error.RethrowMapperBuilderErrorHandler;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.ConstantTargetFieldMapperFactory;
import org.simpleflatmapper.map.mapper.ConstantTargetFieldMapperFactoryImpl;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.map.property.SetterFactoryProperty;
import org.simpleflatmapper.map.property.SetterProperty;
import org.simpleflatmapper.map.property.time.JavaZoneIdProperty;
import org.simpleflatmapper.map.setter.ContextualSetterFactory;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.SetterFactory;
import org.simpleflatmapper.reflect.getter.ConstantBooleanGetter;
import org.simpleflatmapper.reflect.getter.ConstantByteGetter;
import org.simpleflatmapper.reflect.getter.ConstantCharacterGetter;
import org.simpleflatmapper.reflect.getter.ConstantDoubleGetter;
import org.simpleflatmapper.reflect.getter.ConstantFloatGetter;
import org.simpleflatmapper.reflect.getter.ConstantGetter;
import org.simpleflatmapper.reflect.getter.ConstantIntGetter;
import org.simpleflatmapper.reflect.getter.ConstantLongGetter;
import org.simpleflatmapper.reflect.getter.ConstantShortGetter;
import org.simpleflatmapper.reflect.getter.NullGetter;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.test.beans.DbObject;
import org.simpleflatmapper.util.UUIDHelper;

public class PreparedStatementFieldMapperFactoryTest {
    private ConstantTargetFieldMapperFactory<PreparedStatement, JdbcColumnKey> factory;
    private PreparedStatement ps;
    private int index;

    @Before
    public void setUp() {
        this.factory = ConstantTargetFieldMapperFactoryImpl.newInstance((ContextualSetterFactory)PreparedStatementSetterFactory.INSTANCE, PreparedStatement.class);
        this.ps = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        this.index = 1;
    }

    @Test
    public void testEnumOrdinal() throws Exception {
        DbObject.Type type = DbObject.Type.type3;
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)type), (Class)DbObject.Type.class, 2, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), DbObject.Type.class, 2, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setInt(1, type.ordinal());
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 4);
    }

    @Test
    public void testEnumString() throws Exception {
        DbObject.Type type = DbObject.Type.type3;
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)type), (Class)DbObject.Type.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), DbObject.Type.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setString(1, type.name());
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 12);
    }

    @Test
    public void testMapBoolean() throws Exception {
        this.newFieldMapperAndMapToPS((Getter)new ConstantBooleanGetter(true), (Class)Boolean.TYPE, new Object[0]);
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)false), (Class)Boolean.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), Boolean.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setBoolean(1, true);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setBoolean(2, false);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(3, 16);
    }

    @Test
    public void testMapByte() throws Exception {
        this.newFieldMapperAndMapToPS((Getter)new ConstantByteGetter(2), (Class)Byte.TYPE, new Object[0]);
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)3), (Class)Byte.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), Byte.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setByte(1, (byte)2);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setByte(2, (byte)3);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(3, -6);
    }

    @Test
    public void testMapChar() throws Exception {
        this.newFieldMapperAndMapToPS((Getter)new ConstantCharacterGetter('\u0002'), (Class)Character.TYPE, new Object[0]);
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)Character.valueOf('\u0003')), (Class)Character.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), Character.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setInt(1, 2);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setInt(2, 3);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(3, 4);
    }

    @Test
    public void testMapShort() throws Exception {
        this.newFieldMapperAndMapToPS((Getter)new ConstantShortGetter(2), (Class)Short.TYPE, new Object[0]);
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)3), (Class)Short.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), Short.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setShort(1, (short)2);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setShort(2, (short)3);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(3, 5);
    }

    @Test
    public void testMapInt() throws Exception {
        this.newFieldMapperAndMapToPS((Getter)new ConstantIntGetter(2), (Class)Integer.TYPE, new Object[0]);
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)3), (Class)Integer.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), Integer.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setInt(1, 2);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setInt(2, 3);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(3, 4);
    }

    @Test
    public void testMapLong() throws Exception {
        this.newFieldMapperAndMapToPS((Getter)new ConstantLongGetter(2L), (Class)Long.TYPE, new Object[0]);
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)3L), (Class)Long.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), Long.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setLong(1, 2L);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setLong(2, 3L);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(3, -5);
    }

    @Test
    public void testMapFloat() throws Exception {
        this.newFieldMapperAndMapToPS((Getter)new ConstantFloatGetter(2.0f), (Class)Float.TYPE, new Object[0]);
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)Float.valueOf(3.0f)), (Class)Float.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), Float.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setFloat(1, 2.0f);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setFloat(2, 3.0f);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(3, 6);
    }

    @Test
    public void testMapDouble() throws Exception {
        this.newFieldMapperAndMapToPS((Getter)new ConstantDoubleGetter(2.0), (Class)Double.TYPE, new Object[0]);
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)3.0), (Class)Double.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), Double.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setDouble(1, 2.0);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setDouble(2, 3.0);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(3, 8);
    }

    @Test
    public void testMapDateNoSqlType() throws Exception {
        java.util.Date date = new java.util.Date();
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)date), (Class)java.util.Date.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), java.util.Date.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setTimestamp(1, new Timestamp(date.getTime()));
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 93);
    }

    @Test
    public void testMapSqlDate() throws Exception {
        Date date = new Date(new java.util.Date().getTime());
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)date), (Class)Date.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), Date.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setDate(1, date);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 91);
    }

    @Test
    public void testMapTimestamp() throws Exception {
        Timestamp date = new Timestamp(new java.util.Date().getTime());
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)date), (Class)Timestamp.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), Timestamp.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setTimestamp(1, date);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 93);
    }

    @Test
    public void testMapTime() throws Exception {
        Time date = new Time(new java.util.Date().getTime());
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)date), (Class)Time.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), Time.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setTime(1, date);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 92);
    }

    @Test
    public void testMapCalendar() throws Exception {
        java.util.Date date = new java.util.Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)cal), (Class)Calendar.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), Calendar.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setTimestamp(1, new Timestamp(date.getTime()));
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 93);
    }

    @Test
    public void testMapString() throws Exception {
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)"xyz"), (Class)String.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), String.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setString(1, "xyz");
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 12);
    }

    @Test
    public void testMapURL() throws Exception {
        URL url = new URL("https://github.com/arnaudroger/SimpleFlatMapper/");
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)url), (Class)URL.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), URL.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setURL(1, url);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 70);
    }

    @Test
    public void testBigDecimal() throws Exception {
        BigDecimal value = new BigDecimal("234.45");
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)BigDecimal.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), BigDecimal.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setBigDecimal(1, value);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 2);
    }

    @Test
    public void testInputStream() throws Exception {
        ByteArrayInputStream value = new ByteArrayInputStream(new byte[]{1, 2, 3, 4});
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)InputStream.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), InputStream.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setBinaryStream(1, value);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, -2);
    }

    @Test
    public void testBlob() throws Exception {
        Blob value = (Blob)Mockito.mock(Blob.class);
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)Blob.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), Blob.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setBlob(1, value);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, -2);
    }

    @Test
    public void testBytes() throws Exception {
        byte[] value = new byte[]{1, 2, 3, 4};
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)byte[].class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), byte[].class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setBytes(1, value);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, -2);
    }

    @Test
    public void testRef() throws Exception {
        Ref value = (Ref)Mockito.mock(Ref.class);
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)Ref.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), Ref.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setRef(1, value);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 2006);
    }

    @Test
    public void testReader() throws Exception {
        Reader value = (Reader)Mockito.mock(Reader.class);
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)Reader.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), Reader.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setCharacterStream(1, value);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 12);
    }

    @Test
    public void testClob() throws Exception {
        Clob value = (Clob)Mockito.mock(Clob.class);
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)Clob.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), Clob.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setClob(1, value);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 2005);
    }

    @Test
    public void testNClob() throws Exception {
        NClob value = (NClob)Mockito.mock(NClob.class);
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)NClob.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), NClob.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNClob(1, value);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 2011);
    }

    @Test
    public void testRowId() throws Exception {
        RowId value = (RowId)Mockito.mock(RowId.class);
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)RowId.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), RowId.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setRowId(1, value);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, -8);
    }

    @Test
    public void testSQLXML() throws Exception {
        SQLXML value = (SQLXML)Mockito.mock(SQLXML.class);
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)SQLXML.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), SQLXML.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setSQLXML(1, value);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 2009);
    }

    @Test
    public void testArray() throws Exception {
        Array value = (Array)Mockito.mock(Array.class);
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)Array.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), Array.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setArray(1, value);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 2003);
    }

    @Test
    public void testSQLData() throws Exception {
        ResultSetGetterFactoryTest.SQLDataImpl value = new ResultSetGetterFactoryTest.SQLDataImpl();
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)ResultSetGetterFactoryTest.SQLDataImpl.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), ResultSetGetterFactoryTest.SQLDataImpl.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setObject(1, value);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 2000);
    }

    @Test
    public void testJodaDateTime() throws Exception {
        DateTime value = new DateTime();
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)DateTime.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), DateTime.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setTimestamp(1, new Timestamp(value.getMillis()));
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 93);
    }

    @Test
    public void testJodaLocalDateTime() throws Exception {
        org.joda.time.LocalDateTime value = new org.joda.time.LocalDateTime();
        DateTimeZone dateTimeZone = DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone("America/Los_Angeles"));
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)org.joda.time.LocalDateTime.class, dateTimeZone);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), org.joda.time.LocalDateTime.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setTimestamp(1, new Timestamp(value.toDateTime(dateTimeZone).getMillis()));
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 93);
    }

    @Test
    public void testJodaLocalTime() throws Exception {
        LocalTime value = new LocalTime();
        DateTimeZone dateTimeZone = DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone("America/Los_Angeles"));
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)LocalTime.class, dateTimeZone);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), LocalTime.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setTime(1, new Time(value.toDateTimeToday(dateTimeZone).getMillis()));
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 92);
    }

    @Test
    public void testJodaLocaDate() throws Exception {
        org.joda.time.LocalDate value = new org.joda.time.LocalDate();
        DateTimeZone dateTimeZone = DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone("America/Los_Angeles"));
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)org.joda.time.LocalDate.class, dateTimeZone);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), org.joda.time.LocalDate.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setDate(1, new Date(value.toDate().getTime()));
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 91);
    }

    @Test
    public void testJodaInstant() throws Exception {
        org.joda.time.Instant value = new org.joda.time.Instant();
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)org.joda.time.Instant.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), org.joda.time.Instant.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setTimestamp(1, new Timestamp(value.getMillis()));
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 93);
    }

    @Test
    public void testUUIDString() throws Exception {
        UUID uuid = UUID.randomUUID();
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)uuid), (Class)UUID.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), UUID.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setString(1, uuid.toString());
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 12);
    }

    @Test
    public void testUUIDBinary() throws Exception {
        UUID uuid = UUID.randomUUID();
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)uuid), (Class)UUID.class, -2, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), UUID.class, -2, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setBytes(1, UUIDHelper.toBytes((UUID)uuid));
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, -2);
    }

    @Test
    public void testCustomSetter() throws Exception {
        Object o = new Object();
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter(o), (Class)Object.class, new SetterProperty((Setter)new Setter<PreparedStatement, Object>(){

            public void set(PreparedStatement target, Object value) throws Exception {
                PreparedStatementFieldMapperFactoryTest.this.ps.setString(35, "aa");
            }
        }));
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setString(35, "aa");
    }

    @Test
    public void testCustomSetterFactory() throws Exception {
        Object o = new Object();
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter(o), (Class)Object.class, new SetterFactoryProperty(new SetterFactory<PreparedStatement, PropertyMapping<?, ?, ?>>(){

            public <P> Setter<PreparedStatement, P> getSetter(PropertyMapping<?, ?, ?> arg) {
                return new Setter<PreparedStatement, P>(){

                    public void set(PreparedStatement target, P value) throws Exception {
                        PreparedStatementFieldMapperFactoryTest.this.ps.setString(36, "bb");
                    }
                };
            }
        }));
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setString(36, "bb");
    }

    @Test
    public void testJavaLocalDateTime() throws Exception {
        LocalDateTime value = LocalDateTime.now();
        ZoneId zoneId = ZoneId.of("America/Los_Angeles");
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)LocalDateTime.class, new JavaZoneIdProperty(zoneId));
        this.newFieldMapperAndMapToPS(NullGetter.getter(), LocalDateTime.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setTimestamp(1, new Timestamp(value.atZone(zoneId).toInstant().toEpochMilli()));
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 93);
    }

    @Test
    public void testJavaLocalDate() throws Exception {
        LocalDate value = LocalDate.now();
        ZoneId zoneId = ZoneId.of("America/Los_Angeles");
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)LocalDate.class, new JavaZoneIdProperty(zoneId));
        this.newFieldMapperAndMapToPS(NullGetter.getter(), LocalDate.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setDate(1, new Date(value.atStartOfDay(zoneId).toInstant().toEpochMilli()));
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 91);
    }

    @Test
    public void testJavaLocalTime() throws Exception {
        java.time.LocalTime value = java.time.LocalTime.now();
        ZoneId zoneId = ZoneId.of("America/Los_Angeles");
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)java.time.LocalTime.class, new JavaZoneIdProperty(zoneId));
        this.newFieldMapperAndMapToPS(NullGetter.getter(), java.time.LocalTime.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setTime(1, new Time(value.atDate(LocalDate.now()).atZone(zoneId).toInstant().toEpochMilli()));
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 92);
    }

    @Test
    public void testJavaZonedDateTime() throws Exception {
        ZonedDateTime value = ZonedDateTime.now();
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)ZonedDateTime.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), ZonedDateTime.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setTimestamp(1, new Timestamp(value.toInstant().toEpochMilli()));
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 93);
    }

    @Test
    public void testJavaOffsetDateTime() throws Exception {
        OffsetDateTime value = OffsetDateTime.now();
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)OffsetDateTime.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), OffsetDateTime.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setTimestamp(1, new Timestamp(value.toInstant().toEpochMilli()));
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 93);
    }

    @Test
    public void testJavaOffsetTime() throws Exception {
        OffsetTime value = OffsetTime.now();
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)OffsetTime.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), OffsetTime.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setTime(1, new Time(value.atDate(LocalDate.now()).toInstant().toEpochMilli()));
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 92);
    }

    @Test
    public void testJavaInstant() throws Exception {
        Instant value = Instant.now();
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)Instant.class, new Object[0]);
        this.newFieldMapperAndMapToPS(NullGetter.getter(), Instant.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setTimestamp(1, new Timestamp(value.toEpochMilli()));
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 93);
    }

    @Test
    public void testJavaYearMonth() throws Exception {
        YearMonth value = YearMonth.now();
        ZoneId zoneId = ZoneId.of("America/Los_Angeles");
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)YearMonth.class, new JavaZoneIdProperty(zoneId));
        this.newFieldMapperAndMapToPS(NullGetter.getter(), YearMonth.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setDate(1, new Date(value.atDay(1).atStartOfDay(zoneId).toInstant().toEpochMilli()));
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 91);
    }

    @Test
    public void testJavaYear() throws Exception {
        Year value = Year.now();
        ZoneId zoneId = ZoneId.of("America/Los_Angeles");
        this.newFieldMapperAndMapToPS((Getter)new ConstantGetter((Object)value), (Class)Year.class, new JavaZoneIdProperty(zoneId));
        this.newFieldMapperAndMapToPS(NullGetter.getter(), Year.class, new Object[0]);
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setDate(1, new Date(value.atMonthDay(MonthDay.of(Month.JANUARY, 1)).atStartOfDay(zoneId).toInstant().toEpochMilli()));
        ((PreparedStatement)Mockito.verify((Object)this.ps)).setNull(2, 91);
    }

    protected <T, P> void newFieldMapperAndMapToPS(Getter<T, P> getter, Class<P> clazz, Object ... properties) throws Exception {
        this.newFieldMapperAndMapToPS(getter, clazz, -99999, properties);
    }

    protected <T, P> void newFieldMapperAndMapToPS(Getter<T, P> getter, Class<P> clazz, int sqlType, Object ... properties) throws Exception {
        PropertyMapping<T, P, JdbcColumnKey> propertyMapping = this.newPropertyMapping(getter, clazz, sqlType, properties);
        FieldMapper fieldMapper = this.factory.newFieldMapper(propertyMapping, null, (MapperBuilderErrorHandler)RethrowMapperBuilderErrorHandler.INSTANCE);
        fieldMapper.mapTo(null, (Object)this.ps, null);
    }

    private <T, P> PropertyMapping<T, P, JdbcColumnKey> newPropertyMapping(Getter getter, Class<P> clazz, int sqltype, Object ... properties) {
        PropertyMeta propertyMeta = (PropertyMeta)Mockito.mock(PropertyMeta.class);
        Mockito.when((Object)propertyMeta.getGetter()).thenReturn((Object)getter);
        Mockito.when((Object)propertyMeta.getPropertyType()).thenReturn(clazz);
        return new PropertyMapping(propertyMeta, (FieldKey)new JdbcColumnKey("col", this.index++, sqltype), (ColumnDefinition)FieldMapperColumnDefinition.of((Object[])properties));
    }
}

