/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.QueryBinder;
import org.simpleflatmapper.jdbc.QueryPreparer;
import org.simpleflatmapper.jdbc.SqlTypeColumnProperty;
import org.simpleflatmapper.jdbc.named.NamedSqlQuery;
import org.simpleflatmapper.test.beans.DbObject;
import org.simpleflatmapper.test.jdbc.DbHelper;

public class QueryPreparerTest {
    JdbcMapperFactory jdbcMapperFactory = (JdbcMapperFactory)JdbcMapperFactory.newInstance().addColumnProperty("type_ordinal", new Object[]{SqlTypeColumnProperty.of((int)2)});

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertAndSelectWithPreparedStatementMapper() throws SQLException {
        NamedSqlQuery insertQuery = NamedSqlQuery.parse((CharSequence)"INSERT INTO test_db_object(id, name, email, creation_time, type_ordinal, type_name) values(?, ?, ?, ?, ?, ?) ");
        NamedSqlQuery selectQuery = NamedSqlQuery.parse((CharSequence)"select id, name, email, creation_time, type_ordinal, type_name from TEST_DB_OBJECT where id = ? ");
        QueryPreparer insertQueryPreparer = this.jdbcMapperFactory.from(DbObject.class).to(insertQuery);
        QueryPreparer selectQueryPreparer = this.jdbcMapperFactory.from(DbObject.class).to(selectQuery);
        DbObject dbObject = DbObject.newInstance();
        try (Connection connection = DbHelper.objectDb();){
            try (PreparedStatement ps = insertQueryPreparer.prepare(connection).bind((Object)dbObject);){
                ps.execute();
            }
            QueryBinder queryBinder = selectQueryPreparer.prepare(connection);
            ps = selectQueryPreparer.prepareStatement(connection);
            try {
                queryBinder.bindTo((Object)dbObject, ps);
                ResultSet resultSet = ps.executeQuery();
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((Object)dbObject, (Object)JdbcMapperFactory.newInstance().newMapper(DbObject.class).map(resultSet));
            }
            finally {
                ps.close();
            }
        }
    }

    @Test
    public void testSelectWithInList() throws SQLException {
        NamedSqlQuery selectInListQuery = NamedSqlQuery.parse((CharSequence)"select * from Table where name in (?) and id = ? ");
        QueryPreparer selectInListMapper = this.jdbcMapperFactory.from(QueryParamList.class).to(selectInListQuery);
        Connection conn = (Connection)Mockito.mock(Connection.class);
        PreparedStatement mps = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        QueryParamList value = new QueryParamList();
        value.name = Arrays.asList("name1", "name2");
        value.id = 3334;
        Mockito.when((Object)conn.prepareStatement("select * from Table where name in (?, ?) and id = ? ")).thenReturn((Object)mps);
        PreparedStatement ps = selectInListMapper.prepare(conn).bind((Object)value);
        Assert.assertSame((Object)mps, (Object)ps);
        ((PreparedStatement)Mockito.verify((Object)mps)).setString(1, "name1");
        ((PreparedStatement)Mockito.verify((Object)mps)).setString(2, "name2");
        ((PreparedStatement)Mockito.verify((Object)mps)).setInt(3, 3334);
    }

    @Test
    public void testSelectWithInArray() throws SQLException {
        NamedSqlQuery selectInListQuery = NamedSqlQuery.parse((CharSequence)"select * from Table where name = ? and id in (?) ");
        QueryPreparer selectInListMapper = this.jdbcMapperFactory.from(QueryParamArray.class).to(selectInListQuery);
        Connection conn = (Connection)Mockito.mock(Connection.class);
        PreparedStatement mps = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        QueryParamArray value = new QueryParamArray();
        value.name = "nannme";
        value.id = new int[]{3334, 3336};
        Mockito.when((Object)conn.prepareStatement("select * from Table where name = ? and id in (?, ?) ")).thenReturn((Object)mps);
        PreparedStatement ps = selectInListMapper.prepare(conn).bind((Object)value);
        Assert.assertSame((Object)mps, (Object)ps);
        ((PreparedStatement)Mockito.verify((Object)mps)).setString(1, "nannme");
        ((PreparedStatement)Mockito.verify((Object)mps)).setInt(2, 3334);
        ((PreparedStatement)Mockito.verify((Object)mps)).setInt(3, 3336);
    }

    @Test
    public void testQueryBinderClosePsOnException() throws SQLException {
        NamedSqlQuery query = NamedSqlQuery.parse((CharSequence)"select id, name, email, creation_time, type_ordinal, type_name from TEST_DB_OBJECT where id = ? ");
        QueryPreparer queryPreparer = this.jdbcMapperFactory.from(DbObject.class).to(query);
        Connection conn = (Connection)Mockito.mock(Connection.class);
        PreparedStatement ps = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)conn.prepareStatement(Matchers.anyString())).thenReturn((Object)ps);
        ((PreparedStatement)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException()}).when((Object)ps)).setLong(Matchers.anyInt(), Matchers.anyLong());
        try {
            queryPreparer.prepare(conn).bind((Object)DbObject.newInstance());
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ((PreparedStatement)Mockito.verify((Object)ps)).close();
    }

    public static class QueryParamList {
        public List<String> name;
        public int id;
    }

    public static class QueryParamArray {
        public String name;
        public int[] id;
    }
}

