/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test.impl;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import org.junit.Assert;
import org.junit.Test;
import org.simpleflatmapper.jdbc.JdbcTypeHelper;

public class JDBCTypeHelperTest {
    @Test
    public void testSqlTypeMapping() {
        this.testSqlTypes(Array.class, 2003);
        this.testSqlTypes(String.class, 1, 12, -16);
        this.testSqlTypes(BigDecimal.class, 2, 3);
        this.testSqlTypes(Boolean.TYPE, -7);
        this.testSqlTypes(Byte.TYPE, -6);
        this.testSqlTypes(Short.TYPE, 5);
        this.testSqlTypes(Integer.TYPE, 4);
        this.testSqlTypes(Long.TYPE, -5);
        this.testSqlTypes(Float.TYPE, 7);
        this.testSqlTypes(Double.TYPE, 6, 8);
        this.testSqlTypes(byte[].class, -2, -3, -4);
        this.testSqlTypes(Date.class, 91);
        this.testSqlTypes(Time.class, 92);
        this.testSqlTypes(Timestamp.class, 93);
        this.testSqlTypes(Clob.class, 2005);
        this.testSqlTypes(Blob.class, 2004);
        this.testSqlTypes(Struct.class, 2002);
        this.testSqlTypes(Ref.class, 2006);
        this.testSqlTypes(OffsetTime.class, 2013);
        this.testSqlTypes(OffsetDateTime.class, 2014);
    }

    @Test
    public void testSqlTypeMappingDefault() {
        this.testSqlTypes(Timestamp.class, java.util.Date.class, Timestamp.class);
        this.testSqlTypes(Time.class, OffsetTime.class);
        this.testSqlTypes(Timestamp.class, OffsetDateTime.class);
    }

    private void testSqlTypes(Class<?> expected, int ... sqlTypes) {
        for (int type : sqlTypes) {
            Assert.assertEquals(expected, (Object)JdbcTypeHelper.toJavaType((int)type, null));
        }
    }

    private void testSqlTypes(Class<?> expected, Class<?> ... sqlTypes) {
        for (Class<?> type : sqlTypes) {
            Assert.assertEquals(expected, (Object)JdbcTypeHelper.toJavaType((int)-99999, type));
        }
    }
}

