/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.simpleflatmapper.jdbc.Crud;
import org.simpleflatmapper.jdbc.impl.BatchQueryExecutor;
import org.simpleflatmapper.jdbc.impl.DefaultCrud;
import org.simpleflatmapper.util.CheckedConsumer;

public final class MultiRowsBatchInsertCrud<T, K>
implements Crud<T, K> {
    private final BatchQueryExecutor<T> batchInsertQueryExecutor;
    private final BatchQueryExecutor<T> batchUpsertQueryExecutor;
    private final DefaultCrud<T, K> delegate;

    public MultiRowsBatchInsertCrud(DefaultCrud<T, K> delegate, BatchQueryExecutor<T> batchInsertQueryPreparer, BatchQueryExecutor<T> batchUpsertQueryExecutor) {
        this.delegate = delegate;
        this.batchInsertQueryExecutor = batchInsertQueryPreparer;
        this.batchUpsertQueryExecutor = batchUpsertQueryExecutor;
    }

    @Override
    public void create(Connection connection, T value) throws SQLException {
        this.delegate.create(connection, value);
    }

    @Override
    public void create(Connection connection, Collection<T> values) throws SQLException {
        this.create(connection, values, (CheckedConsumer)null);
    }

    @Override
    public <RH extends CheckedConsumer<? super K>> RH create(Connection connection, T value, RH keyConsumer) throws SQLException {
        return this.delegate.create(connection, value, keyConsumer);
    }

    @Override
    public <RH extends CheckedConsumer<? super K>> RH create(Connection connection, Collection<T> values, final RH keyConsumer) throws SQLException {
        this.batchInsertQueryExecutor.insert(connection, values, new CheckedConsumer<PreparedStatement>(){

            public void accept(PreparedStatement preparedStatement) throws Exception {
                if (((MultiRowsBatchInsertCrud)MultiRowsBatchInsertCrud.this).delegate.hasGeneratedKeys && keyConsumer != null) {
                    MultiRowsBatchInsertCrud.this.delegate.handleGeneratedKeys(keyConsumer, preparedStatement);
                }
            }
        });
        return keyConsumer;
    }

    @Override
    public T read(Connection connection, K key) throws SQLException {
        return this.delegate.read(connection, key);
    }

    @Override
    public <RH extends CheckedConsumer<? super T>> RH read(Connection connection, Collection<K> keys, RH consumer) throws SQLException {
        return this.delegate.read(connection, keys, consumer);
    }

    @Override
    public void update(Connection connection, T value) throws SQLException {
        this.delegate.update(connection, value);
    }

    @Override
    public void update(Connection connection, Collection<T> values) throws SQLException {
        this.delegate.update(connection, values);
    }

    @Override
    public void delete(Connection connection, K key) throws SQLException {
        this.delegate.delete(connection, key);
    }

    @Override
    public void delete(Connection connection, List<K> keys) throws SQLException {
        this.delegate.delete(connection, keys);
    }

    @Override
    public void createOrUpdate(Connection connection, T value) throws SQLException {
        this.delegate.createOrUpdate(connection, value);
    }

    @Override
    public void createOrUpdate(Connection connection, Collection<T> values) throws SQLException {
        this.createOrUpdate(connection, values, (CheckedConsumer)null);
    }

    @Override
    public <RH extends CheckedConsumer<? super K>> RH createOrUpdate(Connection connection, T value, RH keyConsumer) throws SQLException {
        return this.delegate.createOrUpdate(connection, value, keyConsumer);
    }

    @Override
    public <RH extends CheckedConsumer<? super K>> RH createOrUpdate(Connection connection, Collection<T> values, final RH keyConsumer) throws SQLException {
        this.batchUpsertQueryExecutor.insert(connection, values, new CheckedConsumer<PreparedStatement>(){

            public void accept(PreparedStatement preparedStatement) throws Exception {
                if (((MultiRowsBatchInsertCrud)MultiRowsBatchInsertCrud.this).delegate.hasGeneratedKeys && keyConsumer != null) {
                    MultiRowsBatchInsertCrud.this.delegate.handleGeneratedKeys(keyConsumer, preparedStatement);
                }
            }
        });
        return keyConsumer;
    }
}

