/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.impl;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.simpleflatmapper.converter.Converter;
import org.simpleflatmapper.converter.ConverterService;
import org.simpleflatmapper.jdbc.JdbcColumnKey;
import org.simpleflatmapper.jdbc.impl.JDBCTypeHelper;
import org.simpleflatmapper.jdbc.impl.setter.ArrayPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.BigDecimalPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.BlobPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.BooleanPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.BytePreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.BytesPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.CharacterPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.ClobPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.ConvertDelegateIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.DatePreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.DoublePreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.FloatPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.InputStreamPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.IntegerPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.LongPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.NClobPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.ObjectPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.OrdinalEnumPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.PreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.ReaderPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.RefPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.RowIdPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.SQLXMLPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.ShortPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.StringEnumPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.StringPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.TimePreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.TimestampPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.URLPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.UUIDBinaryPreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.UUIDStringPreparedStatementIndexSetter;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.reflect.IndexedSetter;
import org.simpleflatmapper.reflect.IndexedSetterFactory;
import org.simpleflatmapper.util.TypeHelper;

public class PreparedStatementIndexedSetterFactory
implements IndexedSetterFactory<PreparedStatement, PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>>> {
    public static final PreparedStatementIndexedSetterFactory INSTANCE = new PreparedStatementIndexedSetterFactory();
    private final Map<Class<?>, Factory> factoryPerClass = new HashMap();

    private PreparedStatementIndexedSetterFactory() {
        this.factoryPerClass.put(Boolean.TYPE, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key) {
                return new BooleanPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Boolean.class, this.factoryPerClass.get(Boolean.TYPE));
        this.factoryPerClass.put(Byte.TYPE, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key) {
                return new BytePreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Byte.class, this.factoryPerClass.get(Byte.TYPE));
        this.factoryPerClass.put(Character.TYPE, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key) {
                return new CharacterPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Character.class, this.factoryPerClass.get(Character.TYPE));
        this.factoryPerClass.put(Short.TYPE, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key) {
                return new ShortPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Short.class, this.factoryPerClass.get(Short.TYPE));
        this.factoryPerClass.put(Integer.TYPE, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key) {
                return new IntegerPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Integer.class, this.factoryPerClass.get(Integer.TYPE));
        this.factoryPerClass.put(Long.TYPE, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key) {
                return new LongPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Long.class, this.factoryPerClass.get(Long.TYPE));
        this.factoryPerClass.put(Float.TYPE, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key) {
                return new FloatPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Float.class, this.factoryPerClass.get(Float.TYPE));
        this.factoryPerClass.put(Double.TYPE, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key) {
                return new DoublePreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Double.class, this.factoryPerClass.get(Double.TYPE));
        this.factoryPerClass.put(String.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key) {
                return new StringPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Timestamp.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key) {
                return new TimestampPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Date.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key) {
                return new DatePreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Time.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key) {
                return new TimePreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(URL.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key) {
                return new URLPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Ref.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key) {
                return new RefPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(BigDecimal.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key) {
                return new BigDecimalPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Array.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key) {
                return new ArrayPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(byte[].class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key) {
                return new BytesPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(NClob.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key) {
                return new NClobPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(RowId.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key) {
                return new RowIdPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Blob.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key) {
                return new BlobPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Clob.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key) {
                return new ClobPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(InputStream.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key) {
                return new InputStreamPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(Reader.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key) {
                return new ReaderPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(SQLXML.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key) {
                return new SQLXMLPreparedStatementIndexSetter();
            }
        });
        this.factoryPerClass.put(UUID.class, new Factory(){

            public <P> PreparedStatementIndexSetter<P> getIndexedSetter(JdbcColumnKey key) {
                switch (key.getSqlType()) {
                    case -4: 
                    case -3: 
                    case -2: {
                        return new UUIDBinaryPreparedStatementIndexSetter();
                    }
                    case 1111: {
                        return new ObjectPreparedStatementIndexSetter();
                    }
                }
                return new UUIDStringPreparedStatementIndexSetter();
            }
        });
    }

    public <T> IndexedSetter<PreparedStatement, T> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> arg) {
        Type propertyType = arg.getPropertyMeta().getPropertyType();
        Object setter = this.getIndexedSetter(propertyType, arg);
        if (setter == null) {
            Class<?> iclass = JDBCTypeHelper.toJavaType(((JdbcColumnKey)arg.getColumnKey()).getSqlType(), propertyType);
            setter = this.getSetterWithConvertion(TypeHelper.toClass((Type)propertyType), iclass, arg);
        }
        return setter;
    }

    private <P, I> IndexedSetter<PreparedStatement, P> getSetterWithConvertion(Class<P> pclazz, Class<I> iclass, PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
        IndexedSetter indexedSetter;
        Converter converter = ConverterService.getInstance().findConverter(pclazz, iclass, pm.getColumnDefinition().properties());
        if (converter != null && (indexedSetter = this.getIndexedSetter(iclass, pm)) != null) {
            return new ConvertDelegateIndexSetter(indexedSetter, converter);
        }
        return null;
    }

    protected <T> IndexedSetter<PreparedStatement, T> getIndexedSetter(Type propertyType, PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> arg) {
        Factory setterFactory;
        PreparedStatementIndexSetter<Enum<?>> setter = null;
        if (TypeHelper.isEnum((Type)propertyType)) {
            switch (((JdbcColumnKey)arg.getColumnKey()).getSqlType()) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    setter = new OrdinalEnumPreparedStatementIndexSetter();
                    break;
                }
                default: {
                    setter = new StringEnumPreparedStatementIndexSetter();
                }
            }
        }
        if (setter == null && (setterFactory = this.factoryPerClass.get(TypeHelper.toClass((Type)propertyType))) != null) {
            setter = setterFactory.getIndexedSetter(arg.getColumnKey());
        }
        if (setter == null && TypeHelper.isAssignable(SQLData.class, (Type)propertyType)) {
            setter = new ObjectPreparedStatementIndexSetter();
        }
        return setter;
    }

    public static interface Factory
    extends IndexedSetterFactory<PreparedStatement, JdbcColumnKey> {
    }
}

