/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.persistence.Column;
import org.junit.Assert;
import org.junit.Test;
import org.simpleflatmapper.jdbc.impl.JpaAliasProvider;
import org.simpleflatmapper.jdbc.impl.JpaAliasProviderFactory;
import org.simpleflatmapper.reflect.meta.AliasProviderService;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.ListCollector;

public class AliasProviderTest {
    @Test
    public void testJPAAliasProvider() throws NoSuchFieldException, NoSuchMethodException {
        JpaAliasProvider p = new JpaAliasProvider();
        Assert.assertEquals((Object)"bar1", (Object)p.getAliasForField(TestClass.class.getField("foo")));
        Assert.assertEquals((Object)"bar2", (Object)p.getAliasForMethod(TestClass.class.getMethod("getFoo", new Class[0])));
    }

    @Test
    public void testFactoryJPAPresent() {
        Assert.assertEquals(JpaAliasProvider.class, AliasProviderService.getAliasProvider().getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFactoryJPANotPresent() throws Exception {
        final ClassLoader original = Thread.currentThread().getContextClassLoader();
        ClassLoader cl = new ClassLoader(ClassLoader.getSystemClassLoader().getParent()){

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                if (!name.startsWith("javax.persistence")) {
                    InputStream resourceAsStream = original.getResourceAsStream(name.replace(".", "/") + ".class");
                    if (resourceAsStream == null) {
                        throw new ClassNotFoundException(name);
                    }
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    try {
                        int i;
                        while ((i = resourceAsStream.read()) != -1) {
                            bos.write(i);
                        }
                        byte[] bytes = bos.toByteArray();
                        Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
                        return clazz;
                    }
                    catch (IOException e) {
                        throw new ClassNotFoundException(e.getMessage(), e);
                    }
                    finally {
                        try {
                            resourceAsStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                throw new ClassNotFoundException(name);
            }
        };
        Thread.currentThread().setContextClassLoader(cl);
        try {
            Class<?> jpa = cl.loadClass(JpaAliasProviderFactory.class.getName());
            Class<?> consumerClass = cl.loadClass(Consumer.class.getName());
            Object consumer = cl.loadClass(ListCollector.class.getName()).newInstance();
            jpa.getMethod("produce", consumerClass).invoke(jpa.getConstructor(new Class[0]).newInstance(new Object[0]), consumer);
            List list = (List)consumer.getClass().getMethod("getList", new Class[0]).invoke(consumer, new Object[0]);
            Assert.assertTrue((boolean)list.isEmpty());
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public class TestClass {
        @Column(name="bar1")
        public String foo;

        @Column(name="bar2")
        public String getFoo() {
            return null;
        }
    }
}

