/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.simpleflatmapper.jdbc.Crud;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.test.jdbc.DbHelper;

public class CrudNoPrimaryKeyTest {
    Connection connection;

    @Before
    public void setUp() throws SQLException {
        this.connection = DbHelper.objectDb();
        try (Statement statement = this.connection.createStatement();){
            statement.execute("DROP TABLE IF EXISTS CRUDNOKEY");
            statement.execute("CREATE TABLE CRUDNOKEY ( id bigint, name varchar(255) )");
            statement.execute("INSERT INTO CRUDNOKEY VALUES ( 1, 'name' )");
        }
    }

    @After
    public void tearDown() throws SQLException {
        this.connection.close();
        this.connection = null;
    }

    @Test
    public void testFailOnNoPrimaryKey() throws SQLException {
        try {
            JdbcMapperFactory.newInstance().crud(MyObject.class, Long.TYPE).table(this.connection, "CRUDNOKEY");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            System.out.println("e = " + e);
        }
    }

    @Test
    public void testWithManualKey() throws SQLException {
        Crud table = ((JdbcMapperFactory)JdbcMapperFactory.newInstance().addKeys(new String[]{"id"})).crud(MyObject.class, Long.class).table(this.connection, "CRUDNOKEY");
        Assert.assertEquals((Object)new MyObject(1L, "name"), (Object)table.read(this.connection, (Object)1L));
    }

    public static class MyObject {
        public long id;
        public String name;

        public MyObject(long id, String name) {
            this.id = id;
            this.name = name;
        }

        public MyObject() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyObject myObject = (MyObject)o;
            if (this.id != myObject.id) {
                return false;
            }
            return this.name != null ? this.name.equals(myObject.name) : myObject.name == null;
        }

        public int hashCode() {
            int result = (int)(this.id ^ this.id >>> 32);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}

