/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.persistence.Table;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.simpleflatmapper.jdbc.Crud;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.SelectQuery;
import org.simpleflatmapper.jdbc.property.IndexedSetterProperty;
import org.simpleflatmapper.map.property.GetterProperty;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.IndexedSetter;
import org.simpleflatmapper.test.beans.DbObject;
import org.simpleflatmapper.test.jdbc.DbHelper;
import org.simpleflatmapper.test.jdbc.MysqlDbHelper;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.ListCollector;

@RunWith(value=Parameterized.class)
public class CrudTest {
    @Parameterized.Parameter
    public DbHelper.TargetDB targetDB;

    @Parameterized.Parameters(name="db:{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({DbHelper.TargetDB.HSQLDB}, {DbHelper.TargetDB.MYSQL}, {DbHelper.TargetDB.POSTGRESQL});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDbObjectCrudAutoInc() throws SQLException {
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)this.targetDB);
        if (connection == null) {
            System.err.println("Db " + this.targetDB + " not available");
            return;
        }
        try {
            Crud objectCrud = JdbcMapperFactory.newInstance().crud(DbObject.class, Long.class).table(connection, "TEST_DB_OBJECT_AUTOINC");
            DbObject object = DbObject.newInstance();
            object.setId(-22225L);
            Long key = (objectCrud.create((Connection)connection, (Object)object, (CheckedConsumer)new CheckedConsumer<Long>(){
                Long key;

                public void accept(Long aLong) throws Exception {
                    this.key = aLong;
                }
            })).key;
            Assert.assertFalse((boolean)key.equals(object.getId()));
            object.setId(key.longValue());
            Assert.assertEquals((Object)object, (Object)objectCrud.read(connection, (Object)key));
            object.setName("Udpdated");
            objectCrud.update(connection, (Object)object);
            Assert.assertEquals((Object)object, (Object)objectCrud.read(connection, (Object)key));
            objectCrud.delete(connection, (Object)key);
            Assert.assertNull((Object)objectCrud.read(connection, (Object)key));
            objectCrud.create(connection, (Object)DbObject.newInstance());
            final ArrayList keys = new ArrayList();
            final List<DbObject> values = Arrays.asList(DbObject.newInstance(), DbObject.newInstance());
            objectCrud.create(connection, values, (CheckedConsumer)new CheckedConsumer<Long>(){

                public void accept(Long aLong) throws Exception {
                    ((DbObject)values.get(keys.size())).setId(aLong.longValue());
                    keys.add(aLong);
                }
            });
            this.assertCollectionEquals(values, ((ListCollector)objectCrud.read(connection, keys, (CheckedConsumer)new ListCollector())).getList());
            int i = 333;
            for (DbObject value : values) {
                value.setEmail(Integer.toHexString(i));
                ++i;
            }
            objectCrud.update(connection, values);
            this.assertCollectionEquals(values, ((ListCollector)objectCrud.read(connection, keys, (CheckedConsumer)new ListCollector())).getList());
            objectCrud.delete(connection, keys);
            this.assertCollectionEquals(Collections.emptyList(), ((ListCollector)objectCrud.read(connection, keys, (CheckedConsumer)new ListCollector())).getList());
        }
        finally {
            connection.close();
        }
    }

    @Test
    public void testDbObjectCrud() throws SQLException {
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)this.targetDB);
        if (connection == null) {
            System.err.println("Db " + this.targetDB + " not available");
            return;
        }
        try {
            Crud objectCrud = JdbcMapperFactory.newInstance().crud(DbObject.class, Long.class).table(connection, "TEST_DB_OBJECT");
            CrudTest.checkCrudDbObject(connection, objectCrud, DbObject.newInstance());
        }
        finally {
            connection.close();
        }
    }

    @Test
    public void testDbObjectCrudTable() throws SQLException {
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)this.targetDB);
        if (connection == null) {
            System.err.println("Db " + this.targetDB + " not available");
            return;
        }
        try {
            Crud objectCrud = JdbcMapperFactory.newInstance().crud(DbObjectTable.class, Long.class).to(connection);
            CrudTest.checkCrudDbObject(connection, objectCrud, DbObject.newInstance((DbObject)new DbObjectTable()));
        }
        finally {
            connection.close();
        }
    }

    @Test
    public void testDbObjectLazyCrud() throws SQLException {
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)this.targetDB);
        if (connection == null) {
            System.err.println("Db " + this.targetDB + " not available");
            return;
        }
        try {
            Crud objectCrud = JdbcMapperFactory.newInstance().crud(DbObject.class, Long.class).table("TEST_DB_OBJECT");
            CrudTest.checkCrudDbObject(connection, objectCrud, DbObject.newInstance());
        }
        finally {
            connection.close();
        }
    }

    @Test
    public void testDbObjectLazyCrudTable() throws SQLException {
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)this.targetDB);
        if (connection == null) {
            System.err.println("Db " + this.targetDB + " not available");
            return;
        }
        try {
            Crud objectCrud = JdbcMapperFactory.newInstance().crud(DbObjectTable.class, Long.class).crud();
            CrudTest.checkCrudDbObject(connection, objectCrud, DbObject.newInstance((DbObject)new DbObjectTable()));
        }
        finally {
            connection.close();
        }
    }

    @Test
    public void testDbObjectCrudTestDbObject() throws SQLException {
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)this.targetDB);
        if (connection == null) {
            System.err.println("Db " + this.targetDB + " not available");
            return;
        }
        try {
            Crud objectCrud = JdbcMapperFactory.newInstance().crud(TestDbObject.class, Long.class).to(connection);
            CrudTest.checkCrudDbObject(connection, objectCrud, DbObject.newInstance((DbObject)new TestDbObject()));
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDbObjectCrudWithCustomGetter() throws Exception {
        JdbcMapperFactory mapperFactory = (JdbcMapperFactory)JdbcMapperFactory.newInstance().addColumnProperty("name", new Object[]{new GetterProperty((Getter)new Getter<ResultSet, String>(){

            public String get(ResultSet target) throws Exception {
                return "customname";
            }
        })});
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)this.targetDB);
        if (connection == null) {
            System.err.println("Db " + this.targetDB + " not available");
            return;
        }
        try {
            Crud objectCrud = mapperFactory.crud(TestDbObject.class, Long.class).to(connection);
            TestDbObject testDbObject = (TestDbObject)DbObject.newInstance((DbObject)new TestDbObject());
            objectCrud.create(connection, (Object)testDbObject);
            TestDbObject read = (TestDbObject)((Object)objectCrud.read(connection, (Object)testDbObject.getId()));
            Assert.assertEquals((Object)"customname", (Object)read.getName());
            Assert.assertEquals((Object)testDbObject.getEmail(), (Object)read.getEmail());
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDbObjectCrudWithCustomSetter() throws Exception {
        JdbcMapperFactory mapperFactory = (JdbcMapperFactory)JdbcMapperFactory.newInstance().addColumnProperty("name", new Object[]{new IndexedSetterProperty((IndexedSetter)new IndexedSetter<PreparedStatement, Object>(){

            public void set(PreparedStatement target, Object value, int index) throws Exception {
                target.setString(index, "customname");
            }
        })});
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)this.targetDB);
        if (connection == null) {
            System.err.println("Db " + this.targetDB + " not available");
            return;
        }
        try {
            Crud objectCrud = mapperFactory.crud(TestDbObject.class, Long.class).to(connection);
            TestDbObject testDbObject = (TestDbObject)DbObject.newInstance((DbObject)new TestDbObject());
            Assert.assertNotEquals((Object)"customname", (Object)((Object)testDbObject));
            objectCrud.create(connection, (Object)testDbObject);
            TestDbObject read = (TestDbObject)((Object)objectCrud.read(connection, (Object)testDbObject.getId()));
            Assert.assertEquals((Object)"customname", (Object)read.getName());
            Assert.assertEquals((Object)testDbObject.getEmail(), (Object)read.getEmail());
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProtectedKeyWord() throws SQLException {
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)this.targetDB);
        if (connection == null) {
            System.err.println("Db " + this.targetDB + " not available");
            return;
        }
        try {
            if (this.targetDB == DbHelper.TargetDB.MYSQL) {
                try {
                    connection.createStatement().execute("DROP TABLE  `select`;");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                connection.createStatement().execute("CREATE TABLE  `select` ( v integer PRIMARY KEY);");
            } else {
                try {
                    connection.createStatement().execute("DROP TABLE  \"select\";");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                connection.createStatement().execute("CREATE TABLE  \"select\" ( v integer PRIMARY KEY);");
            }
            Crud select = JdbcMapperFactory.newInstance().crud(Select.class, Integer.class).table("select");
            Select s = new Select();
            s.v = 3;
            select.create(connection, (Object)s);
            Assert.assertEquals((long)3L, (long)((Select)select.read((Connection)connection, (Object)Integer.valueOf((int)3))).v);
            select.delete(connection, (Object)3);
            select = JdbcMapperFactory.newInstance().crud(Select.class, Integer.class).table(this.targetDB == DbHelper.TargetDB.MYSQL ? "`select`" : "\"select\"");
            select.create(connection, (Object)s);
            Assert.assertEquals((long)3L, (long)((Select)select.read((Connection)connection, (Object)Integer.valueOf((int)3))).v);
            select.delete(connection, (Object)3);
        }
        finally {
            connection.close();
        }
    }

    public static <T extends DbObject> void checkCrudDbObject(Connection connection, Crud<T, Long> objectCrud, T object) throws SQLException {
        Assert.assertNull((Object)objectCrud.where(" 1 = 2 ", Void.class).readFirst(connection, null));
        Assert.assertNull((Object)objectCrud.read(connection, (Object)object.getId()));
        Long key = (objectCrud.create((Connection)connection, object, (CheckedConsumer)new CheckedConsumer<Long>(){
            Long key;

            public void accept(Long aLong) throws Exception {
                this.key = aLong;
            }
        })).key;
        Assert.assertNull((Object)key);
        key = object.getId();
        Assert.assertEquals(object, (Object)objectCrud.read(connection, (Object)key));
        Assert.assertEquals(Arrays.asList(object), (Object)((ListCollector)objectCrud.read(connection, Arrays.asList(key), (CheckedConsumer)new ListCollector())).getList());
        object.setName("Udpdated");
        objectCrud.update(connection, object);
        Assert.assertEquals(object, (Object)objectCrud.read(connection, (Object)key));
        objectCrud.delete(connection, (Object)key);
        Assert.assertNull((Object)objectCrud.read(connection, (Object)key));
        objectCrud.create(connection, Arrays.asList(object));
        SelectQuery selectQuery = objectCrud.where(" id = :id ", Long.class);
        Assert.assertSame((Object)selectQuery, (Object)objectCrud.where(" id = :id ", Long.class));
        Assert.assertEquals(object, (Object)selectQuery.readFirst(connection, (Object)object.getId()));
        Assert.assertEquals(Arrays.asList(object), (Object)((ListCollector)objectCrud.where(" email =:email and name = :name", object.getClass()).read(connection, object, (CheckedConsumer)new ListCollector())).getList());
        Assert.assertEquals(Arrays.asList(object), (Object)((ListCollector)objectCrud.where(" email =:email and name = :name", Object[].class).read(connection, (Object)new Object[]{object.getEmail(), object.getName()}, (CheckedConsumer)new ListCollector())).getList());
        objectCrud.delete(connection, Arrays.asList(object.getId()));
        Assert.assertNull((Object)selectQuery.readFirst(connection, (Object)object.getId()));
        Assert.assertNull((Object)(objectCrud.create((Connection)connection, Arrays.asList(new DbObject[]{object}), (CheckedConsumer)new CheckedConsumer<Long>(){
            Long key;

            public void accept(Long aLong) throws Exception {
                this.key = aLong;
            }
        })).key);
        Assert.assertEquals(object, (Object)selectQuery.readFirst(connection, (Object)object.getId()));
        object.setName("Udpdated 2");
        objectCrud.update(connection, Arrays.asList(object));
        Assert.assertEquals(object, (Object)selectQuery.readFirst(connection, (Object)object.getId()));
        objectCrud.delete(connection, (Object)object.getId());
        Assert.assertNull((Object)selectQuery.readFirst(connection, (Object)object.getId()));
        objectCrud.create(connection, object);
        Assert.assertEquals(object, (Object)selectQuery.readFirst(connection, (Object)object.getId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompositeKey() throws SQLException {
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)this.targetDB);
        if (connection == null) {
            System.err.println("Db " + this.targetDB + " not available");
            return;
        }
        try {
            Crud objectCrud = JdbcMapperFactory.newInstance().crud(DbObject.class, CKEY.class).table(connection, "TEST_DB_OBJECT_CKEY");
            DbObject object = DbObject.newInstance();
            CKEY ckey = new CKEY();
            ckey.id = object.getId();
            ckey.name = object.getName();
            Assert.assertNull((Object)objectCrud.read(connection, (Object)ckey));
            CKEY key = (objectCrud.create((Connection)connection, (Object)object, (CheckedConsumer)new CheckedConsumer<CKEY>(){
                CKEY key;

                public void accept(CKEY aLong) throws Exception {
                    this.key = aLong;
                }
            })).key;
            Assert.assertNull((Object)key);
            key = ckey;
            Assert.assertEquals((Object)object, (Object)objectCrud.read(connection, (Object)key));
            object.setEmail("Udpdated");
            objectCrud.update(connection, (Object)object);
            Assert.assertEquals((Object)object, (Object)objectCrud.read(connection, (Object)key));
            objectCrud.delete(connection, (Object)key);
            Assert.assertNull((Object)objectCrud.read(connection, (Object)key));
            List<DbObject> values = Arrays.asList(DbObject.newInstance(), DbObject.newInstance());
            ArrayList<CKEY> keys = new ArrayList<CKEY>();
            for (DbObject value : values) {
                CKEY k = new CKEY();
                k.id = value.getId();
                k.name = value.getName();
                keys.add(k);
            }
            objectCrud.create(connection, values);
            this.assertCollectionEquals(values, ((ListCollector)objectCrud.read(connection, keys, (CheckedConsumer)new ListCollector())).getList());
            int i = 333;
            for (DbObject value : values) {
                value.setEmail(Integer.toHexString(i));
                ++i;
            }
            objectCrud.update(connection, values);
            this.assertCollectionEquals(values, ((ListCollector)objectCrud.read(connection, keys, (CheckedConsumer)new ListCollector())).getList());
            objectCrud.delete(connection, keys);
            this.assertCollectionEquals(Collections.emptyList(), ((ListCollector)objectCrud.read(connection, keys, (CheckedConsumer)new ListCollector())).getList());
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOnlyKey497() throws SQLException {
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)this.targetDB);
        if (connection == null) {
            System.err.println("Db " + this.targetDB + " not available");
            return;
        }
        try {
            Crud objectCrud = JdbcMapperFactory.newInstance().crud(OnlyKey.class, Long.class).table(connection, "TEST_ONLY_KEY");
            OnlyKey object = new OnlyKey(1L);
            objectCrud.delete(connection, Arrays.asList(1L, 2L));
            Assert.assertNull((Object)objectCrud.read(connection, (Object)1L));
            objectCrud.create(connection, (Object)object);
            Assert.assertEquals((Object)object, (Object)objectCrud.read(connection, (Object)1L));
            objectCrud.update(connection, (Object)object);
            objectCrud.delete(connection, (Object)1L);
            Assert.assertNull((Object)objectCrud.read(connection, (Object)1L));
            objectCrud.create(connection, Arrays.asList(new OnlyKey(1L), new OnlyKey(2L)));
            try {
                objectCrud.createOrUpdate(connection, (Object)object);
                objectCrud.createOrUpdate(connection, Arrays.asList(new OnlyKey(1L), new OnlyKey(2L)));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        finally {
            connection.close();
        }
    }

    private void assertCollectionEquals(List<DbObject> objects, List<DbObject> list) {
        Assert.assertEquals((long)objects.size(), (long)list.size());
        for (DbObject v : objects) {
            Assert.assertTrue((boolean)list.contains(v));
        }
    }

    public static void main(String[] args) throws SQLException {
        Connection connection = MysqlDbHelper.objectDb();
        Crud crud = JdbcMapperFactory.newInstance().crud(DbObject.class, Long.class).table(connection, "TEST_DB_OBJECT");
        connection.createStatement().execute("TRUNCATE TABLE TEST_DB_OBJECT");
        ArrayList<DbObject> objects = new ArrayList<DbObject>(10000);
        for (int i = 0; i < 65001; ++i) {
            DbObject e = DbObject.newInstance();
            e.setId((long)(i + 1));
            objects.add(e);
        }
        crud.create(connection, objects);
    }

    public static class OnlyKey {
        public final long id;

        public OnlyKey(long id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OnlyKey onlyKey = (OnlyKey)o;
            return this.id == onlyKey.id;
        }

        public int hashCode() {
            return (int)(this.id ^ this.id >>> 32);
        }
    }

    public static class CKEY {
        public long id;
        public String name;
    }

    public static class TestDbObject
    extends DbObject {
    }

    @Table(name="TEST_DB_OBJECT")
    public static class DbObjectTable
    extends DbObject {
    }

    public static class Select {
        public int v;
    }
}

