/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.simpleflatmapper.jdbc.ConnectedCrud;
import org.simpleflatmapper.jdbc.Crud;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.impl.ColumnMeta;
import org.simpleflatmapper.jdbc.impl.CrudFactory;
import org.simpleflatmapper.jdbc.impl.CrudMeta;
import org.simpleflatmapper.jdbc.impl.DatabaseMeta;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.test.beans.DbObject;
import org.simpleflatmapper.test.jdbc.DbHelper;
import org.simpleflatmapper.util.CheckedConsumer;

public class CrudUpsertTest {
    Crud<DbObject, Long> postGresqlCrud;

    public CrudUpsertTest() {
        try {
            this.postGresqlCrud = CrudFactory.newInstance((ClassMeta)ReflectionService.newInstance().getClassMeta(DbObject.class), (ClassMeta)ReflectionService.newInstance().getClassMeta(Long.class), (CrudMeta)new CrudMeta(new DatabaseMeta("PostgreSQL", 9, 5), "public", "TEST", new ColumnMeta[]{new ColumnMeta("id", 4, true, null), new ColumnMeta("name", 12, false, null)}), (JdbcMapperFactory)JdbcMapperFactory.newInstance());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testUpsertDefaultCrud() throws SQLException {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        PreparedStatement ps = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)connection.prepareStatement("INSERT INTO \"public\".\"TEST\"(\"id\", \"name\") VALUES(?, ?) ON CONFLICT (\"id\") DO UPDATE SET \"name\" = EXCLUDED.\"name\"", new String[0])).thenReturn((Object)ps);
        DbObject o = DbObject.newInstance();
        this.postGresqlCrud.createOrUpdate(connection, (Object)o);
        ((PreparedStatement)Mockito.verify((Object)ps)).setLong(1, o.getId());
        ((PreparedStatement)Mockito.verify((Object)ps)).setString(2, o.getName());
        ((PreparedStatement)Mockito.verify((Object)ps)).executeUpdate();
    }

    @Test
    public void testUpsertDefaultCrudBatch() throws SQLException {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        PreparedStatement ps = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)connection.prepareStatement("INSERT INTO \"public\".\"TEST\"(id, name) VALUES(?, ?), (?, ?) ON CONFLICT (id) DO UPDATE SET name = EXCLUDED.name")).thenReturn((Object)ps);
        List<DbObject> objects = Arrays.asList(DbObject.newInstance(), DbObject.newInstance());
        this.postGresqlCrud.createOrUpdate(connection, objects);
        ((PreparedStatement)Mockito.verify((Object)ps)).setLong(1, objects.get(0).getId());
        ((PreparedStatement)Mockito.verify((Object)ps)).setString(2, objects.get(0).getName());
        ((PreparedStatement)Mockito.verify((Object)ps)).setLong(3, objects.get(1).getId());
        ((PreparedStatement)Mockito.verify((Object)ps)).setString(4, objects.get(1).getName());
        ((PreparedStatement)Mockito.verify((Object)ps)).executeUpdate();
    }

    @Test
    public void testUpsertHsqlBatch() throws Exception {
        this.testDefaultCrudCreateOrUpdate(DbHelper.getDbConnection((DbHelper.TargetDB)DbHelper.TargetDB.HSQLDB), (Crud<DbObject, Long>)JdbcMapperFactory.newInstance().crud(DbObject.class, Long.class).table(DbHelper.getDbConnection((DbHelper.TargetDB)DbHelper.TargetDB.HSQLDB), "TEST_DB_OBJECT"));
        this.testDefaultCrudCreateOrUpdate(DbHelper.getDbConnection((DbHelper.TargetDB)DbHelper.TargetDB.HSQLDB), (Crud<DbObject, Long>)JdbcMapperFactory.newInstance().crud(DbObject.class, Long.class).table("TEST_DB_OBJECT"));
        this.testConnectedCrudCreateOrUpdate((ConnectedCrud<DbObject, Long>)JdbcMapperFactory.newInstance().crud(DbObject.class, Long.class).table(DbHelper.getHsqlDataSource(), "TEST_DB_OBJECT"));
    }

    private void testDefaultCrudCreateOrUpdate(Connection connection, Crud<DbObject, Long> crud) throws SQLException {
        List<DbObject> objects = Arrays.asList(DbObject.newInstance(), DbObject.newInstance());
        try {
            crud.createOrUpdate(connection, objects);
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            crud.createOrUpdate(connection, (Object)DbObject.newInstance());
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            crud.createOrUpdate(connection, objects, (CheckedConsumer)new CheckedConsumer<Long>(){

                public void accept(Long aLong) throws Exception {
                }
            });
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            crud.createOrUpdate(connection, (Object)DbObject.newInstance(), (CheckedConsumer)new CheckedConsumer<Long>(){

                public void accept(Long aLong) throws Exception {
                }
            });
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private void testConnectedCrudCreateOrUpdate(ConnectedCrud<DbObject, Long> crud) throws SQLException {
        List<DbObject> objects = Arrays.asList(DbObject.newInstance(), DbObject.newInstance());
        try {
            crud.createOrUpdate(objects);
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            crud.createOrUpdate((Object)DbObject.newInstance());
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            crud.createOrUpdate(objects, (CheckedConsumer)new CheckedConsumer<Long>(){

                public void accept(Long aLong) throws Exception {
                }
            });
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            crud.createOrUpdate((Object)DbObject.newInstance(), (CheckedConsumer)new CheckedConsumer<Long>(){

                public void accept(Long aLong) throws Exception {
                }
            });
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

