/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.test.JdbcMapperFactoryHelper;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.test.beans.Person;
import org.simpleflatmapper.test.beans.Professor;
import org.simpleflatmapper.test.beans.ProfessorGS;
import org.simpleflatmapper.test.beans.Student;
import org.simpleflatmapper.test.beans.StudentGS;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.ListCollector;
import org.simpleflatmapper.util.Predicate;

public class DiscriminatorJdbcMapperTest {
    @Test
    public void testDiscriminator() throws Exception {
        JdbcMapper mapper = ((JdbcMapperFactory)JdbcMapperFactoryHelper.asm().addKeys(new String[]{"id", "students_id"})).newDiscriminator("person_type").when("student", StudentGS.class).addMapping("person_type").addMapping("id").addMapping("name", 3, FieldMapperColumnDefinition.identity()).when((Predicate)new Predicate<String>(){

            public boolean test(String s) {
                return "professor".equals(s);
            }
        }, ProfessorGS.class).mapper();
        this.validateMapper(mapper);
    }

    @Test
    public void testDiscriminatorNoAsm() throws Exception {
        JdbcMapper mapper = ((JdbcMapperFactory)JdbcMapperFactoryHelper.noAsm().addKeys(new String[]{"id", "students_id"})).newDiscriminator("person_type").when("student", StudentGS.class).when("professor", ProfessorGS.class).mapper();
        this.validateMapper(mapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinTableCNoAsmMultiThread() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(4);
        try {
            final JdbcMapper mapper = ((JdbcMapperFactory)JdbcMapperFactoryHelper.noAsm().addKeys(new String[]{"id", "students_id"})).newDiscriminator("person_type").when("student", StudentGS.class).when("professor", ProfessorGS.class).mapper();
            ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(100);
            for (int i = 0; i < 300; ++i) {
                futures.add(executor.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        DiscriminatorJdbcMapperTest.this.validateMapper(mapper);
                        return null;
                    }
                }));
            }
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            executor.shutdown();
        }
    }

    private <T extends Person> void validateMapper(JdbcMapper<T> mapper) throws Exception {
        ArrayList persons = ((ListCollector)mapper.forEach(this.setUpResultSetMock(), (CheckedConsumer)new ListCollector())).getList();
        this.validatePersons(persons);
        this.validatePersons(mapper.stream(this.setUpResultSetMock()).collect(Collectors.toList()));
        Stream stream = mapper.stream(this.setUpResultSetMock());
        this.validatePersons(stream.limit(10L).collect(Collectors.toList()));
        Iterator iterator = mapper.iterator(this.setUpResultSetMock());
        persons = new ArrayList();
        while (iterator.hasNext()) {
            persons.add(iterator.next());
        }
        this.validatePersons(persons);
        ResultSet rs = this.setUpResultSetMock();
        rs.next();
        MappingContext mappingContext = mapper.newMappingContext((Object)rs);
        mappingContext.broke((Object)rs);
        Person professor = (Person)mapper.map((Object)rs, mappingContext);
        this.validateProfessorMap((Professor)professor);
        rs.next();
        mappingContext.broke((Object)rs);
        rs.next();
        mappingContext.broke((Object)rs);
    }

    private void validatePersons(List<? extends Person> persons) {
        Assert.assertEquals((String)"we get 4 persons from the resultset", (long)4L, (long)persons.size());
        Professor professor0 = (Professor)persons.get(0);
        this.assertPersonEquals(1, "professor1", (Person)professor0);
        Assert.assertEquals((String)"has 2 students", (long)2L, (long)professor0.getStudents().size());
        this.assertPersonEquals(3, "student3", (Person)professor0.getStudents().get(0));
        Assert.assertArrayEquals((Object[])new Object[]{"phone31", "phone32"}, (Object[])((Student)professor0.getStudents().get(0)).getPhones().toArray());
        this.assertPersonEquals(4, "student4", (Person)professor0.getStudents().get(1));
        Assert.assertArrayEquals((Object[])new Object[]{"phone41"}, (Object[])((Student)professor0.getStudents().get(1)).getPhones().toArray());
        Student student2 = (Student)persons.get(1);
        this.assertPersonEquals(2, "student2", (Person)student2);
        Student student3 = (Student)persons.get(2);
        this.assertPersonEquals(3, "student3", (Person)student3);
        Professor professor4 = (Professor)persons.get(3);
        this.assertPersonEquals(4, "professor4", (Person)professor4);
    }

    private <T extends Professor<?>> void validateProfessorMap(T professor0) {
        this.assertPersonEquals(1, "professor1", (Person)professor0);
        Assert.assertEquals((String)"has 2 students", (long)1L, (long)professor0.getStudents().size());
        this.assertPersonEquals(3, "student3", (Person)professor0.getStudents().get(0));
        Assert.assertArrayEquals((Object[])new Object[]{"phone31"}, (Object[])((Student)professor0.getStudents().get(0)).getPhones().toArray());
    }

    private <T extends Professor<?>> void validateProfessorMapTo(T professor0) {
        this.assertPersonEquals(1, "professor1", (Person)professor0);
        Assert.assertEquals((String)"has 2 students", (long)2L, (long)professor0.getStudents().size());
        this.assertPersonEquals(3, "student3", (Person)professor0.getStudents().get(0));
        Assert.assertArrayEquals((Object[])new Object[]{"phone31"}, (Object[])((Student)professor0.getStudents().get(0)).getPhones().toArray());
        this.assertPersonEquals(4, "student4", (Person)professor0.getStudents().get(1));
        Assert.assertArrayEquals((Object[])new Object[]{"phone41"}, (Object[])((Student)professor0.getStudents().get(1)).getPhones().toArray());
    }

    private void assertPersonEquals(int id, String name, Person person) {
        Assert.assertEquals((long)id, (long)person.getId());
        Assert.assertEquals((Object)name, (Object)person.getName());
    }

    private ResultSet setUpResultSetMock() throws SQLException {
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData metaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        final String[] columns = new String[]{"person_type", "id", "name", "students_id", "students_name", "students_phones_value"};
        Mockito.when((Object)metaData.getColumnCount()).thenReturn((Object)columns.length);
        Mockito.when((Object)metaData.getColumnLabel(Matchers.anyInt())).then((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocationOnMock) throws Throwable {
                return columns[-1 + (Integer)invocationOnMock.getArguments()[0]];
            }
        });
        Mockito.when((Object)rs.getMetaData()).thenReturn((Object)metaData);
        final AtomicInteger ai = new AtomicInteger();
        final Object[][] rows = new Object[][]{{"professor", 1, "professor1", 3, "student3", "phone31"}, {"professor", 1, "professor1", 3, "student3", "phone32"}, {"professor", 1, "professor1", 4, "student4", "phone41"}, {"student", 2, "student2", null, null, null}, {"student", 3, "student3", null, null, null}, {"professor", 4, "professor4", null, null, null}};
        Mockito.when((Object)rs.next()).then((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocationOnMock) throws Throwable {
                return ai.getAndIncrement() < rows.length;
            }
        });
        Answer<Object> getValue = new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                Object[] row = rows[ai.get() - 1];
                Integer col = -1 + (Integer)invocationOnMock.getArguments()[0];
                return row[col];
            }
        };
        Answer<Object> getColumnValue = new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                Object[] row = rows[ai.get() - 1];
                String col = (String)invocationOnMock.getArguments()[0];
                return row[Arrays.asList(columns).indexOf(col)];
            }
        };
        Mockito.when((Object)rs.getInt(Matchers.anyInt())).then((Answer)getValue);
        Mockito.when((Object)rs.getString(Matchers.anyInt())).then((Answer)getValue);
        Mockito.when((Object)rs.getString((String)Matchers.any(String.class))).then((Answer)getColumnValue);
        Mockito.when((Object)rs.getObject(Matchers.anyInt())).then((Answer)getValue);
        return rs;
    }
}

