/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;
import org.simpleflatmapper.jdbc.DynamicJdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.test.JdbcMapperFactoryHelper;
import org.simpleflatmapper.jdbc.test.MockDbObjectResultSet;
import org.simpleflatmapper.test.beans.DbObject;
import org.simpleflatmapper.test.jdbc.DbHelper;
import org.simpleflatmapper.test.jdbc.TestRowHandler;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.ListCollector;

public class DynamicJdbcMapperTest {
    final JdbcMapper<DbObject> mapper = JdbcMapperFactoryHelper.noAsm().newMapper(DbObject.class);
    private static final int NBROW = 2;
    private static final int NBFUTURE = 10000;

    @Test
    public void testResultSetMapperForEachRS() throws Exception {
        DbHelper.testDbObjectFromDb((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement ps) throws Exception {
                List objects = ((ListCollector)DynamicJdbcMapperTest.this.mapper.forEach(ps.executeQuery(), (CheckedConsumer)new ListCollector())).getList();
                Assert.assertEquals((long)1L, (long)objects.size());
                DbHelper.assertDbObjectMapping((DbObject)((DbObject)objects.get(0)));
            }
        });
    }

    @Test
    public void testResultSetMapperIterator() throws Exception {
        DbHelper.testDbObjectFromDb((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement ps) throws Exception {
                Iterator objectIterator = DynamicJdbcMapperTest.this.mapper.iterator(ps.executeQuery());
                Assert.assertTrue((boolean)objectIterator.hasNext());
                try {
                    objectIterator.remove();
                    Assert.fail((String)"Expect UnsupportedOperationException");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                DbHelper.assertDbObjectMapping((DbObject)((DbObject)objectIterator.next()));
                Assert.assertFalse((boolean)objectIterator.hasNext());
                try {
                    objectIterator.next();
                    Assert.fail((String)"Expect UnsupportedOperationException");
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
        });
    }

    @Test
    public void testResultSetMapperStream() throws SQLException, Exception, ParseException {
        DbHelper.testDbObjectFromDb((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement ps) throws Exception {
                Stream stream = DynamicJdbcMapperTest.this.mapper.stream(ps.executeQuery());
                stream.forEach(new Consumer<DbObject>(){
                    int i = 0;

                    @Override
                    public void accept(DbObject dbObject) {
                        Assert.assertTrue((this.i < 1 ? 1 : 0) != 0);
                        try {
                            DbHelper.assertDbObjectMapping((DbObject)dbObject);
                        }
                        catch (ParseException e) {
                            throw new RuntimeException(e);
                        }
                        ++this.i;
                    }
                });
            }
        });
    }

    @Test
    public void testResultSetMapperMap() throws SQLException, Exception, ParseException {
        DbHelper.testDbObjectFromDb((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement ps) throws Exception {
                ResultSet rs = ps.executeQuery();
                rs.next();
                DbObject object = (DbObject)DynamicJdbcMapperTest.this.mapper.map(rs);
                DbHelper.assertDbObjectMapping((DbObject)object);
            }
        });
    }

    @Test
    public void testMultipleThread() throws InterruptedException, ExecutionException {
        int i;
        DynamicJdbcMapper mapper = JdbcMapperFactoryHelper.asm().newMapper(DbObject.class);
        ExecutorService service = Executors.newFixedThreadPool(4);
        final AtomicLong sumOfAllIds = new AtomicLong();
        final AtomicLong nbRow = new AtomicLong();
        CheckedConsumer<DbObject> handler = new CheckedConsumer<DbObject>(){

            public void accept(DbObject t) throws Exception {
                long id = t.getId();
                Assert.assertEquals((Object)("name" + Long.toHexString(id)), (Object)t.getName());
                Assert.assertEquals((Object)("email" + Long.toHexString(id)), (Object)t.getEmail());
                Assert.assertEquals((Object)DbObject.Type.values()[(int)id % 4], (Object)t.getTypeName());
                Assert.assertEquals((Object)DbObject.Type.values()[(int)id % 4], (Object)t.getTypeOrdinal());
                Assert.assertEquals((long)id, (long)(t.getCreationTime().getTime() / 1000L));
                sumOfAllIds.addAndGet(id);
                nbRow.incrementAndGet();
            }
        };
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        for (i = 0; i < 10000; ++i) {
            futures.add(service.submit(new Callable<Object>((JdbcMapper)mapper, (CheckedConsumer)handler){
                final /* synthetic */ JdbcMapper val$mapper;
                final /* synthetic */ CheckedConsumer val$handler;
                {
                    this.val$mapper = jdbcMapper;
                    this.val$handler = checkedConsumer;
                }

                @Override
                public Object call() throws Exception {
                    this.val$mapper.forEach((ResultSet)new MockDbObjectResultSet(2), this.val$handler);
                    return null;
                }
            }));
        }
        i = 0;
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                System.out.println("Future " + i + " fail " + e);
            }
            ++i;
        }
        Assert.assertEquals((long)10000L, (long)i);
        Assert.assertEquals((long)20000L, (long)nbRow.get());
        int sum = 0;
        for (i = 1; i <= 2; ++i) {
            sum += i;
        }
        Assert.assertEquals((long)(10000 * sum), (long)sumOfAllIds.get());
    }
}

