/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.junit.Assert;
import org.junit.Test;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.test.JdbcMapperFactoryHelper;
import org.simpleflatmapper.test.beans.DbArrayObject;
import org.simpleflatmapper.test.beans.DbArrayOfString;
import org.simpleflatmapper.test.beans.DbObject;
import org.simpleflatmapper.test.jdbc.DbHelper;
import org.simpleflatmapper.test.jdbc.TestRowHandler;

public class JdbcMapperArrayTest {
    private static final String QUERY = "select 12 as id,  1 as objects_1_id, 'name 1' as objects_1_name, 'name1@mail.com' as objects_1_email, TIMESTAMP'2014-03-04 11:10:03' as objects_1_creation_time, 2 as objects_1_type_ordinal, 'type4' as objects_1_type_name,  1 as objects_2_id, 'name 1' as objects_2_name, 'name1@mail.com' as objects_2_email, TIMESTAMP'2014-03-04 11:10:03' as objects_2_creation_time, 2 as objects_2_type_ordinal, 'type4' as objects_2_type_name  from TEST_DB_OBJECT ";
    private static final String QUERY_LIST = "select  1 as objects_1_id, 'name 1' as objects_1_name, 'name1@mail.com' as objects_1_email, TIMESTAMP'2014-03-04 11:10:03' as objects_1_creation_time, 2 as objects_1_type_ordinal, 'type4' as objects_1_type_name,  1 as objects_2_id, 'name 1' as objects_2_name, 'name1@mail.com' as objects_2_email, TIMESTAMP'2014-03-04 11:10:03' as objects_2_creation_time, 2 as objects_2_type_ordinal, 'type4' as objects_2_type_name  from TEST_DB_OBJECT ";
    private static final String QUERY_STRING_LIST = "select 12 as id,  'value1' as objects_1, 'value2' as objects_2 from TEST_DB_OBJECT ";

    @Test
    public void testMapInnerObjectWithStaticMapperNoAsm() throws Exception {
        DbHelper.testQuery((TestRowHandler)new TestDbArrayObject(false), (String)QUERY);
    }

    @Test
    public void testMapInnerObjectWithStaticMapperAsm() throws Exception {
        DbHelper.testQuery((TestRowHandler)new TestDbArrayObject(true), (String)QUERY);
    }

    @Test
    public void testMapDbArrayOfStringNoAsm() throws Exception {
        DbHelper.testQuery((TestRowHandler)new TestDbArrayString(false), (String)QUERY_STRING_LIST);
    }

    @Test
    public void testMapArrayOfStringAsm() throws Exception {
        DbHelper.testQuery((TestRowHandler)new TestDbArrayString(true), (String)QUERY_STRING_LIST);
    }

    @Test
    public void testMapTestArrayObjectNoAsm() throws Exception {
        DbHelper.testQuery((TestRowHandler)new TestArrayObject(false), (String)QUERY_LIST);
    }

    @Test
    public void testMapTestArrayObjectAsm() throws Exception {
        DbHelper.testQuery((TestRowHandler)new TestArrayObject(true), (String)QUERY_LIST);
    }

    private static final class TestDbArrayString
    implements TestRowHandler<PreparedStatement> {
        private final boolean asm;

        public TestDbArrayString(boolean asm) {
            this.asm = asm;
        }

        public void handle(PreparedStatement t) throws Exception {
            ResultSet rs = t.executeQuery();
            JdbcMapperBuilder builder = ((JdbcMapperFactory)JdbcMapperFactoryHelper.asm().useAsm(this.asm)).newBuilder(DbArrayOfString.class).addMapping(rs.getMetaData());
            JdbcMapper mapper = (JdbcMapper)builder.mapper();
            rs.next();
            DbArrayOfString object = (DbArrayOfString)mapper.map(rs);
            Assert.assertEquals((long)12L, (long)object.getId());
            Assert.assertEquals((long)3L, (long)object.getObjects().length);
            Assert.assertNull((Object)object.getObjects()[0]);
            Assert.assertEquals((Object)"value1", (Object)object.getObjects()[1]);
            Assert.assertEquals((Object)"value2", (Object)object.getObjects()[2]);
        }
    }

    private static final class TestArrayObject
    implements TestRowHandler<PreparedStatement> {
        private final boolean asm;

        public TestArrayObject(boolean asm) {
            this.asm = asm;
        }

        public void handle(PreparedStatement t) throws Exception {
            ResultSet rs = t.executeQuery();
            JdbcMapper mapper = (JdbcMapper)((JdbcMapperFactory)JdbcMapperFactoryHelper.asm().useAsm(this.asm)).newBuilder(DbObject[].class).addMapping(rs.getMetaData()).mapper();
            rs.next();
            DbObject[] list = (DbObject[])mapper.map(rs);
            Assert.assertEquals((long)3L, (long)list.length);
            Assert.assertNull((Object)list[0]);
            DbHelper.assertDbObjectMapping((DbObject)list[1]);
            DbHelper.assertDbObjectMapping((DbObject)list[2]);
        }
    }

    private static final class TestDbArrayObject
    implements TestRowHandler<PreparedStatement> {
        private final boolean asm;

        public TestDbArrayObject(boolean asm) {
            this.asm = asm;
        }

        public void handle(PreparedStatement t) throws Exception {
            ResultSet rs = t.executeQuery();
            JdbcMapper mapper = (JdbcMapper)((JdbcMapperFactory)JdbcMapperFactoryHelper.asm().useAsm(this.asm)).newBuilder(DbArrayObject.class).addMapping(rs.getMetaData()).mapper();
            rs.next();
            DbArrayObject object = (DbArrayObject)mapper.map(rs);
            Assert.assertEquals((long)12L, (long)object.getId());
            Assert.assertEquals((long)3L, (long)object.getObjects().length);
            Assert.assertNull((Object)object.getObjects()[0]);
            DbHelper.assertDbObjectMapping((DbObject)object.getObjects()[1]);
            DbHelper.assertDbObjectMapping((DbObject)object.getObjects()[2]);
        }
    }
}

