/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.test.JdbcMapperFactoryHelper;
import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.map.mapper.StaticSetRowMapper;
import org.simpleflatmapper.reflect.BiInstantiator;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.InstantiatorFactory;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.asm.AsmFactory;
import org.simpleflatmapper.test.beans.DbObject;
import org.simpleflatmapper.util.BiFunction;

public class JdbcMapperBuilderImplTest {
    @Test
    public void testAddFieldMapper() {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(DbObject.class);
        JdbcMapper mapper = (JdbcMapper)((JdbcMapperBuilder)builder.addMapper((FieldMapper)new FieldMapper<ResultSet, DbObject>(){

            public void mapTo(ResultSet source, DbObject target, MappingContext<? super ResultSet> mappingContext) throws MappingException {
                target.setId(33L);
            }
        })).mapper();
        Assert.assertEquals((long)33L, (long)((DbObject)mapper.map(null)).getId());
    }

    @Test
    public void testAsmFailureOnmapper() throws NoSuchFieldException, IllegalAccessException {
        JdbcMapperBuilder builder = ((JdbcMapperFactory)JdbcMapperFactoryHelper.noFailOnAsm().reflectionService(new ReflectionService(this.newAsmFactoryFailsOnmapper()))).newBuilder(DbObject.class);
        JdbcMapper mapper = (JdbcMapper)builder.mapper();
        Field f = mapper.getClass().getDeclaredField("setRowMapper");
        f.setAccessible(true);
        Object subMapper = f.get(mapper);
        Assert.assertEquals(StaticSetRowMapper.class, subMapper.getClass());
    }

    public AsmFactory newAsmFactoryFailsOnmapper() {
        return new AsmFactory(Thread.currentThread().getContextClassLoader()){

            public Class<?> createClass(String className, byte[] bytes, ClassLoader declaringClassLoader) {
                throw new IllegalArgumentException("Invalid class");
            }
        };
    }

    @Test
    public void testAsmFailureOnJdbcMapperFailOnAsm() {
        JdbcMapperBuilder builder = ((JdbcMapperFactory)JdbcMapperFactoryHelper.asm().reflectionService(new ReflectionService(this.newAsmFactoryFailsOnmapper()))).newBuilder(DbObject.class);
        try {
            builder.mapper();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAsmFailureOnInstantiator() {
        JdbcMapperBuilder builder = ((JdbcMapperFactory)JdbcMapperFactoryHelper.noFailOnAsm().reflectionService(new ReflectionService(null){

            public InstantiatorFactory getInstantiatorFactory() {
                return new InstantiatorFactory(null){

                    public <S1, S2, T> BiInstantiator<S1, S2, T> getBiInstantiator(Type target, Class<?> s1, Class<?> s2, List<InstantiatorDefinition> constructors, Map<Parameter, BiFunction<? super S1, ? super S2, ?>> injections, boolean useAsmIfEnabled, boolean builderIgnoresNullValues) throws SecurityException {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        })).newBuilder(DbObject.class);
        try {
            builder.mapper();
            Assert.fail((String)"Expected exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

