/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.simpleflatmapper.converter.Context;
import org.simpleflatmapper.converter.ContextualConverter;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.test.JdbcMapperFactoryHelper;
import org.simpleflatmapper.map.property.ConverterProperty;
import org.simpleflatmapper.test.beans.DbEnumObject;
import org.simpleflatmapper.test.beans.DbObject;
import org.simpleflatmapper.tuple.Tuple2;
import org.simpleflatmapper.util.TypeReference;

public class JdbcMapperEnumTest {
    @Test
    public void testIndexedEnumUndefined() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(DbEnumObject.class);
        builder.addMapping("val", 1);
        JdbcMapper mapper = (JdbcMapper)builder.mapper();
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.getObject(1)).thenReturn((Object)2);
        Assert.assertEquals((Object)DbObject.Type.type3, (Object)((DbEnumObject)mapper.map(rs)).getVal());
        Mockito.when((Object)rs.getObject(1)).thenReturn((Object)"type2");
        Assert.assertEquals((Object)DbObject.Type.type2, (Object)((DbEnumObject)mapper.map(rs)).getVal());
    }

    @Test
    public void testIndexedEnumString() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(DbEnumObject.class);
        builder.addMapping("val", 1, 12);
        JdbcMapper mapper = (JdbcMapper)builder.mapper();
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.getString(1)).thenReturn((Object)"type2");
        Assert.assertEquals((Object)DbObject.Type.type2, (Object)((DbEnumObject)mapper.map(rs)).getVal());
    }

    @Test
    public void testIndexedEnumFactoryMethod() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(DbEnumObject.class);
        builder.addMapping("val", 1, 12, new Object[]{ConverterProperty.of((ContextualConverter)new ContextualConverter<String, DbObject.Type>(){

            public DbObject.Type convert(String s, Context context) throws Exception {
                return DbObject.Type.shortForm((String)s);
            }
        })});
        JdbcMapper mapper = (JdbcMapper)builder.mapper();
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.getString(1)).thenReturn((Object)"t2");
        Assert.assertEquals((Object)DbObject.Type.type2, (Object)((DbEnumObject)mapper.map(rs)).getVal());
    }

    @Test
    public void testIndexedEnumOrdinal() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(DbEnumObject.class);
        builder.addMapping("val", 1, 4);
        JdbcMapper mapper = (JdbcMapper)builder.mapper();
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.getInt(1)).thenReturn((Object)2);
        Assert.assertEquals((Object)DbObject.Type.type3, (Object)((DbEnumObject)mapper.map(rs)).getVal());
    }

    @Test
    public void testEnumRoot() throws SQLException {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(TypeRoot.class);
        builder.addMapping("c1");
        JdbcMapper mapper = (JdbcMapper)builder.mapper();
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.getObject(1)).thenReturn((Object)0);
        Mockito.when((Object)rs.next()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Assert.assertEquals((Object)((Object)TypeRoot.type1), mapper.iterator(rs).next());
    }

    @Test
    public void testEnumTuple() throws SQLException {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder((TypeReference)new TypeReference<Tuple2<TypeRoot, TypeRoot>>(){});
        builder.addMapping("0");
        builder.addMapping("1");
        JdbcMapper mapper = (JdbcMapper)builder.mapper();
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.getObject(1)).thenReturn((Object)0);
        Mockito.when((Object)rs.getObject(2)).thenReturn((Object)1);
        Mockito.when((Object)rs.next()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Tuple2 tuple = (Tuple2)mapper.iterator(rs).next();
        Assert.assertEquals((Object)((Object)TypeRoot.type1), (Object)tuple.first());
        Assert.assertEquals((Object)((Object)TypeRoot.type2), (Object)tuple.second());
    }

    public static enum TypeRoot {
        type1("1"),
        type2("2"),
        type3("3"),
        type4("4");

        private String value;

        private TypeRoot(String ... values) {
            this.value = values[0];
        }

        public String getValue() {
            return this.value;
        }
    }
}

