/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.junit.Assert;
import org.junit.Test;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.test.JdbcMapperFactoryHelper;
import org.simpleflatmapper.test.beans.Db1GenericObject;
import org.simpleflatmapper.test.jdbc.DbHelper;
import org.simpleflatmapper.test.jdbc.TestRowHandler;

public class JdbcMapperGenericObjectTest {
    private static final String QUERY = "select 33 as id, 'barbar' as bar_object_bar, 'foobar' as foo_object_bar, 'foofoo' as foo_object_foo from TEST_DB_OBJECT where id = 1 ";

    @Test
    public void testMapGenericObjectWithStaticMapper() throws Exception {
        JdbcMapperBuilder builder = (JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)JdbcMapperFactoryHelper.asm().newBuilder(Db1GenericObject.class).addMapping("id")).addMapping("bar_object_bar")).addMapping("foo_object_bar")).addMapping("foo_object_foo");
        final JdbcMapper mapper = (JdbcMapper)builder.mapper();
        DbHelper.testQuery((TestRowHandler)new TestRowHandler<PreparedStatement>(){

            public void handle(PreparedStatement t) throws Exception {
                ResultSet rs = t.executeQuery();
                rs.next();
                Db1GenericObject object = (Db1GenericObject)mapper.map(rs);
                Assert.assertEquals((long)33L, (long)object.getId());
                Assert.assertNotNull((Object)object.getBarObject());
                Assert.assertEquals((Object)"barbar", (Object)object.getBarObject().getBar());
                Assert.assertNotNull((Object)object.getFooObject());
                Assert.assertEquals((Object)"foobar", (Object)object.getFooObject().getBar());
                Assert.assertEquals((Object)"foofoo", (Object)object.getFooObject().getFoo());
            }
        }, (String)QUERY);
    }
}

