/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.test.JdbcMapperFactoryHelper;

public class JdbcMapperOneConstructorTypeTest {
    @Test
    public void testCanCreateTypeFromUnambiguousConstructorNoAsm() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.noAsm().newBuilder(MyObject.class);
        this.testMatchConstructor((JdbcMapperBuilder<MyObject>)builder);
    }

    @Test
    public void testCanCreateTypeFromUnambiguousConstructorAsm() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(MyObject.class);
        this.testMatchConstructor((JdbcMapperBuilder<MyObject>)builder);
    }

    @Test
    public void testCanCreateTypeFromAmbiguousWithType() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(MyObjectAmbiguity.class);
        builder.addMapping("prop", 1, 12);
        JdbcMapper mapper = (JdbcMapper)builder.mapper();
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.getString(1)).thenReturn((Object)"val");
        Assert.assertEquals((Object)"val", (Object)((MyObjectAmbiguity)mapper.map((ResultSet)rs)).prop.value);
    }

    private void testMatchConstructor(JdbcMapperBuilder<MyObject> builder) throws SQLException {
        builder.addMapping("prop");
        JdbcMapper mapper = (JdbcMapper)builder.mapper();
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.getString(1)).thenReturn((Object)"val");
        Assert.assertEquals((Object)"val", (Object)((MyObject)mapper.map((ResultSet)rs)).prop.value);
    }

    public static class SubObjectAmbiguity {
        private final String value;

        public SubObjectAmbiguity(String value) {
            this.value = value;
        }

        public SubObjectAmbiguity(String value, int ivalue) {
            this.value = value;
        }
    }

    public static class MyObjectAmbiguity {
        public SubObjectAmbiguity prop;
    }

    public static class SubObject {
        private final String value;

        public SubObject(String value) {
            this.value = value;
        }
    }

    public static class MyObject {
        public SubObject prop;
    }
}

