/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.test.JdbcMapperFactoryHelper;
import org.simpleflatmapper.map.SourceMapper;
import org.simpleflatmapper.test.beans.DbBoxedPrimitiveObject;
import org.simpleflatmapper.test.beans.DbFinalPrimitiveObject;
import org.simpleflatmapper.test.beans.DbPrimitiveObjectWithSetter;
import org.simpleflatmapper.test.beans.PrimitiveObject;

public class JdbcMapperPrimitiveTest {
    @Test
    public void testIndexedPrimitivesWithSetterAccess() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(DbPrimitiveObjectWithSetter.class);
        this.testIndexedPrimitives(builder);
    }

    @Test
    public void testIndexedPrimitivesWithConstructorAccess() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(DbFinalPrimitiveObject.class);
        this.testIndexedPrimitives(builder);
    }

    @Test
    public void testIndexedPrimitivesWithSetterAccessNoAsm() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.noAsm().newBuilder(DbPrimitiveObjectWithSetter.class);
        this.testIndexedPrimitives(builder);
    }

    @Test
    public void testIndexedBoxedPrimitivesWithFieldAccess() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(DbBoxedPrimitiveObject.class);
        this.testIndexedPrimitives(builder);
    }

    @Test
    public void testIndexedPrimitivesWithFieldAccessNullValues() throws Exception {
        JdbcMapperBuilder builder = JdbcMapperFactoryHelper.asm().newBuilder(DbBoxedPrimitiveObject.class);
        this.testIndexedPrimitivesWithNull((JdbcMapperBuilder<DbBoxedPrimitiveObject>)builder);
    }

    private <T extends PrimitiveObject> void testIndexedPrimitives(JdbcMapperBuilder<T> builder) throws SQLException, Exception {
        this.addIndexedColumn(builder);
        this.testPrimitives((SourceMapper<ResultSet, T>)builder.mapper());
    }

    private void testIndexedPrimitivesWithNull(JdbcMapperBuilder<DbBoxedPrimitiveObject> builder) throws SQLException, Exception {
        this.addIndexedColumn(builder);
        this.testPrimitivesWithNullValues((SourceMapper<ResultSet, DbBoxedPrimitiveObject>)builder.mapper());
    }

    private <T extends PrimitiveObject> void addIndexedColumn(JdbcMapperBuilder<T> builder) {
        ((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)builder.addMapping("pBoolean", 1)).addMapping("pByte", 2)).addMapping("pCharacter", 3)).addMapping("pShort", 4)).addMapping("pInt", 5)).addMapping("pLong", 6)).addMapping("pFloat", 7)).addMapping("pDouble", 8);
    }

    public <T extends PrimitiveObject> void testPrimitives(SourceMapper<ResultSet, T> mapper) throws SQLException, Exception {
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.getBoolean(1)).thenReturn((Object)true);
        Mockito.when((Object)rs.getByte(2)).thenReturn((Object)-93);
        Mockito.when((Object)rs.getInt(3)).thenReturn((Object)164);
        Mockito.when((Object)rs.getShort(4)).thenReturn((Object)165);
        Mockito.when((Object)rs.getInt(5)).thenReturn((Object)166);
        Mockito.when((Object)rs.getLong(6)).thenReturn((Object)65444L);
        Mockito.when((Object)Float.valueOf(rs.getFloat(7))).thenReturn((Object)Float.valueOf(3.14f));
        Mockito.when((Object)rs.getDouble(8)).thenReturn((Object)3.14159);
        PrimitiveObject object = (PrimitiveObject)mapper.map((Object)rs, null);
        Assert.assertEquals((Object)true, (Object)object.ispBoolean());
        Assert.assertEquals((long)-93L, (long)object.getpByte());
        Assert.assertEquals((long)164L, (long)object.getpCharacter());
        Assert.assertEquals((long)165L, (long)object.getpShort());
        Assert.assertEquals((long)166L, (long)object.getpInt());
        Assert.assertEquals((long)65444L, (long)object.getpLong());
        Assert.assertEquals((float)3.14f, (float)object.getpFloat(), (float)0.0f);
        Assert.assertEquals((double)3.14159, (double)object.getpDouble(), (double)0.0);
    }

    public void testPrimitivesWithNullValues(SourceMapper<ResultSet, DbBoxedPrimitiveObject> mapper) throws SQLException, Exception {
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.wasNull()).thenReturn((Object)true);
        Mockito.when((Object)rs.getBoolean(1)).thenReturn((Object)false);
        Mockito.when((Object)rs.getByte(2)).thenReturn((Object)0);
        Mockito.when((Object)rs.getInt(3)).thenReturn((Object)0);
        Mockito.when((Object)rs.getShort(4)).thenReturn((Object)0);
        Mockito.when((Object)rs.getInt(5)).thenReturn((Object)0);
        Mockito.when((Object)rs.getLong(6)).thenReturn((Object)0L);
        Mockito.when((Object)Float.valueOf(rs.getFloat(7))).thenReturn((Object)Float.valueOf(0.0f));
        Mockito.when((Object)rs.getDouble(8)).thenReturn((Object)0.0);
        DbBoxedPrimitiveObject object = (DbBoxedPrimitiveObject)mapper.map((Object)rs, null);
        Assert.assertNull((Object)object.getoBoolean());
        Assert.assertNull((Object)object.getoByte());
        Assert.assertNull((Object)object.getoCharacter());
        Assert.assertNull((Object)object.getoShort());
        Assert.assertNull((Object)object.getoInt());
        Assert.assertNull((Object)object.getoLong());
        Assert.assertNull((Object)object.getoFloat());
        Assert.assertNull((Object)object.getoDouble());
    }
}

