/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.simpleflatmapper.jdbc.JdbcColumnKey;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.test.JoinJdbcMapperOnTupleTest;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.ListCollector;
import org.simpleflatmapper.util.Predicate;

public class JoinJdbcMapperCustomKeyTest {
    @Test
    public void test() throws SQLException {
        JdbcMapper mapper = (JdbcMapper)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperFactory)JdbcMapperFactory.newInstance().addColumnDefinition((Predicate)new Predicate<JdbcColumnKey>(){

            public boolean test(JdbcColumnKey jdbcColumnKey) {
                return jdbcColumnKey.getIndex() <= 2;
            }
        }, (ColumnDefinition)FieldMapperColumnDefinition.key((Predicate)new Predicate<PropertyMeta<?, ?>>(){

            public boolean test(PropertyMeta<?, ?> propertyMeta) {
                return propertyMeta.getPath().startsWith("key.");
            }
        }))).newBuilder(Person.class).addMapping("key_tag")).addMapping("key_n")).addMapping("name")).addMapping("phones_value")).mapper();
        ResultSet rs = JoinJdbcMapperOnTupleTest.setUpResultSetMock(new String[]{"key_tag", "key_n", "name", "phones_value"}, new Object[][]{{"t1", 1, "t11", "p111"}, {"t1", 1, "t11", "p112"}, {"t1", 2, "t12", "p121"}});
        List list = ((ListCollector)mapper.forEach(rs, (CheckedConsumer)new ListCollector())).getList();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"t1", (Object)((Person)list.get((int)0)).key.tag);
        Assert.assertEquals((long)1L, (long)((Person)list.get((int)0)).key.n);
        Assert.assertEquals((Object)"t11", (Object)((Person)list.get((int)0)).name);
        Assert.assertEquals(Arrays.asList("p111", "p112"), ((Person)list.get((int)0)).phones);
        Assert.assertEquals((Object)"t1", (Object)((Person)list.get((int)1)).key.tag);
        Assert.assertEquals((long)2L, (long)((Person)list.get((int)1)).key.n);
        Assert.assertEquals((Object)"t12", (Object)((Person)list.get((int)1)).name);
        Assert.assertEquals(Arrays.asList("p121"), ((Person)list.get((int)1)).phones);
    }

    public static class Person {
        public PersonKey key;
        public String name;
        public List<String> phones;
    }

    public static class PersonKey {
        public String tag;
        public int n;
    }
}

