/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.math.BigDecimal;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.simpleflatmapper.jdbc.DynamicJdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.test.jdbc.DbHelper;

public class PostgresqlMapperTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test530() throws SQLException {
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)DbHelper.TargetDB.POSTGRESQL);
        if (connection == null) {
            System.err.println("Db Postgresql not available");
            return;
        }
        try {
            DynamicJdbcMapper mapper = JdbcMapperFactory.newInstance().newMapper(O530.class);
            try (Statement statement = connection.createStatement();){
                statement.execute("DROP TABLE IF EXISTS  o530 ");
                statement.execute("create TABLE o530 (  value double precision)");
                statement.execute("INSERT INTO o530(value) VALUES(3.14159)");
                try (ResultSet rs = statement.executeQuery("SELECT value from o530");){
                    Iterator iterator = mapper.iterator(rs);
                    O530 next = (O530)iterator.next();
                    Assert.assertTrue((boolean)(next.value instanceof Double));
                    Assert.assertEquals((double)3.14159, (double)next.value.doubleValue(), (double)1.0E-7);
                }
                JdbcMapper mapper2 = (JdbcMapper)((JdbcMapperBuilder)JdbcMapperFactory.newInstance().newBuilder(O530.class).addMapping("value")).mapper();
                rs = statement.executeQuery("SELECT value from o530");
                try {
                    Iterator iterator = mapper2.iterator(rs);
                    O530 next = (O530)iterator.next();
                    Assert.assertTrue((boolean)(next.value instanceof BigDecimal));
                    Assert.assertEquals((double)3.14159, (double)next.value.doubleValue(), (double)1.0E-7);
                }
                finally {
                    rs.close();
                }
            }
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBatchUpsertOnDb() throws SQLException {
        Connection connection = DbHelper.getDbConnection((DbHelper.TargetDB)DbHelper.TargetDB.POSTGRESQL);
        if (connection == null) {
            System.err.println("Db Postgresql not available");
            return;
        }
        try {
            DynamicJdbcMapper mapper = JdbcMapperFactory.newInstance().newMapper(InetAndCidr.class);
            DynamicJdbcMapper mapperStr = JdbcMapperFactory.newInstance().newMapper(InetAndCidrAsString.class);
            try (Statement statement = connection.createStatement();){
                statement.execute("DROP TABLE IF EXISTS  iac ");
                statement.execute("create TABLE iac (  field1 inet, field2 cidr)");
                statement.execute("INSERT INTO iac(field1, field2) VALUES('10.1.0.1', '10.1.0.0/22')");
                try (ResultSet rs = statement.executeQuery("SELECT field1, field2 from iac");){
                    Iterator iterator = mapper.iterator(rs);
                    InetAndCidr next = (InetAndCidr)iterator.next();
                    System.out.println("next = " + next);
                }
                rs = statement.executeQuery("SELECT field1, field2 from iac");
                try {
                    Iterator iteratorStr = mapperStr.iterator(rs);
                    InetAndCidrAsString inetAndCidrAsString = (InetAndCidrAsString)iteratorStr.next();
                    System.out.println("inetAndCidrAsString = " + inetAndCidrAsString);
                }
                finally {
                    rs.close();
                }
            }
        }
        finally {
            connection.close();
        }
    }

    public static class InetAndCidrAsString {
        public String field1;
        public String field2;

        public String toString() {
            return "InetAndCidrAsString{field1='" + this.field1 + '\'' + ", field2='" + this.field2 + '\'' + '}';
        }
    }

    public static class InetAndCidr {
        public InetAddress field1;
        public Object field2;

        public String toString() {
            return "InetAndCidr{field1=" + this.field1 + ", field2=" + this.field2 + '}';
        }
    }

    public static class O530 {
        public Number value;
    }
}

