/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test;

import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.Date;
import org.junit.Test;
import org.mockito.Mockito;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.PreparedStatementMapperBuilder;
import org.simpleflatmapper.map.mapper.ContextualSourceFieldMapperImpl;
import org.simpleflatmapper.map.property.ConstantValueProperty;
import org.simpleflatmapper.map.property.GetterProperty;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.test.beans.DbObject;

public class QueryPreparerBuilderTest {
    @Test
    public void testMapDbObjectToStatement() throws Exception {
        ContextualSourceFieldMapperImpl mapper = ((PreparedStatementMapperBuilder)((PreparedStatementMapperBuilder)((PreparedStatementMapperBuilder)((PreparedStatementMapperBuilder)JdbcMapperFactory.newInstance().buildFrom(DbObject.class).addColumn("id")).addColumn("name")).addColumn("email")).addColumn("creation_time")).mapper();
        PreparedStatement ps = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        DbObject dbObject = new DbObject();
        dbObject.setId(123L);
        dbObject.setName("name");
        dbObject.setEmail("email");
        dbObject.setCreationTime(new Date());
        mapper.mapTo((Object)dbObject, (Object)ps, null);
        ((PreparedStatement)Mockito.verify((Object)ps)).setLong(1, 123L);
        ((PreparedStatement)Mockito.verify((Object)ps)).setString(2, "name");
        ((PreparedStatement)Mockito.verify((Object)ps)).setString(3, "email");
        ((PreparedStatement)Mockito.verify((Object)ps)).setTimestamp(4, new Timestamp(dbObject.getCreationTime().getTime()));
    }

    @Test
    public void testDirectMeta() throws Exception {
        PreparedStatementMapperBuilder mapperBuilder = JdbcMapperFactory.newInstance().buildFrom(DMClass.class);
        mapperBuilder.addColumn("time");
        ContextualSourceFieldMapperImpl mapper = mapperBuilder.mapper();
        DMClass dmClass = new DMClass();
        dmClass.setTime(new Date());
        PreparedStatement ps = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        mapper.mapTo((Object)dmClass, (Object)ps, null);
        ((PreparedStatement)Mockito.verify((Object)ps)).setTimestamp(1, new Timestamp(dmClass.getTime().getTime()));
    }

    @Test
    public void testGetterOnlyMethod() throws Exception {
        PreparedStatementMapperBuilder mapperBuilder = JdbcMapperFactory.newInstance().buildFrom(DMClass.class);
        mapperBuilder.addColumn("value");
        ContextualSourceFieldMapperImpl mapper = mapperBuilder.mapper();
        DMClass dmClass = new DMClass();
        PreparedStatement ps = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        mapper.mapTo((Object)dmClass, (Object)ps, null);
        ((PreparedStatement)Mockito.verify((Object)ps)).setString(1, "value");
    }

    @Test
    public void testRename() throws Exception {
        PreparedStatementMapperBuilder mapperBuilder = ((JdbcMapperFactory)JdbcMapperFactory.newInstance().addAlias("val", "value")).buildFrom(DMClass.class);
        mapperBuilder.addColumn("val");
        ContextualSourceFieldMapperImpl mapper = mapperBuilder.mapper();
        DMClass dmClass = new DMClass();
        PreparedStatement ps = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        mapper.mapTo((Object)dmClass, (Object)ps, null);
        ((PreparedStatement)Mockito.verify((Object)ps)).setString(1, "value");
    }

    @Test
    public void testCustomGetter() throws Exception {
        PreparedStatementMapperBuilder mapperBuilder = ((JdbcMapperFactory)JdbcMapperFactory.newInstance().addColumnProperty("value", new Object[]{new GetterProperty((Getter)new Getter<Object, String>(){

            public String get(Object target) throws Exception {
                return "value2";
            }
        })})).buildFrom(DMClass.class);
        mapperBuilder.addColumn("value");
        ContextualSourceFieldMapperImpl mapper = mapperBuilder.mapper();
        DMClass dmClass = new DMClass();
        PreparedStatement ps = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        mapper.mapTo((Object)dmClass, (Object)ps, null);
        ((PreparedStatement)Mockito.verify((Object)ps)).setString(1, "value2");
    }

    @Test
    public void testCustomGetterOnNonExistantProp() throws Exception {
        PreparedStatementMapperBuilder mapperBuilder = ((JdbcMapperFactory)JdbcMapperFactory.newInstance().addColumnProperty("text", new Object[]{new ConstantValueProperty((Object)"value2", String.class)})).buildFrom(Object.class);
        mapperBuilder.addColumn("text");
        ContextualSourceFieldMapperImpl mapper = mapperBuilder.mapper();
        PreparedStatement ps = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        mapper.mapTo(new Object(), (Object)ps, null);
        ((PreparedStatement)Mockito.verify((Object)ps)).setString(1, "value2");
    }

    public static class DMClass {
        private Date time;

        public Date getTime() {
            return this.time;
        }

        public void setTime(Date time) {
            this.time = time;
        }

        public String getValue() {
            return "value";
        }
    }
}

