/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test.impl.getter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Calendar;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.simpleflatmapper.jdbc.JdbcColumnKey;
import org.simpleflatmapper.jdbc.ResultSetGetterFactory;
import org.simpleflatmapper.jdbc.SqlTypeColumnProperty;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.primitive.IntGetter;
import org.simpleflatmapper.util.UUIDHelper;

public class ResultSetGetterFactoryTest {
    public static final FieldMapperColumnDefinition<JdbcColumnKey> IDENTITY = FieldMapperColumnDefinition.identity();
    ResultSetGetterFactory factory;
    ResultSet resultSet;

    @Before
    public void setUp() {
        this.factory = ResultSetGetterFactory.INSTANCE;
        this.resultSet = (ResultSet)Mockito.mock(ResultSet.class);
    }

    @Test
    public void testInt() throws Exception {
        Mockito.when((Object)this.resultSet.getInt(1)).thenReturn((Object)13);
        IntGetter intGetter = (IntGetter)this.factory.newGetter(Integer.class, this.key(2), IDENTITY.properties());
        Assert.assertEquals((long)13L, (long)intGetter.getInt((Object)this.resultSet));
        intGetter = (IntGetter)this.factory.newGetter(Integer.TYPE, this.key(2), IDENTITY.properties());
        Assert.assertEquals((long)13L, (long)intGetter.getInt((Object)this.resultSet));
    }

    @Test
    public void testNString() throws Exception {
        Mockito.when((Object)this.resultSet.getNString(1)).thenReturn((Object)"value");
        Assert.assertEquals((Object)"value", (Object)this.factory.newGetter(String.class, this.key(-15), IDENTITY.properties()).get((Object)this.resultSet));
        Assert.assertEquals((Object)"value", (Object)this.factory.newGetter(String.class, this.key(2011), IDENTITY.properties()).get((Object)this.resultSet));
        Assert.assertEquals((Object)"value", (Object)this.factory.newGetter(String.class, this.key(-9), IDENTITY.properties()).get((Object)this.resultSet));
    }

    @Test
    public void testBlob() throws Exception {
        Blob blob = (Blob)Mockito.mock(Blob.class);
        Mockito.when((Object)this.resultSet.getBlob(1)).thenReturn((Object)blob);
        Getter getter = this.factory.newGetter(Blob.class, this.key(2004), IDENTITY.properties());
        Assert.assertEquals((Object)blob, (Object)getter.get((Object)this.resultSet));
        Assert.assertEquals((Object)"BlobResultSetGetter{property=1}", (Object)getter.toString());
    }

    @Test
    public void testClob() throws Exception {
        Clob blob = (Clob)Mockito.mock(Clob.class);
        Mockito.when((Object)this.resultSet.getClob(1)).thenReturn((Object)blob);
        Getter getter = this.factory.newGetter(Clob.class, this.key(2005), IDENTITY.properties());
        Assert.assertEquals((Object)blob, (Object)getter.get((Object)this.resultSet));
        Assert.assertEquals((Object)"ClobResultSetGetter{property=1}", (Object)getter.toString());
    }

    @Test
    public void testReader() throws Exception {
        Reader blob = (Reader)Mockito.mock(Reader.class);
        Mockito.when((Object)this.resultSet.getCharacterStream(1)).thenReturn((Object)blob);
        Getter getter = this.factory.newGetter(Reader.class, this.key(2005), IDENTITY.properties());
        Assert.assertEquals((Object)blob, (Object)getter.get((Object)this.resultSet));
        Assert.assertEquals((Object)"ReaderResultSetGetter{property=1}", (Object)getter.toString());
    }

    @Test
    public void testNClob() throws Exception {
        NClob blob = (NClob)Mockito.mock(NClob.class);
        Mockito.when((Object)this.resultSet.getNClob(1)).thenReturn((Object)blob);
        Getter getter = this.factory.newGetter(NClob.class, this.key(2011), IDENTITY.properties());
        Assert.assertEquals((Object)blob, (Object)getter.get((Object)this.resultSet));
        Assert.assertEquals((Object)"NClobResultSetGetter{property=1}", (Object)getter.toString());
    }

    @Test
    public void testNReader() throws Exception {
        Reader blob = (Reader)Mockito.mock(Reader.class);
        Mockito.when((Object)this.resultSet.getNCharacterStream(1)).thenReturn((Object)blob);
        Getter getter = this.factory.newGetter(Reader.class, this.key(2011), IDENTITY.properties());
        Assert.assertEquals((Object)blob, (Object)getter.get((Object)this.resultSet));
        Assert.assertEquals((Object)"NReaderResultSetGetter{property=1}", (Object)getter.toString());
    }

    @Test
    public void testInputStream() throws Exception {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)this.resultSet.getBinaryStream(1)).thenReturn((Object)inputStream);
        Getter getter = this.factory.newGetter(InputStream.class, this.key(2004), IDENTITY.properties());
        Assert.assertEquals((Object)inputStream, (Object)getter.get((Object)this.resultSet));
        Assert.assertEquals((Object)"InputStreamResultSetGetter{property=1}", (Object)getter.toString());
    }

    @Test
    public void testRef() throws Exception {
        Ref ref = (Ref)Mockito.mock(Ref.class);
        Mockito.when((Object)this.resultSet.getRef(1)).thenReturn((Object)ref);
        Getter getter = this.factory.newGetter(Ref.class, this.key(2006), IDENTITY.properties());
        Assert.assertEquals((Object)ref, (Object)getter.get((Object)this.resultSet));
        Assert.assertEquals((Object)"RefResultSetGetter{property=1}", (Object)getter.toString());
    }

    @Test
    public void testRowId() throws Exception {
        RowId rowId = (RowId)Mockito.mock(RowId.class);
        Mockito.when((Object)this.resultSet.getRowId(1)).thenReturn((Object)rowId);
        Getter getter = this.factory.newGetter(RowId.class, this.key(-8), IDENTITY.properties());
        Assert.assertEquals((Object)rowId, (Object)getter.get((Object)this.resultSet));
        Assert.assertEquals((Object)"RowIdResultSetGetter{property=1}", (Object)getter.toString());
    }

    @Test
    public void testSqlArray() throws Exception {
        Array array = (Array)Mockito.mock(Array.class);
        Mockito.when((Object)this.resultSet.getArray(1)).thenReturn((Object)array);
        Getter getter = this.factory.newGetter(Array.class, this.key(2003), IDENTITY.properties());
        Assert.assertEquals((Object)array, (Object)getter.get((Object)this.resultSet));
        Assert.assertEquals((Object)"SqlArrayResultSetGetter{property=1}", (Object)getter.toString());
    }

    @Test
    public void testSqlXml() throws Exception {
        SQLXML sqlxml = (SQLXML)Mockito.mock(SQLXML.class);
        Mockito.when((Object)this.resultSet.getSQLXML(1)).thenReturn((Object)sqlxml);
        Getter getter = this.factory.newGetter(SQLXML.class, this.key(2009), IDENTITY.properties());
        Assert.assertEquals((Object)sqlxml, (Object)getter.get((Object)this.resultSet));
        Assert.assertEquals((Object)"SQLXMLResultSetGetter{property=1}", (Object)getter.toString());
    }

    @Test
    public void testUrl() throws Exception {
        URL url = new URL("http://url.net");
        Mockito.when((Object)this.resultSet.getURL(1)).thenReturn((Object)url);
        Getter getter = this.factory.newGetter(URL.class, this.key(70), IDENTITY.properties());
        Assert.assertEquals((Object)url, (Object)getter.get((Object)this.resultSet));
        Assert.assertEquals((Object)"UrlResultSetGetter{property=1}", (Object)getter.toString());
    }

    @Test
    public void testUrlFromString() throws Exception {
        URL url = new URL("http://url.net");
        Mockito.when((Object)this.resultSet.getString(1)).thenReturn((Object)"http://url.net");
        Getter getter = this.factory.newGetter(URL.class, this.key(12), IDENTITY.properties());
        Assert.assertEquals((Object)url, (Object)getter.get((Object)this.resultSet));
        Assert.assertEquals((Object)"UrlFromStringResultSetGetter{property=1}", (Object)getter.toString());
    }

    @Test
    public void testJavaUtilDateFromUndefined() throws Exception {
        java.util.Date date = new java.util.Date(13L);
        Mockito.when((Object)this.resultSet.getObject(1)).thenReturn((Object)date);
        Getter getter = this.factory.newGetter(java.util.Date.class, this.key(-99999), IDENTITY.properties());
        Assert.assertEquals((Object)date, (Object)getter.get((Object)this.resultSet));
        Mockito.when((Object)this.resultSet.getObject(1)).thenReturn((Object)131L);
        Assert.assertEquals((Object)new java.util.Date(131L), (Object)getter.get((Object)this.resultSet));
        Assert.assertEquals((Object)"UndefinedDateResultSetGetter{property=1}", (Object)getter.toString());
    }

    @Test
    public void testTime() throws Exception {
        Time time = new Time(10000L);
        Mockito.when((Object)this.resultSet.getTime(1)).thenReturn((Object)time);
        Assert.assertEquals((Object)time, (Object)this.factory.newGetter(Time.class, this.key(-99999), IDENTITY.properties()).get((Object)this.resultSet));
        Getter getter = this.factory.newGetter(java.util.Date.class, this.key(92), IDENTITY.properties());
        Assert.assertEquals((Object)time, (Object)getter.get((Object)this.resultSet));
        Assert.assertEquals((Object)"TimeResultSetGetter{property=1}", (Object)getter.toString());
    }

    @Test
    public void testTimestamp() throws Exception {
        Timestamp time = new Timestamp(10000L);
        Mockito.when((Object)this.resultSet.getTimestamp(1)).thenReturn((Object)time);
        Assert.assertEquals((Object)time, (Object)this.factory.newGetter(Timestamp.class, this.key(-99999), IDENTITY.properties()).get((Object)this.resultSet));
        Getter getter = this.factory.newGetter(java.util.Date.class, this.key(93), IDENTITY.properties());
        Assert.assertEquals((Object)time, (Object)getter.get((Object)this.resultSet));
        Assert.assertEquals((Object)"TimestampResultSetGetter{property=1}", (Object)getter.toString());
    }

    @Test
    public void testSqlDate() throws Exception {
        Date time = new Date(10000L);
        Mockito.when((Object)this.resultSet.getDate(1)).thenReturn((Object)time);
        Assert.assertEquals((Object)time, (Object)this.factory.newGetter(Date.class, this.key(-99999), IDENTITY.properties()).get((Object)this.resultSet));
        Getter getter = this.factory.newGetter(java.util.Date.class, this.key(91), IDENTITY.properties());
        Assert.assertEquals((Object)time, (Object)getter.get((Object)this.resultSet));
        Assert.assertEquals((Object)"DateResultSetGetter{property=1}", (Object)getter.toString());
    }

    @Test
    public void testObject() throws Exception {
        Object object = new Object();
        Mockito.when((Object)this.resultSet.getObject(1)).thenReturn(object);
        Getter getter = this.factory.newGetter(Object.class, this.key(-99999), IDENTITY.properties());
        Assert.assertEquals((Object)object, (Object)getter.get((Object)this.resultSet));
        Assert.assertEquals((Object)"ObjectResultSetGetter{property=1}", (Object)getter.toString());
    }

    @Test
    public void testBigDecimal() throws Exception {
        BigDecimal bg = new BigDecimal("3.14");
        Mockito.when((Object)this.resultSet.getBigDecimal(1)).thenReturn((Object)bg);
        Getter getter = this.factory.newGetter(BigDecimal.class, this.key(3), IDENTITY.properties());
        Assert.assertEquals((Object)bg, (Object)getter.get((Object)this.resultSet));
        Mockito.reset((Object[])new ResultSet[]{this.resultSet});
        Mockito.when((Object)this.resultSet.getBigDecimal(1)).thenReturn(null);
        Assert.assertNull((Object)getter.get((Object)this.resultSet));
        Mockito.reset((Object[])new ResultSet[]{this.resultSet});
        getter = this.factory.newGetter(BigDecimal.class, this.key(12), IDENTITY.properties());
        Mockito.when((Object)this.resultSet.getString(1)).thenReturn((Object)"3.14");
        Assert.assertEquals((Object)bg, (Object)getter.get((Object)this.resultSet));
        Mockito.reset((Object[])new ResultSet[]{this.resultSet});
        Mockito.when((Object)this.resultSet.getString(1)).thenReturn(null);
        Assert.assertNull((Object)getter.get((Object)this.resultSet));
        Mockito.reset((Object[])new ResultSet[]{this.resultSet});
        getter = this.factory.newGetter(BigDecimal.class, this.key(3), ((FieldMapperColumnDefinition)IDENTITY.add(new Object[]{SqlTypeColumnProperty.of((int)12)})).properties());
        Mockito.when((Object)this.resultSet.getString(1)).thenReturn((Object)"3.14");
        Assert.assertEquals((Object)bg, (Object)getter.get((Object)this.resultSet));
        Mockito.reset((Object[])new ResultSet[]{this.resultSet});
        Mockito.when((Object)this.resultSet.getString(1)).thenReturn(null);
        Assert.assertNull((Object)getter.get((Object)this.resultSet));
    }

    @Test
    public void testBigInteger() throws Exception {
        BigDecimal bg = new BigDecimal("314");
        Mockito.when((Object)this.resultSet.getBigDecimal(1)).thenReturn((Object)bg);
        Getter getter = this.factory.newGetter(BigInteger.class, this.key(3), IDENTITY.properties());
        Assert.assertEquals((Object)bg.toBigInteger(), (Object)getter.get((Object)this.resultSet));
        Mockito.reset((Object[])new ResultSet[]{this.resultSet});
        Mockito.when((Object)this.resultSet.getBigDecimal(1)).thenReturn(null);
        Assert.assertNull((Object)getter.get((Object)this.resultSet));
        Mockito.reset((Object[])new ResultSet[]{this.resultSet});
        getter = this.factory.newGetter(BigInteger.class, this.key(12), IDENTITY.properties());
        Mockito.when((Object)this.resultSet.getString(1)).thenReturn((Object)"314");
        Assert.assertEquals((Object)bg.toBigInteger(), (Object)getter.get((Object)this.resultSet));
        Mockito.reset((Object[])new ResultSet[]{this.resultSet});
        Mockito.when((Object)this.resultSet.getString(1)).thenReturn(null);
        Assert.assertNull((Object)getter.get((Object)this.resultSet));
        Mockito.reset((Object[])new ResultSet[]{this.resultSet});
        getter = this.factory.newGetter(BigInteger.class, this.key(3), ((FieldMapperColumnDefinition)IDENTITY.add(new Object[]{SqlTypeColumnProperty.of((int)12)})).properties());
        Mockito.when((Object)this.resultSet.getString(1)).thenReturn((Object)"314");
        Assert.assertEquals((Object)bg.toBigInteger(), (Object)getter.get((Object)this.resultSet));
        Mockito.reset((Object[])new ResultSet[]{this.resultSet});
        Mockito.when((Object)this.resultSet.getString(1)).thenReturn(null);
        Assert.assertNull((Object)getter.get((Object)this.resultSet));
    }

    private JdbcColumnKey key(int type) {
        return new JdbcColumnKey("NA", 1, type);
    }

    @Test
    public void testCalendar() throws Exception {
        String date = "20150128";
        java.util.Date dd = new SimpleDateFormat("yyyyMMdd").parse(date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(dd);
        Mockito.when((Object)this.resultSet.getTimestamp(1)).thenReturn((Object)new Timestamp(dd.getTime()));
        Getter getter = this.factory.newGetter(Calendar.class, this.key(93), IDENTITY.properties());
        Assert.assertEquals((Object)cal, (Object)getter.get((Object)this.resultSet));
        Assert.assertEquals((Object)"CalendarResultSetGetter{dateGetter=TimestampResultSetGetter{property=1}}", (Object)getter.toString());
    }

    @Test
    public void testCalendarOnInvalidType() throws Exception {
        Getter getter = this.factory.newGetter(Calendar.class, this.key(12), IDENTITY.properties());
        Assert.assertNull((Object)getter);
    }

    @Test
    public void testSQLData() throws Exception {
        Getter getter = this.factory.newGetter(SQLDataImpl.class, this.key(2000), IDENTITY.properties());
        SQLDataImpl object = new SQLDataImpl();
        Mockito.when((Object)this.resultSet.getObject(1)).thenReturn((Object)object);
        Assert.assertEquals((Object)object, (Object)getter.get((Object)this.resultSet));
    }

    @Test
    public void testJavaOffsetDateTime() throws Exception {
        OffsetDateTime offsetDateTime = OffsetDateTime.now();
        Mockito.when((Object)this.resultSet.getObject(1)).thenReturn((Object)offsetDateTime, new Object[]{null});
        Getter getter = this.factory.newGetter(OffsetDateTime.class, this.key(2014), new Object[0]);
        Assert.assertEquals((Object)offsetDateTime, (Object)getter.get((Object)this.resultSet));
        Assert.assertNull((Object)getter.get((Object)this.resultSet));
    }

    @Test
    public void testJavaOffsetTime() throws Exception {
        OffsetTime offsetTime = OffsetTime.now();
        Mockito.when((Object)this.resultSet.getObject(1)).thenReturn((Object)offsetTime, new Object[]{null});
        Getter getter = this.factory.newGetter(OffsetTime.class, this.key(2013), new Object[0]);
        Assert.assertEquals((Object)offsetTime, (Object)getter.get((Object)this.resultSet));
        Assert.assertNull((Object)getter.get((Object)this.resultSet));
    }

    @Test
    public void testUUIDUndefinedType() throws Exception {
        UUID uuid = UUID.randomUUID();
        Mockito.when((Object)this.resultSet.getObject(1)).thenReturn((Object)uuid.toString(), new Object[]{UUIDHelper.toBytes((UUID)uuid), new ByteArrayInputStream(UUIDHelper.toBytes((UUID)uuid))});
        Getter getter = this.factory.newGetter(UUID.class, this.key(-99999), IDENTITY.properties());
        Assert.assertEquals((Object)uuid, (Object)getter.get((Object)this.resultSet));
        Assert.assertEquals((Object)uuid, (Object)getter.get((Object)this.resultSet));
        Assert.assertEquals((Object)uuid, (Object)getter.get((Object)this.resultSet));
    }

    @Test
    public void testUUIDString() throws Exception {
        UUID uuid = UUID.randomUUID();
        Mockito.when((Object)this.resultSet.getString(1)).thenReturn((Object)uuid.toString());
        Getter getter = this.factory.newGetter(UUID.class, this.key(12), IDENTITY.properties());
        Assert.assertEquals((Object)uuid, (Object)getter.get((Object)this.resultSet));
    }

    @Test
    public void testUUIDBytes() throws Exception {
        UUID uuid = UUID.randomUUID();
        Mockito.when((Object)this.resultSet.getBytes(1)).thenReturn((Object)UUIDHelper.toBytes((UUID)uuid));
        Getter getter = this.factory.newGetter(UUID.class, this.key(-2), IDENTITY.properties());
        Assert.assertEquals((Object)uuid, (Object)getter.get((Object)this.resultSet));
    }

    public static class SQLDataImpl
    implements SQLData {
        @Override
        public String getSQLTypeName() throws SQLException {
            return "MyName";
        }

        @Override
        public void readSQL(SQLInput stream, String typeName) throws SQLException {
        }

        @Override
        public void writeSQL(SQLOutput stream) throws SQLException {
        }
    }
}

