/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test.named;

import org.junit.Assert;
import org.junit.Test;
import org.simpleflatmapper.jdbc.named.NamedSqlQuery;

public class NamedSqlQueryTest {
    @Test
    public void testInsertQuestionMark() {
        String sql = "INSERT INTO table(col1, col2) values(?, ?)";
        NamedSqlQuery namedSqlQuery = NamedSqlQuery.parse((CharSequence)sql);
        Assert.assertEquals((long)2L, (long)namedSqlQuery.getParametersSize());
        Assert.assertEquals((Object)"col1", (Object)namedSqlQuery.getParameter(0).getName());
        Assert.assertEquals((Object)"col2", (Object)namedSqlQuery.getParameter(1).getName());
        Assert.assertEquals((Object)"INSERT INTO table(col1, col2) values(?, ?)", (Object)namedSqlQuery.toSqlQuery());
    }

    @Test
    public void testParseComplexSql() {
        String sql = "SELECT a, b, c FROM table where a in (?, :futon) and b=lower(?) and c = :c and upper(lower(d)) = ? and upper(lower(e)) = upper(lower(?)) and lower(f) = upper(lower(?))";
        NamedSqlQuery namedSqlQuery = NamedSqlQuery.parse((CharSequence)sql);
        Assert.assertEquals((long)7L, (long)namedSqlQuery.getParametersSize());
        Assert.assertEquals((Object)"a", (Object)namedSqlQuery.getParameter(0).getName());
        Assert.assertEquals((Object)"futon", (Object)namedSqlQuery.getParameter(1).getName());
        Assert.assertEquals((Object)"b", (Object)namedSqlQuery.getParameter(2).getName());
        Assert.assertEquals((Object)"c", (Object)namedSqlQuery.getParameter(3).getName());
        Assert.assertEquals((Object)"d", (Object)namedSqlQuery.getParameter(4).getName());
        Assert.assertEquals((Object)"e", (Object)namedSqlQuery.getParameter(5).getName());
        Assert.assertEquals((Object)"f", (Object)namedSqlQuery.getParameter(6).getName());
        Assert.assertEquals((Object)"SELECT a, b, c FROM table where a in (?, ?) and b=lower(?) and c = ? and upper(lower(d)) = ? and upper(lower(e)) = upper(lower(?)) and lower(f) = upper(lower(?))", (Object)namedSqlQuery.toSqlQuery());
    }

    @Test
    public void testParseSqlWithQuestionMarks() {
        String sql = "SELECT * FROM table where field = ? and field2 = ?";
        NamedSqlQuery namedSqlQuery = NamedSqlQuery.parse((CharSequence)sql);
        Assert.assertEquals((long)2L, (long)namedSqlQuery.getParametersSize());
        Assert.assertEquals((Object)"field", (Object)namedSqlQuery.getParameter(0).getName());
        Assert.assertEquals((Object)"field2", (Object)namedSqlQuery.getParameter(1).getName());
        Assert.assertEquals((Object)"SELECT * FROM table where field = ? and field2 = ?", (Object)namedSqlQuery.toSqlQuery());
    }

    @Test
    public void testParseSqlWithNamedParam() {
        String sql = "SELECT * FROM table where field = :field and field = :field2";
        NamedSqlQuery namedSqlQuery = NamedSqlQuery.parse((CharSequence)sql);
        Assert.assertEquals((long)2L, (long)namedSqlQuery.getParametersSize());
        Assert.assertEquals((Object)"field", (Object)namedSqlQuery.getParameter(0).getName());
        Assert.assertEquals((Object)"field2", (Object)namedSqlQuery.getParameter(1).getName());
        Assert.assertEquals((Object)"SELECT * FROM table where field = ? and field = ?", (Object)namedSqlQuery.toSqlQuery());
    }

    @Test
    public void testParseSqlWithOnlyNamedParams() {
        String sql = ":field2";
        NamedSqlQuery namedSqlQuery = NamedSqlQuery.parse((CharSequence)sql);
        Assert.assertEquals((long)1L, (long)namedSqlQuery.getParametersSize());
        Assert.assertEquals((Object)"field2", (Object)namedSqlQuery.getParameter(0).getName());
        Assert.assertEquals((Object)"?", (Object)namedSqlQuery.toSqlQuery());
    }

    @Test
    public void testParseSqlWithNoParams() {
        String sql = "select 1 from dual";
        NamedSqlQuery namedSqlQuery = NamedSqlQuery.parse((CharSequence)sql);
        Assert.assertEquals((long)0L, (long)namedSqlQuery.getParametersSize());
        Assert.assertEquals((Object)"select 1 from dual", (Object)namedSqlQuery.toSqlQuery());
    }
}

