/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test.samples;

import java.sql.PreparedStatement;
import org.junit.Assert;
import org.junit.Test;
import org.simpleflatmapper.jdbc.JdbcColumnKey;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.PreparedStatementMapperBuilder;
import org.simpleflatmapper.jdbc.property.IndexedSetterFactoryProperty;
import org.simpleflatmapper.jdbc.property.IndexedSetterProperty;
import org.simpleflatmapper.map.MapperBuildingException;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.map.property.SetterFactoryProperty;
import org.simpleflatmapper.map.property.SetterProperty;
import org.simpleflatmapper.reflect.IndexedSetter;
import org.simpleflatmapper.reflect.IndexedSetterFactory;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.SetterFactory;

public class CtfmSetterNotFoundTest {
    @Test
    public void jdbcMapperExtrapolateGetterFromConstructor() {
        ((PreparedStatementMapperBuilder)JdbcMapperFactory.newInstance().buildFrom(Foo.class).addColumn("bar")).mapper();
        ((PreparedStatementMapperBuilder)JdbcMapperFactory.newInstance().buildFrom(Crux.class).addColumn("foo")).mapper();
    }

    @Test
    public void jdbcMapperExtrapolateFailToFindSetter() {
        try {
            ((PreparedStatementMapperBuilder)JdbcMapperFactory.newInstance().buildFrom(Foo2.class).addColumn("bar")).mapper();
            Assert.fail();
        }
        catch (MapperBuildingException mapperBuildingException) {
            // empty catch block
        }
    }

    @Test
    public void jdbcMapperExtrapolateOverrideSetter() {
        ((PreparedStatementMapperBuilder)((JdbcMapperFactory)JdbcMapperFactory.newInstance().addColumnProperty("bar", new Object[]{new SetterProperty((Setter)new Setter<PreparedStatement, Bar2Prop>(){

            public void set(PreparedStatement target, Bar2Prop value) throws Exception {
                target.setString(3, value.getVal());
                target.setInt(4, value.getI());
            }
        })})).buildFrom(Foo2.class).addColumn("bar")).mapper();
    }

    @Test
    public void jdbcMapperExtrapolateOverrideSetterFactory() {
        ((PreparedStatementMapperBuilder)((JdbcMapperFactory)JdbcMapperFactory.newInstance().addColumnProperty("bar", new Object[]{new SetterFactoryProperty(new SetterFactory<PreparedStatement, PropertyMapping<?, ?, JdbcColumnKey>>(){

            public <P> Setter<PreparedStatement, P> getSetter(final PropertyMapping<?, ?, JdbcColumnKey> arg) {
                return new Setter<PreparedStatement, Bar2Prop>(){

                    public void set(PreparedStatement target, Bar2Prop value) throws Exception {
                        target.setString(((JdbcColumnKey)arg.getColumnKey()).getIndex(), value.getVal());
                        target.setInt(((JdbcColumnKey)arg.getColumnKey()).getIndex() + 1, value.getI());
                    }
                };
            }
        })})).buildFrom(Foo2.class).addColumn("bar")).mapper();
    }

    @Test
    public void jdbcMapperExtrapolateOverrideIndexedSetter() {
        ((PreparedStatementMapperBuilder)((JdbcMapperFactory)JdbcMapperFactory.newInstance().addColumnProperty("bar", new Object[]{new IndexedSetterProperty((IndexedSetter)new IndexedSetter<PreparedStatement, Bar2Prop>(){

            public void set(PreparedStatement target, Bar2Prop value, int index) throws Exception {
                target.setString(index, value.getVal());
                target.setInt(index + 1, value.getI());
            }
        })})).buildFrom(Foo2.class).addColumn("bar")).mapper();
    }

    @Test
    public void jdbcMapperExtrapolateOverrideIndexedSetterFactory() {
        ((PreparedStatementMapperBuilder)((JdbcMapperFactory)JdbcMapperFactory.newInstance().addColumnProperty("bar", new Object[]{new IndexedSetterFactoryProperty(new IndexedSetterFactory<PreparedStatement, PropertyMapping<?, ?, JdbcColumnKey>>(){

            public <P> IndexedSetter<PreparedStatement, P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey> arg, Object ... properties) {
                return new IndexedSetter<PreparedStatement, Bar2Prop>(){

                    public void set(PreparedStatement target, Bar2Prop value, int index) throws Exception {
                        target.setString(index, value.getVal());
                        target.setInt(index + 1, value.getI());
                    }
                };
            }
        })})).buildFrom(Foo2.class).addColumn("bar")).mapper();
    }

    public static class Bar2Prop {
        private final String val;
        private final int i;

        public Bar2Prop(String val, int i) {
            this.val = val;
            this.i = i;
        }

        public int getI() {
            return this.i;
        }

        public String getVal() {
            return this.val;
        }

        public String toString() {
            return "toString";
        }
    }

    public static class Foo2 {
        private final Bar2Prop bar;

        public Foo2(Bar2Prop bar) {
            this.bar = bar;
        }

        public Bar2Prop getBar() {
            return this.bar;
        }
    }

    public static class Crux {
        private final Foo foo;

        public Crux(Foo foo) {
            this.foo = foo;
        }

        public Foo getFoo() {
            return this.foo;
        }
    }

    public static class BarOneProp {
        private final String val;

        public BarOneProp(String val) {
            this.val = val;
        }

        public String getVal() {
            return this.val;
        }
    }

    public static class Foo {
        private final BarOneProp bar;

        public Foo(BarOneProp bar) {
            this.bar = bar;
        }

        public BarOneProp getBar() {
            return this.bar;
        }
    }
}

