/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test.samples;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.simpleflatmapper.jdbc.DynamicJdbcMapper;
import org.simpleflatmapper.jdbc.JdbcColumnKey;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.ListCollector;

public class JoinSample {
    public void selectUsers() {
        DynamicJdbcMapper jdbcMapper = ((JdbcMapperFactory)JdbcMapperFactory.newInstance().addKeys(new String[]{"id", "roles_id", "phones_id"})).newMapper(Object.class);
    }

    @Test
    public void stackOverFlowJoin() throws SQLException {
        JdbcMapper mapper = (JdbcMapper)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperBuilder)((JdbcMapperFactory)JdbcMapperFactory.newInstance().addKeys(new String[]{"player"})).newBuilder(Location.class).addMapping((FieldKey)new JdbcColumnKey("name", 1, 12), new Object[0])).addMapping((FieldKey)new JdbcColumnKey("player", 2, 12), new Object[0])).addMapping((FieldKey)new JdbcColumnKey("invited_players_player", 3, 12), new Object[0])).mapper();
        UUID[] players = new UUID[]{UUID.randomUUID(), UUID.randomUUID()};
        UUID[] invitedPlayers = new UUID[]{UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID()};
        String[] name = new String[]{"location1", "location2"};
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.next()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)rs.getString(1)).thenReturn((Object)name[0], (Object[])new String[]{name[1]});
        Mockito.when((Object)rs.getString(2)).thenReturn((Object)players[0].toString(), (Object[])new String[]{players[1].toString()});
        Mockito.when((Object)rs.getObject(2)).thenReturn((Object)players[0].toString(), new Object[]{players[0].toString(), players[0].toString(), players[0].toString(), players[1].toString(), players[1].toString()});
        Mockito.when((Object)rs.getString(3)).thenReturn((Object)invitedPlayers[0].toString(), (Object[])new String[]{invitedPlayers[1].toString(), invitedPlayers[2].toString()});
        List list = ((ListCollector)mapper.forEach(rs, (CheckedConsumer)new ListCollector())).getList();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"location1", (Object)((Location)list.get(0)).getName());
        Assert.assertEquals((Object)players[0], (Object)((Location)list.get(0)).getPlayer());
        Assert.assertEquals(Arrays.asList(invitedPlayers[0], invitedPlayers[1]), ((Location)list.get(0)).getInvitedPlayers());
        Assert.assertEquals((Object)"location2", (Object)((Location)list.get(1)).getName());
        Assert.assertEquals((Object)players[1], (Object)((Location)list.get(1)).getPlayer());
        Assert.assertEquals(Arrays.asList(invitedPlayers[2]), ((Location)list.get(1)).getInvitedPlayers());
    }

    public static class Location {
        private final String name;
        private final UUID player;
        private final List<UUID> invitedPlayers;

        public Location(String name, UUID player, List<UUID> invitedPlayers) {
            this.name = name;
            this.player = player;
            this.invitedPlayers = invitedPlayers;
        }

        public String getName() {
            return this.name;
        }

        public UUID getPlayer() {
            return this.player;
        }

        public List<UUID> getInvitedPlayers() {
            return this.invitedPlayers;
        }
    }
}

