/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.test.samples;

import java.sql.PreparedStatement;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.simpleflatmapper.converter.Context;
import org.simpleflatmapper.converter.ContextFactoryBuilder;
import org.simpleflatmapper.converter.EmptyContext;
import org.simpleflatmapper.converter.EmptyContextFactoryBuilder;
import org.simpleflatmapper.jdbc.JdbcColumnKey;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.MultiIndexFieldMapper;
import org.simpleflatmapper.jdbc.PreparedStatementMapperBuilder;
import org.simpleflatmapper.jdbc.property.IndexedSetterFactoryProperty;
import org.simpleflatmapper.jdbc.property.IndexedSetterProperty;
import org.simpleflatmapper.map.MapperBuildingException;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.reflect.IndexedSetter;
import org.simpleflatmapper.reflect.IndexedSetterFactory;

public class PsSetterNotFoundTest {
    @Test
    public void jdbcMapperExtrapolateGetterFromConstructor() throws Exception {
        MultiIndexFieldMapper[] fieldMappers = ((PreparedStatementMapperBuilder)JdbcMapperFactory.newInstance().buildFrom(Foo.class).addColumn("bar")).buildIndexFieldMappers((ContextFactoryBuilder)EmptyContextFactoryBuilder.INSTANCE);
        Assert.assertEquals((long)1L, (long)fieldMappers.length);
        PreparedStatement ps = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        fieldMappers[0].map(ps, (Object)new Foo(new BarOneProp("val")), 0, (Context)EmptyContext.INSTANCE);
        ((PreparedStatement)Mockito.verify((Object)ps)).setString(1, "val");
        ((PreparedStatementMapperBuilder)JdbcMapperFactory.newInstance().buildFrom(Crux.class).addColumn("foo")).buildIndexFieldMappers((ContextFactoryBuilder)EmptyContextFactoryBuilder.INSTANCE);
    }

    @Test
    public void jdbcMapperExtrapolateFailToFindSetter() {
        try {
            MultiIndexFieldMapper[] indexFieldMappers = ((PreparedStatementMapperBuilder)JdbcMapperFactory.newInstance().buildFrom(Foo2.class).addColumn("bar")).buildIndexFieldMappers((ContextFactoryBuilder)EmptyContextFactoryBuilder.INSTANCE);
            Assert.fail();
        }
        catch (MapperBuildingException mapperBuildingException) {
            // empty catch block
        }
    }

    @Test
    public void jdbcMapperExtrapolateOverrideSetter() {
        ((PreparedStatementMapperBuilder)((JdbcMapperFactory)JdbcMapperFactory.newInstance().addColumnProperty("bar", new Object[]{new IndexedSetterProperty((IndexedSetter)new IndexedSetter<PreparedStatement, Bar2Prop>(){

            public void set(PreparedStatement target, Bar2Prop value, int index) throws Exception {
                target.setString(index, value.getVal());
                target.setInt(index + 1, value.getI());
            }
        })})).buildFrom(Foo2.class).addColumn("bar")).buildIndexFieldMappers((ContextFactoryBuilder)EmptyContextFactoryBuilder.INSTANCE);
    }

    @Test
    public void jdbcMapperExtrapolateOverrideSetterFactory() {
        ((PreparedStatementMapperBuilder)((JdbcMapperFactory)JdbcMapperFactory.newInstance().addColumnProperty("bar", new Object[]{new IndexedSetterFactoryProperty(new IndexedSetterFactory<PreparedStatement, PropertyMapping<?, ?, JdbcColumnKey>>(){

            public <P> IndexedSetter<PreparedStatement, P> getIndexedSetter(PropertyMapping<?, ?, JdbcColumnKey> arg, Object ... properties) {
                return new IndexedSetter<PreparedStatement, Bar2Prop>(){

                    public void set(PreparedStatement target, Bar2Prop value, int index) throws Exception {
                        target.setString(index, value.getVal());
                        target.setInt(index + 1, value.getI());
                    }
                };
            }
        })})).buildFrom(Foo2.class).addColumn("bar")).buildIndexFieldMappers((ContextFactoryBuilder)EmptyContextFactoryBuilder.INSTANCE);
    }

    public static class Bar2Prop {
        private final String val;
        private final int i;

        public Bar2Prop(String val, int i) {
            this.val = val;
            this.i = i;
        }

        public int getI() {
            return this.i;
        }

        public String getVal() {
            return this.val;
        }

        public String toString() {
            return "toString";
        }
    }

    public static class Foo2 {
        private final Bar2Prop bar;

        public Foo2(Bar2Prop bar) {
            this.bar = bar;
        }

        public Bar2Prop getBar() {
            return this.bar;
        }
    }

    public static class Crux {
        private final Foo foo;

        public Crux(Foo foo) {
            this.foo = foo;
        }

        public Foo getFoo() {
            return this.foo;
        }
    }

    public static class BarOneProp {
        private final String val;

        public BarOneProp(String val) {
            this.val = val;
        }

        public String getVal() {
            return this.val;
        }
    }

    public static class Foo {
        private final BarOneProp bar;

        public Foo(BarOneProp bar) {
            this.bar = bar;
        }

        public BarOneProp getBar() {
            return this.bar;
        }
    }
}

