/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.simpleflatmapper.jdbc.JdbcColumnKey;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMappingContextFactoryBuilder;
import org.simpleflatmapper.jdbc.JdbcSourceFieldMapper;
import org.simpleflatmapper.jdbc.ResultSetEnumerable;
import org.simpleflatmapper.jdbc.ResultSetGetterFactory;
import org.simpleflatmapper.jdbc.impl.JdbcKeySourceGetter;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.map.SetRowMapper;
import org.simpleflatmapper.map.SourceFieldMapper;
import org.simpleflatmapper.map.context.KeySourceGetter;
import org.simpleflatmapper.map.context.MappingContextFactory;
import org.simpleflatmapper.map.context.MappingContextFactoryBuilder;
import org.simpleflatmapper.map.getter.ContextualGetterFactory;
import org.simpleflatmapper.map.getter.ContextualGetterFactoryAdapter;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.DefaultSetRowMapperBuilder;
import org.simpleflatmapper.map.mapper.KeyFactory;
import org.simpleflatmapper.map.mapper.MapperBuilder;
import org.simpleflatmapper.map.mapper.MapperSource;
import org.simpleflatmapper.map.mapper.MapperSourceImpl;
import org.simpleflatmapper.map.mapper.SetRowMapperBuilder;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.getter.GetterFactory;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.util.BiFunction;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.Enumerable;
import org.simpleflatmapper.util.Function;
import org.simpleflatmapper.util.TypeReference;
import org.simpleflatmapper.util.UnaryFactory;

public final class JdbcMapperBuilder<T>
extends MapperBuilder<ResultSet, ResultSet, T, JdbcColumnKey, SQLException, SetRowMapper<ResultSet, ResultSet, T, SQLException>, JdbcMapper<T>, JdbcMapperBuilder<T>> {
    private static final MapperSourceImpl<ResultSet, JdbcColumnKey> FIELD_MAPPER_SOURCE = new MapperSourceImpl(ResultSet.class, (ContextualGetterFactory)new ContextualGetterFactoryAdapter((GetterFactory)ResultSetGetterFactory.INSTANCE));
    private static final KeyFactory<JdbcColumnKey> KEY_FACTORY = new KeyFactory<JdbcColumnKey>(){

        public JdbcColumnKey newKey(String name, int i) {
            return new JdbcColumnKey(name, i);
        }
    };
    public static final Function<Object[], ColumnDefinition<JdbcColumnKey, ?>> COLUMN_DEFINITION_FACTORY = FieldMapperColumnDefinition.factory();
    private final MappingContextFactoryBuilder<ResultSet, JdbcColumnKey> mappingContextFactoryBuilder;

    public JdbcMapperBuilder(TypeReference<T> target) {
        this(target.getType());
    }

    public JdbcMapperBuilder(Type target) {
        this(target, ReflectionService.newInstance());
    }

    public JdbcMapperBuilder(Type target, ReflectionService reflectService) {
        this((ClassMeta<T>)reflectService.getClassMeta(target), (MapperConfig<JdbcColumnKey, ResultSet>)MapperConfig.fieldMapperConfig(), ResultSetGetterFactory.INSTANCE, (MappingContextFactoryBuilder<ResultSet, JdbcColumnKey>)new JdbcMappingContextFactoryBuilder(!MapperConfig.fieldMapperConfig().unorderedJoin()));
    }

    public JdbcMapperBuilder(ClassMeta<T> classMeta, MapperConfig<JdbcColumnKey, ResultSet> mapperConfig, GetterFactory<ResultSet, JdbcColumnKey> getterFactory, MappingContextFactoryBuilder<ResultSet, JdbcColumnKey> parentBuilder) {
        this(classMeta, mapperConfig, (ContextualGetterFactory<? super ResultSet, JdbcColumnKey>)new ContextualGetterFactoryAdapter(getterFactory), parentBuilder);
    }

    public JdbcMapperBuilder(ClassMeta<T> classMeta, MapperConfig<JdbcColumnKey, ResultSet> mapperConfig, ContextualGetterFactory<? super ResultSet, JdbcColumnKey> getterFactory, final MappingContextFactoryBuilder<ResultSet, JdbcColumnKey> parentBuilder) {
        super(KEY_FACTORY, (SetRowMapperBuilder)new DefaultSetRowMapperBuilder(classMeta, parentBuilder, mapperConfig, (MapperSource)FIELD_MAPPER_SOURCE.getterFactory(getterFactory), KEY_FACTORY, (UnaryFactory)new ResultSetEnumerableFactory(), (KeySourceGetter)JdbcKeySourceGetter.INSTANCE), new BiFunction<SetRowMapper<ResultSet, ResultSet, T, SQLException>, List<JdbcColumnKey>, JdbcMapper<T>>(){

            public JdbcMapper<T> apply(SetRowMapper<ResultSet, ResultSet, T, SQLException> setRowMapper, List<JdbcColumnKey> keys) {
                return new JdbcMapperImpl(setRowMapper, parentBuilder.build());
            }
        }, COLUMN_DEFINITION_FACTORY, 1);
        this.mappingContextFactoryBuilder = parentBuilder;
    }

    public JdbcMapperBuilder<T> addMapping(String column, int index, int sqlType) {
        this.addMapping(column, index, sqlType, (FieldMapperColumnDefinition<JdbcColumnKey>)FieldMapperColumnDefinition.identity());
        return this;
    }

    public JdbcMapperBuilder<T> addMapping(String column, int index, int sqlType, FieldMapperColumnDefinition<JdbcColumnKey> columnDefinition) {
        return (JdbcMapperBuilder)this.addMapping(new JdbcColumnKey(column, index, sqlType), (ColumnDefinition)columnDefinition);
    }

    public JdbcMapperBuilder<T> addMapping(String column, int index, int sqlType, Object ... properties) {
        return (JdbcMapperBuilder)this.addMapping(new JdbcColumnKey(column, index, sqlType), properties);
    }

    public JdbcMapperBuilder<T> addMapping(ResultSetMetaData metaData) throws SQLException {
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            this.addMapping(metaData.getColumnLabel(i), i, metaData.getColumnType(i));
        }
        return this;
    }

    public JdbcSourceFieldMapper<T> newSourceFieldMapper() {
        return new JdbcSourceFieldMapperImpl(super.sourceFieldMapper(), this.mappingContextFactoryBuilder.build());
    }

    private static class ResultSetEnumerableFactory
    implements UnaryFactory<ResultSet, Enumerable<ResultSet>> {
        private ResultSetEnumerableFactory() {
        }

        public Enumerable<ResultSet> newInstance(ResultSet rows) {
            return new ResultSetEnumerable(rows);
        }
    }

    private static class JdbcMapperImpl<T>
    implements JdbcMapper<T> {
        private final SetRowMapper<ResultSet, ResultSet, T, SQLException> setRowMapper;
        private final MappingContextFactory<? super ResultSet> mappingContextFactory;

        private JdbcMapperImpl(SetRowMapper<ResultSet, ResultSet, T, SQLException> setRowMapper, MappingContextFactory<? super ResultSet> mappingContextFactory) {
            this.setRowMapper = setRowMapper;
            this.mappingContextFactory = mappingContextFactory;
        }

        @Override
        public T map(ResultSet source) throws MappingException {
            return (T)this.setRowMapper.map((Object)source);
        }

        public T map(ResultSet source, MappingContext<? super ResultSet> context) throws MappingException {
            return (T)this.setRowMapper.map((Object)source, context);
        }

        @Override
        public <H extends CheckedConsumer<? super T>> H forEach(ResultSet source, H handler) throws SQLException, MappingException {
            return (H)this.setRowMapper.forEach((Object)source, handler);
        }

        @Override
        public Iterator<T> iterator(ResultSet source) throws SQLException, MappingException {
            return this.setRowMapper.iterator((Object)source);
        }

        public Enumerable<T> enumerate(ResultSet source) throws SQLException, MappingException {
            return this.setRowMapper.enumerate((Object)source);
        }

        @Override
        public Stream<T> stream(ResultSet source) throws SQLException, MappingException {
            return this.setRowMapper.stream((Object)source);
        }

        public MappingContext<? super ResultSet> newMappingContext(ResultSet resultSet) throws SQLException {
            return this.mappingContextFactory.newContext();
        }

        public String toString() {
            return "JdbcMapperImpl{setRowMapper=" + this.setRowMapper + ", mappingContextFactory=" + this.mappingContextFactory + '}';
        }
    }

    private static class JdbcSourceFieldMapperImpl<T>
    implements JdbcSourceFieldMapper<T> {
        private final SourceFieldMapper<ResultSet, T> sourceFieldMapper;
        private final MappingContextFactory<? super ResultSet> mappingContextFactory;

        private JdbcSourceFieldMapperImpl(SourceFieldMapper<ResultSet, T> sourceFieldMapper, MappingContextFactory<? super ResultSet> mappingContextFactory) {
            this.sourceFieldMapper = sourceFieldMapper;
            this.mappingContextFactory = mappingContextFactory;
        }

        public void mapTo(ResultSet source, T target, MappingContext<? super ResultSet> context) throws Exception {
            this.sourceFieldMapper.mapTo((Object)source, target, context);
        }

        public T map(ResultSet source, MappingContext<? super ResultSet> context) throws MappingException {
            return (T)this.sourceFieldMapper.map((Object)source, context);
        }

        public T map(ResultSet source) throws MappingException {
            return (T)this.sourceFieldMapper.map((Object)source, this.mappingContextFactory.newContext());
        }

        public MappingContext<? super ResultSet> newMappingContext(ResultSet resultSet) throws SQLException {
            return this.mappingContextFactory.newContext();
        }
    }
}

