/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.simpleflatmapper.jdbc.JdbcColumnKey;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.SqlTypeColumnProperty;
import org.simpleflatmapper.jdbc.impl.ColumnMeta;
import org.simpleflatmapper.jdbc.impl.DatabaseMeta;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.ColumnDefinitionProvider;
import org.simpleflatmapper.map.property.AutoGeneratedProperty;
import org.simpleflatmapper.map.property.IgnoreAutoGeneratedProperty;
import org.simpleflatmapper.map.property.KeyProperty;

public class CrudMeta {
    private final DatabaseMeta databaseMeta;
    private final String table;
    private final ColumnMeta[] columnMetas;

    public CrudMeta(DatabaseMeta databaseMeta, String schema, String table, ColumnMeta[] columnMetas) {
        this(databaseMeta, CrudMeta.toProtectedFullyQualifiedName(schema, table, databaseMeta), columnMetas);
    }

    public CrudMeta(DatabaseMeta databaseMeta, String table, ColumnMeta[] columnMetas) {
        this.databaseMeta = databaseMeta;
        this.table = table;
        this.columnMetas = columnMetas;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public String getTable() {
        return this.table;
    }

    public ColumnMeta[] getColumnMetas() {
        return this.columnMetas;
    }

    public boolean hasGeneratedKeys() {
        for (ColumnMeta cm : this.columnMetas) {
            if (!cm.isKey() || !cm.isGenerated()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CrudMeta of(Connection connection, String table, ColumnDefinitionProvider<JdbcColumnKey> columnDefinitionProvider) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        DatabaseMeta databaseMeta = new DatabaseMeta(metaData.getDatabaseProductName(), metaData.getDatabaseMajorVersion(), metaData.getDatabaseMinorVersion());
        try (Statement statement = connection.createStatement();){
            CrudMeta crudMeta;
            ResultSet resultSet = statement.executeQuery("SELECT * FROM " + table + " WHERE 1 = 2");
            try {
                crudMeta = CrudMeta.getCrudMeta(connection, table, columnDefinitionProvider, resultSet, databaseMeta);
            }
            catch (Throwable throwable) {
                try {
                    resultSet.close();
                    throw throwable;
                }
                catch (SQLException e) {
                    try (ResultSet resultSet2 = statement.executeQuery(CrudMeta.selectProtected(table, databaseMeta));){
                        CrudMeta crudMeta2 = CrudMeta.getCrudMeta(connection, CrudMeta.protectField(table, databaseMeta), columnDefinitionProvider, resultSet2, databaseMeta);
                        return crudMeta2;
                    }
                }
            }
            resultSet.close();
            return crudMeta;
        }
    }

    private static String protectField(String table, DatabaseMeta databaseMeta) {
        StringBuilder sb = new StringBuilder();
        CrudMeta.appendProtectedField(sb, table, databaseMeta);
        return sb.toString();
    }

    private static String selectProtected(String table, DatabaseMeta dm) {
        StringBuilder sb = new StringBuilder("SELECT * FROM ");
        CrudMeta.appendProtectedField(sb, table, dm);
        sb.append(" WHERE 1 = 2");
        return sb.toString();
    }

    private static CrudMeta getCrudMeta(Connection connection, String table, ColumnDefinitionProvider<JdbcColumnKey> columnDefinitionProvider, ResultSet resultSet, DatabaseMeta databaseMeta) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        ColumnMeta[] columnMetas = new ColumnMeta[resultSetMetaData.getColumnCount()];
        List<String> primaryKeys = CrudMeta.getPrimaryKeys(connection, resultSetMetaData, columnDefinitionProvider);
        int length = columnMetas.length;
        for (int i = 0; i < length; ++i) {
            String columnName = resultSetMetaData.getColumnName(i + 1);
            ColumnDefinition columnDefinition = columnDefinitionProvider.getColumnDefinition((FieldKey)JdbcColumnKey.of(resultSetMetaData, i + 1));
            AutoGeneratedProperty autoGeneratedProperty = (AutoGeneratedProperty)columnDefinition.lookFor(AutoGeneratedProperty.class);
            if (autoGeneratedProperty == null && resultSetMetaData.isAutoIncrement(i + 1) && !columnDefinition.has(IgnoreAutoGeneratedProperty.class)) {
                autoGeneratedProperty = AutoGeneratedProperty.DEFAULT;
            }
            columnMetas[i] = new ColumnMeta(columnName, resultSetMetaData.getColumnType(i + 1), primaryKeys.contains(columnName), autoGeneratedProperty);
        }
        return new CrudMeta(databaseMeta, table, columnMetas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getPrimaryKeys(Connection connection, ResultSetMetaData resultSetMetaData, ColumnDefinitionProvider<JdbcColumnKey> columnDefinitionProvider) throws SQLException {
        ArrayList<String> primaryKeys = new ArrayList<String>();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            JdbcColumnKey key = JdbcColumnKey.of(resultSetMetaData, i);
            if (!columnDefinitionProvider.getColumnDefinition((FieldKey)key).has(KeyProperty.class)) continue;
            primaryKeys.add(key.getName());
        }
        if (!primaryKeys.isEmpty()) {
            return primaryKeys;
        }
        String catalogName = resultSetMetaData.getCatalogName(1);
        String schemaName = resultSetMetaData.getSchemaName(1);
        String tableName = resultSetMetaData.getTableName(1);
        try (ResultSet set = connection.getMetaData().getPrimaryKeys(catalogName, schemaName, tableName);){
            while (set.next()) {
                primaryKeys.add(set.getString("COLUMN_NAME"));
            }
        }
        catch (SQLSyntaxErrorException sQLSyntaxErrorException) {
            // empty catch block
        }
        return primaryKeys;
    }

    public void addColumnProperties(JdbcMapperFactory mapperFactory) {
        for (ColumnMeta columnMeta : this.columnMetas) {
            mapperFactory.addColumnProperty(columnMeta.getColumn(), new Object[]{SqlTypeColumnProperty.of(columnMeta.getSqlType())});
            if (!columnMeta.isKey()) continue;
            mapperFactory.addColumnProperty(columnMeta.getColumn(), new Object[]{KeyProperty.DEFAULT});
        }
    }

    public boolean hasNoUpdatableFields() {
        for (ColumnMeta cm : this.getColumnMetas()) {
            if (cm.isKey()) continue;
            return false;
        }
        return true;
    }

    public StringBuilder appendProtectedField(StringBuilder sb, String value) {
        return CrudMeta.appendProtectedField(sb, value, this.databaseMeta);
    }

    public void appendTableName(StringBuilder sb) {
        sb.append(this.table);
    }

    public static StringBuilder appendProtectedField(StringBuilder sb, String value, DatabaseMeta databaseMeta) {
        char c = '\"';
        if (databaseMeta.isMysql()) {
            c = '`';
        }
        return sb.append(c).append(value).append(c);
    }

    public static String toProtectedFullyQualifiedName(String schema, String table, DatabaseMeta databaseMeta) {
        StringBuilder sb = new StringBuilder();
        if (schema != null && schema.length() > 0) {
            CrudMeta.appendProtectedField(sb, schema, databaseMeta);
            sb.append(".");
        }
        CrudMeta.appendProtectedField(sb, table, databaseMeta);
        return sb.toString();
    }
}

