/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.poi.impl;

import java.util.Iterator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.sfm.map.Mapper;
import org.sfm.map.MappingContext;
import org.sfm.map.MappingException;
import org.sfm.map.RowHandlerErrorHandler;
import org.sfm.map.context.MappingContextFactory;
import org.sfm.map.mapper.JoinMapperEnumarable;
import org.sfm.poi.RowMapper;
import org.sfm.poi.impl.RowEnumarable;
import org.sfm.utils.Enumarable;
import org.sfm.utils.EnumarableIterator;
import org.sfm.utils.RowHandler;

public class JoinSheetMapper<T>
implements RowMapper<T> {
    private final Mapper<Row, T> mapper;
    private final int startRow = 0;
    private final RowHandlerErrorHandler rowHandlerErrorHandler;
    private final MappingContextFactory<? super Row> mappingContextFactory;

    public JoinSheetMapper(Mapper<Row, T> mapper, RowHandlerErrorHandler rowHandlerErrorHandler, MappingContextFactory<? super Row> mappingContextFactory) {
        this.mapper = mapper;
        this.rowHandlerErrorHandler = rowHandlerErrorHandler;
        this.mappingContextFactory = mappingContextFactory;
    }

    @Override
    public Iterator<T> iterator(Sheet sheet) {
        return this.iterator(0, sheet);
    }

    @Override
    public Iterator<T> iterator(int startRow, Sheet sheet) {
        return new EnumarableIterator(this.enumerable(startRow, sheet, this.newMappingContext()));
    }

    private Enumarable<T> enumerable(int startRow, Sheet sheet, MappingContext<? super Row> mappingContext) {
        return new JoinMapperEnumarable(this.mapper, mappingContext, (Enumarable)new RowEnumarable(startRow, sheet));
    }

    @Override
    public <RH extends RowHandler<T>> RH forEach(Sheet sheet, RH rowHandler) {
        return this.forEach(0, sheet, rowHandler);
    }

    @Override
    public <RH extends RowHandler<T>> RH forEach(int startRow, Sheet sheet, RH rowHandler) {
        MappingContext<Row> mappingContext = this.newMappingContext();
        Enumarable<T> enumarable = this.enumerable(startRow, sheet, mappingContext);
        while (enumarable.next()) {
            try {
                rowHandler.handle(enumarable.currentValue());
            }
            catch (Exception e) {
                this.rowHandlerErrorHandler.handlerError((Throwable)e, enumarable.currentValue());
            }
        }
        return rowHandler;
    }

    public T map(Row source) throws MappingException {
        return (T)this.mapper.map((Object)source);
    }

    public T map(Row source, MappingContext<? super Row> context) throws MappingException {
        return (T)this.mapper.map((Object)source, context);
    }

    public void mapTo(Row source, T target, MappingContext<? super Row> context) throws Exception {
        this.mapper.mapTo((Object)source, target, context);
    }

    private MappingContext<? super Row> newMappingContext() {
        return this.mappingContextFactory.newContext();
    }
}

