/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.poi.impl;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.sfm.reflect.Getter;

public class PoiStringGetter
implements Getter<Row, String> {
    private final int index;
    private final DataFormatter dataFormatter = new DataFormatter();
    private final Lock lock = new ReentrantLock();

    public PoiStringGetter(int index) {
        this.index = index;
    }

    public String get(Row target) throws Exception {
        Cell cell = target.getCell(this.index);
        if (cell != null) {
            switch (cell.getCellType()) {
                case 0: 
                case 4: {
                    return this.formatCell(cell);
                }
            }
            return cell.getStringCellValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatCell(Cell cell) {
        this.lock.lock();
        try {
            String string = this.dataFormatter.formatCellValue(cell);
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }
}

