/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.poi.impl;

import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Row;
import org.sfm.csv.CsvColumnKey;
import org.sfm.map.FieldKey;
import org.sfm.map.GetterFactory;
import org.sfm.map.getter.joda.JodaTimeGetterFactory;
import org.sfm.map.mapper.ColumnDefinition;
import org.sfm.poi.impl.PoiBooleanGetter;
import org.sfm.poi.impl.PoiByteGetter;
import org.sfm.poi.impl.PoiCharacterGetter;
import org.sfm.poi.impl.PoiDateGetter;
import org.sfm.poi.impl.PoiDoubleGetter;
import org.sfm.poi.impl.PoiEnumGetter;
import org.sfm.poi.impl.PoiFloatGetter;
import org.sfm.poi.impl.PoiIntegerGetter;
import org.sfm.poi.impl.PoiLongGetter;
import org.sfm.poi.impl.PoiShortGetter;
import org.sfm.poi.impl.PoiStringGetter;
import org.sfm.reflect.Getter;
import org.sfm.reflect.TypeHelper;

public class RowGetterFactory
implements GetterFactory<Row, CsvColumnKey> {
    private static final Map<Class<?>, GetterFactory<Row, CsvColumnKey>> getterFactories = new HashMap();
    private static final JodaTimeGetterFactory<Row, CsvColumnKey> jodaTimeGetterFactory;

    public <P> Getter<Row, P> newGetter(Type target, CsvColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
        Class targetClass = TypeHelper.toClass((Type)target);
        GetterFactory<Row, CsvColumnKey> rowGetterFactory = getterFactories.get(targetClass);
        if (rowGetterFactory != null) {
            return rowGetterFactory.newGetter(target, (FieldKey)key, columnDefinition);
        }
        if (TypeHelper.isEnum((Type)target)) {
            return new PoiEnumGetter(key.getIndex(), TypeHelper.toClass((Type)target));
        }
        Getter getter = jodaTimeGetterFactory.newGetter(target, (FieldKey)key, columnDefinition);
        if (getter != null) {
            return getter;
        }
        return null;
    }

    static {
        getterFactories.put(String.class, new GetterFactory<Row, CsvColumnKey>(){

            public <P> Getter<Row, P> newGetter(Type target, CsvColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new PoiStringGetter(key.getIndex());
            }
        });
        getterFactories.put(Date.class, new GetterFactory<Row, CsvColumnKey>(){

            public <P> Getter<Row, P> newGetter(Type target, CsvColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new PoiDateGetter(key.getIndex());
            }
        });
        getterFactories.put(Byte.class, new GetterFactory<Row, CsvColumnKey>(){

            public <P> Getter<Row, P> newGetter(Type target, CsvColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new PoiByteGetter(key.getIndex());
            }
        });
        getterFactories.put(Character.class, new GetterFactory<Row, CsvColumnKey>(){

            public <P> Getter<Row, P> newGetter(Type target, CsvColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new PoiCharacterGetter(key.getIndex());
            }
        });
        getterFactories.put(Short.class, new GetterFactory<Row, CsvColumnKey>(){

            public <P> Getter<Row, P> newGetter(Type target, CsvColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new PoiShortGetter(key.getIndex());
            }
        });
        getterFactories.put(Integer.class, new GetterFactory<Row, CsvColumnKey>(){

            public <P> Getter<Row, P> newGetter(Type target, CsvColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new PoiIntegerGetter(key.getIndex());
            }
        });
        getterFactories.put(Long.class, new GetterFactory<Row, CsvColumnKey>(){

            public <P> Getter<Row, P> newGetter(Type target, CsvColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new PoiLongGetter(key.getIndex());
            }
        });
        getterFactories.put(Float.class, new GetterFactory<Row, CsvColumnKey>(){

            public <P> Getter<Row, P> newGetter(Type target, CsvColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new PoiFloatGetter(key.getIndex());
            }
        });
        getterFactories.put(Double.class, new GetterFactory<Row, CsvColumnKey>(){

            public <P> Getter<Row, P> newGetter(Type target, CsvColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new PoiDoubleGetter(key.getIndex());
            }
        });
        getterFactories.put(Boolean.class, new GetterFactory<Row, CsvColumnKey>(){

            public <P> Getter<Row, P> newGetter(Type target, CsvColumnKey key, ColumnDefinition<?, ?> columnDefinition) {
                return new PoiBooleanGetter(key.getIndex());
            }
        });
        getterFactories.put(Byte.TYPE, getterFactories.get(Byte.class));
        getterFactories.put(Character.TYPE, getterFactories.get(Character.class));
        getterFactories.put(Short.TYPE, getterFactories.get(Short.class));
        getterFactories.put(Integer.TYPE, getterFactories.get(Integer.class));
        getterFactories.put(Long.TYPE, getterFactories.get(Long.class));
        getterFactories.put(Float.TYPE, getterFactories.get(Float.class));
        getterFactories.put(Double.TYPE, getterFactories.get(Double.class));
        getterFactories.put(Boolean.TYPE, getterFactories.get(Boolean.class));
        jodaTimeGetterFactory = new JodaTimeGetterFactory(getterFactories.get(Date.class));
    }
}

