/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.instantiator.ExecutableInstantiatorDefinition;
import org.simpleflatmapper.util.TypeHelper;

public class ReflectionInstantiatorDefinitionFactory {
    public static List<InstantiatorDefinition> extractDefinitions(Type target) {
        if (ReflectionInstantiatorDefinitionFactory.areParameterNamePresent(target)) {
            return ReflectionInstantiatorDefinitionFactory.extractDefinitionsWithParamNames(target);
        }
        return ReflectionInstantiatorDefinitionFactory.extractDefinitionsWithoutParamNames(target);
    }

    public static InstantiatorDefinition definition(Method m) {
        Parameter[] parameters = ReflectionInstantiatorDefinitionFactory.getParameters(m, m.getGenericReturnType());
        return new ExecutableInstantiatorDefinition(m, parameters);
    }

    private static List<InstantiatorDefinition> extractDefinitionsWithoutParamNames(Type target) {
        return ReflectionInstantiatorDefinitionFactory.extractDefinitions(target, new ParameterBuilder(){

            @Override
            public Parameter[] getParameters(Method m, Type target) {
                return ReflectionInstantiatorDefinitionFactory.getParameters(m, target);
            }

            @Override
            public Parameter[] getParameters(Constructor<?> c, Type target) {
                return ReflectionInstantiatorDefinitionFactory.getParameters(c, target);
            }
        });
    }

    private static List<InstantiatorDefinition> extractDefinitionsWithParamNames(Type target) {
        return ReflectionInstantiatorDefinitionFactory.extractDefinitions(target, new ParameterBuilder(){

            @Override
            public Parameter[] getParameters(Method m, Type target) {
                throw new IllegalStateException("Only supported on java8");
            }

            @Override
            public Parameter[] getParameters(Constructor<?> c, Type target) {
                throw new IllegalStateException("Only supported on java8");
            }
        });
    }

    private static List<InstantiatorDefinition> extractDefinitions(Type target, ParameterBuilder parameterBuilder) {
        ExecutableInstantiatorDefinition definition;
        Class clazz = TypeHelper.toClass((Type)target);
        ArrayList<InstantiatorDefinition> instantiatorDefinitions = new ArrayList<InstantiatorDefinition>();
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers())) continue;
            definition = new ExecutableInstantiatorDefinition(constructor, parameterBuilder.getParameters(constructor, target));
            instantiatorDefinitions.add(definition);
        }
        for (Executable executable : clazz.getDeclaredMethods()) {
            if (!Modifier.isPublic(((Method)executable).getModifiers()) || !Modifier.isStatic(((Method)executable).getModifiers()) || !clazz.isAssignableFrom(((Method)executable).getReturnType())) continue;
            definition = new ExecutableInstantiatorDefinition(executable, parameterBuilder.getParameters((Method)executable, target));
            instantiatorDefinitions.add(definition);
        }
        return instantiatorDefinitions;
    }

    private static Parameter[] getParameters(Constructor<?> constructor, Type target) {
        return ReflectionInstantiatorDefinitionFactory.buildParameters(target, constructor.getParameterTypes(), constructor.getGenericParameterTypes(), TypeHelper.toClass((Type)target).getTypeParameters());
    }

    private static Parameter[] getParameters(Method method, Type target) {
        return ReflectionInstantiatorDefinitionFactory.buildParameters(target, method.getParameterTypes(), method.getGenericParameterTypes(), TypeHelper.toClass((Type)target).getTypeParameters());
    }

    private static Parameter[] buildParameters(Type target, Class<?>[] parameterTypes, Type[] parameterGenericTypes, TypeVariable<Class<Object>>[] targetClassTypeParameters) {
        Parameter[] parameters = new Parameter[parameterTypes.length];
        for (int i = 0; i < parameters.length; ++i) {
            Class<?> paramType = parameterGenericTypes[i];
            Type resolvedParamType = null;
            if (paramType instanceof TypeVariable) {
                TypeVariable tv = (TypeVariable)((Object)paramType);
                paramType = parameterTypes[i];
                if (target instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)target;
                    int j = 0;
                    for (TypeVariable<Class<Object>> typeParameter : targetClassTypeParameters) {
                        if (typeParameter.getName().equals(tv.getName())) {
                            Type[] actualTypeArguments = pt.getActualTypeArguments();
                            resolvedParamType = actualTypeArguments[j];
                            break;
                        }
                        ++j;
                    }
                }
            }
            if (resolvedParamType == null) {
                resolvedParamType = paramType;
            }
            parameters[i] = new Parameter(i, null, TypeHelper.toClass(paramType), resolvedParamType);
        }
        return parameters;
    }

    public static boolean areParameterNamePresent(Type target) {
        return false;
    }

    static interface ParameterBuilder {
        public Parameter[] getParameters(Method var1, Type var2);

        public Parameter[] getParameters(Constructor<?> var1, Type var2);
    }
}

