/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Type;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.util.Supplier;

public abstract class PropertyMeta<O, P> {
    private final String name;
    private final Type ownerType;
    protected final ReflectionService reflectService;
    private volatile ClassMeta<P> classMeta;

    public PropertyMeta(String name, Type ownerType, ReflectionService reflectService) {
        this.name = name;
        this.ownerType = ownerType;
        this.reflectService = reflectService;
    }

    public abstract Setter<? super O, ? super P> getSetter();

    public abstract Getter<? super O, ? extends P> getGetter();

    public final String getName() {
        return this.name;
    }

    public abstract Type getPropertyType();

    public Type getOwnerType() {
        return this.ownerType;
    }

    public final ClassMeta<P> getPropertyClassMeta() {
        ClassMeta<P> meta = this.classMeta;
        if (meta == null) {
            this.classMeta = meta = this.newPropertyClassMeta();
        }
        return meta;
    }

    protected ClassMeta<P> newPropertyClassMeta() {
        return this.reflectService.getClassMeta(this.getPropertyType());
    }

    public boolean isConstructorProperty() {
        return false;
    }

    public abstract String getPath();

    public boolean isSubProperty() {
        return false;
    }

    public boolean isSelf() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public final ReflectionService getReflectService() {
        return this.reflectService;
    }

    public Supplier<ClassMeta<P>> getPropertyClassMetaSupplier() {
        return new Supplier<ClassMeta<P>>(){

            public ClassMeta<P> get() {
                return PropertyMeta.this.getPropertyClassMeta();
            }
        };
    }

    public Object[] getDefinedProperties() {
        return new Object[0];
    }
}

