/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.clisupport;

import jakarta.activation.DataSource;
import jakarta.mail.internet.MimeMessage;
import java.io.File;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bbottema.javareflection.BeanUtils;
import org.bbottema.javareflection.ClassUtils;
import org.bbottema.javareflection.MethodUtils;
import org.bbottema.javareflection.TypeUtils;
import org.bbottema.javareflection.model.LookupMode;
import org.bbottema.javareflection.model.MethodModifier;
import org.bbottema.javareflection.valueconverter.ValueConversionHelper;
import org.bbottema.javareflection.valueconverter.ValueFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.CalendarMethod;
import org.simplejavamail.api.email.ContentTransferEncoding;
import org.simplejavamail.api.internal.clisupport.model.Cli;
import org.simplejavamail.api.internal.clisupport.model.CliDeclaredOptionSpec;
import org.simplejavamail.api.internal.clisupport.model.CliDeclaredOptionValue;
import org.simplejavamail.api.mailer.config.LoadBalancingStrategy;
import org.simplejavamail.api.mailer.config.TransportStrategy;
import org.simplejavamail.internal.clisupport.CliMethodCompatibilityResult;
import org.simplejavamail.internal.clisupport.therapijavadoc.TherapiJavadocHelper;
import org.simplejavamail.internal.clisupport.valueinterpreters.EmlFilePathToMimeMessageFunction;
import org.simplejavamail.internal.clisupport.valueinterpreters.MsgFilePathToMimeMessageFunction;
import org.simplejavamail.internal.clisupport.valueinterpreters.PemFilePathToX509CertificateFunction;
import org.simplejavamail.internal.clisupport.valueinterpreters.StringToCalendarMethodFunction;
import org.simplejavamail.internal.clisupport.valueinterpreters.StringToContentTransferEncodingFunction;
import org.simplejavamail.internal.clisupport.valueinterpreters.StringToFileFunction;
import org.simplejavamail.internal.clisupport.valueinterpreters.StringToLoadBalancingStrategyFunction;
import org.simplejavamail.internal.clisupport.valueinterpreters.StringToTransportStrategyFunction;
import org.simplejavamail.internal.util.Preconditions;
import org.simplejavamail.internal.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BuilderApiToPicocliCommandsMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuilderApiToPicocliCommandsMapper.class);
    private static final Map<Class<?>, String> TYPE_LABELS = new HashMap<Class<?>, String>(){
        {
            this.put(Boolean.TYPE, "BOOL");
            this.put(Boolean.class, "BOOL");
            this.put(String.class, "TEXT");
            this.put(Object.class, "TEXT");
            this.put(TransportStrategy.class, "NAME");
            this.put(CalendarMethod.class, "RFC-2446 VEVENT METHOD");
            this.put(Integer.TYPE, "NUM");
            this.put(Integer.class, "NUM");
            this.put(MimeMessage.class, "EML FILE");
            this.put(DataSource.class, "FILE");
            this.put(byte[].class, "FILE");
            this.put(InputStream.class, "FILE");
            this.put(File.class, "FILE");
            this.put(X509Certificate.class, "PEM FILE");
            this.put(UUID.class, "UUID");
            this.put(LoadBalancingStrategy.class, "NAME");
            this.put(ContentTransferEncoding.class, "NAME");
            this.put(Date.class, "yyyy-[M]M-[d]d[ HH:mm]");
        }
    };

    private BuilderApiToPicocliCommandsMapper() {
    }

    @NotNull
    static List<CliDeclaredOptionSpec> generateOptionsFromBuilderApi(Class<?>[] relevantBuilderRootApi) {
        TreeSet<CliDeclaredOptionSpec> cliOptions = new TreeSet<CliDeclaredOptionSpec>();
        HashSet processedApiNodes = new HashSet();
        for (Class<?> apiRoot : relevantBuilderRootApi) {
            BuilderApiToPicocliCommandsMapper.generateOptionsFromBuilderApiChain(apiRoot, processedApiNodes, cliOptions);
        }
        return new ArrayList<CliDeclaredOptionSpec>(cliOptions);
    }

    private static void generateOptionsFromBuilderApiChain(Class<?> apiNode, Set<Class<?>> processedApiNodes, Set<CliDeclaredOptionSpec> cliOptionsFoundSoFar) {
        for (Class<?> apiNodeChainClass = apiNode; apiNodeChainClass != null && apiNodeChainClass.getPackage().getName().contains("org.simplejavamail"); apiNodeChainClass = apiNodeChainClass.getSuperclass()) {
            for (Class<?> apiInterface : apiNodeChainClass.getInterfaces()) {
                BuilderApiToPicocliCommandsMapper.generateOptionsFromBuilderApi(apiInterface, processedApiNodes, cliOptionsFoundSoFar);
            }
            BuilderApiToPicocliCommandsMapper.generateOptionsFromBuilderApi(apiNodeChainClass, processedApiNodes, cliOptionsFoundSoFar);
        }
    }

    private static void generateOptionsFromBuilderApi(Class<?> apiNode, Set<Class<?>> processedApiNodes, Set<CliDeclaredOptionSpec> cliOptionsFoundSoFar) {
        if (processedApiNodes.contains(apiNode)) {
            return;
        }
        processedApiNodes.add(apiNode);
        for (Method m : ClassUtils.collectMethods(apiNode, apiNode, EnumSet.of(MethodModifier.PUBLIC))) {
            CliMethodCompatibilityResult cliMethodCompatibilityResult = BuilderApiToPicocliCommandsMapper.methodIsCliCompatible(m);
            if (cliMethodCompatibilityResult.isCompatible()) {
                String optionName = BuilderApiToPicocliCommandsMapper.determineCliOptionName(apiNode, m);
                LOGGER.debug("option {} found for {}.{}({})", new Object[]{optionName, apiNode.getSimpleName(), m.getName(), m.getParameterTypes()});
                for (CliDeclaredOptionSpec knownOption : cliOptionsFoundSoFar) {
                    boolean methodIsActuallyTheSame;
                    if (!knownOption.getName().equals(optionName) || (methodIsActuallyTheSame = knownOption.getSourceMethod().equals(m))) continue;
                    String msg = "@CliOptionNameOverride needed one of the following two methods:%n\t%s%n\t%s%n\t----------";
                    throw new AssertionError((Object)String.format(msg, knownOption.getSourceMethod(), m));
                }
                cliOptionsFoundSoFar.add(new CliDeclaredOptionSpec(optionName, TherapiJavadocHelper.determineCliOptionDescriptions(m), BuilderApiToPicocliCommandsMapper.getArgumentsForCliOption(m), apiNode.getAnnotation(Cli.BuilderApiNode.class).builderApiType(), m));
                Class<?> potentialNestedApiNode = m.getReturnType();
                if (!potentialNestedApiNode.isAnnotationPresent(Cli.BuilderApiNode.class)) continue;
                BuilderApiToPicocliCommandsMapper.generateOptionsFromBuilderApiChain(potentialNestedApiNode, processedApiNodes, cliOptionsFoundSoFar);
                continue;
            }
            LOGGER.debug("Method not CLI compatible ({}): {}.{}({})", new Object[]{cliMethodCompatibilityResult.getReason(), apiNode.getSimpleName(), m.getName(), Arrays.toString(m.getParameterTypes())});
        }
    }

    public static CliMethodCompatibilityResult methodIsCliCompatible(Method m) {
        if (!m.getDeclaringClass().isAnnotationPresent(Cli.BuilderApiNode.class)) {
            return new CliMethodCompatibilityResult(false, "@BuilderApiNode missing on enclosing class");
        }
        if (m.isAnnotationPresent(Cli.ExcludeApi.class)) {
            return new CliMethodCompatibilityResult(false, "Compatibility check failed: @ExcludeApi present");
        }
        if (BeanUtils.isBeanMethod((Method)m, m.getDeclaringClass(), EnumSet.allOf(BeanUtils.Visibility.class), (boolean)true)) {
            return new CliMethodCompatibilityResult(false, "Compatibility check failed: actually a bean method");
        }
        if (MethodUtils.methodHasCollectionParameter((Method)m)) {
            return new CliMethodCompatibilityResult(false, "Compatibility check failed: collection parameter present");
        }
        Object[] stringParameters = new Class[m.getParameterTypes().length];
        Arrays.fill(stringParameters, String.class);
        if (!MethodUtils.isMethodCompatible((Method)m, EnumSet.allOf(LookupMode.class), (Class[])stringParameters)) {
            return new CliMethodCompatibilityResult(false, "Compatibility check failed: parameters not compatible");
        }
        return new CliMethodCompatibilityResult(true);
    }

    @NotNull
    public static List<String> colorizeDescriptions(List<String> descriptions) {
        ArrayList<String> colorizedDescriptions = new ArrayList<String>();
        for (String description : descriptions) {
            colorizedDescriptions.add(BuilderApiToPicocliCommandsMapper.colorizeOptionsInText(description, "cyan"));
        }
        return colorizedDescriptions;
    }

    @NotNull
    public static String colorizeOptionsInText(String text, String ansiStyles) {
        StringUtil.StringFormatter TOKEN_REPLACER = StringUtil.StringFormatter.formatterForPattern((String)("@|" + ansiStyles + " %s|@"));
        String optionRegex = "(?:--(?:help|version)|-(?:h|v)|(?:--?\\w+:\\w+))(?!\\w)";
        return StringUtil.replaceNestedTokens((String)text, (int)0, (String)"@|", (String)"|@", (String)"(?:--(?:help|version)|-(?:h|v)|(?:--?\\w+:\\w+))(?!\\w)", (StringUtil.StringFormatter)TOKEN_REPLACER);
    }

    @NotNull
    public static String determineCliOptionName(Class<?> apiNode, Method m) {
        String methodName = m.isAnnotationPresent(Cli.OptionNameOverride.class) ? m.getAnnotation(Cli.OptionNameOverride.class).value() : m.getName();
        String cliCommandPrefix = apiNode.getAnnotation(Cli.BuilderApiNode.class).builderApiType().getParamPrefix();
        Preconditions.assumeTrue((!cliCommandPrefix.isEmpty() ? 1 : 0) != 0, (String)"Option prefix missing from API class");
        return String.format("--%s:%s", cliCommandPrefix, methodName);
    }

    @NotNull
    public static List<CliDeclaredOptionValue> getArgumentsForCliOption(Method m) {
        Annotation[][] annotations = m.getParameterAnnotations();
        Class<?>[] declaredParameters = m.getParameterTypes();
        List<TherapiJavadocHelper.DocumentedMethodParam> documentedParameters = TherapiJavadocHelper.getParamDescriptions(m);
        ArrayList<CliDeclaredOptionValue> cliParams = new ArrayList<CliDeclaredOptionValue>();
        for (int i = 0; i < declaredParameters.length; ++i) {
            Class<?> p = declaredParameters[i];
            TherapiJavadocHelper.DocumentedMethodParam dP = documentedParameters.get(i);
            boolean required = !TypeUtils.containsAnnotation(Arrays.asList(annotations[i]), Nullable.class);
            String javadocDescription = BuilderApiToPicocliCommandsMapper.extractJavadocDescription(dP.getJavadoc());
            String[] javadocExamples = BuilderApiToPicocliCommandsMapper.extractJavadocExamples(dP.getJavadoc());
            cliParams.add(new CliDeclaredOptionValue(dP.getName(), BuilderApiToPicocliCommandsMapper.determineTypeLabel(p), javadocDescription, required, javadocExamples));
        }
        return cliParams;
    }

    @NotNull
    static String extractJavadocDescription(String javadoc) {
        return javadoc.substring(0, BuilderApiToPicocliCommandsMapper.determineJavadocLengthUntilExamples(javadoc, false));
    }

    @NotNull
    static String[] extractJavadocExamples(String javadoc) {
        int javadocLengthIncludingExamples = BuilderApiToPicocliCommandsMapper.determineJavadocLengthUntilExamples(javadoc, true);
        if (javadocLengthIncludingExamples != javadoc.length()) {
            return javadoc.substring(javadocLengthIncludingExamples).replaceAll("(?m)^\\s*-\\s*", "").replaceAll("(?m)\\s*$", "").split("\\r?\\n");
        }
        return new String[0];
    }

    private static int determineJavadocLengthUntilExamples(String javadoc, boolean includeExamplesTextLength) {
        Pattern PATTERN_EXAMPLES_MARKER = Pattern.compile("(?i)(?s).*(?<examples> examples?:\\s*)");
        Matcher matcher = PATTERN_EXAMPLES_MARKER.matcher(javadoc);
        return matcher.find() ? matcher.end() - (!includeExamplesTextLength ? matcher.group("examples").length() : 0) : javadoc.length();
    }

    @NotNull
    private static String determineTypeLabel(Class<?> type) {
        return (String)Preconditions.checkNonEmptyArgument((Object)TYPE_LABELS.get(type), (String)("Missing type label for type " + type));
    }

    static {
        ValueConversionHelper.registerValueConverter((ValueFunction)new StringToFileFunction());
        ValueConversionHelper.registerValueConverter((ValueFunction)new EmlFilePathToMimeMessageFunction());
        ValueConversionHelper.registerValueConverter((ValueFunction)new MsgFilePathToMimeMessageFunction());
        ValueConversionHelper.registerValueConverter((ValueFunction)new PemFilePathToX509CertificateFunction());
        ValueConversionHelper.registerValueConverter((ValueFunction)new StringToTransportStrategyFunction());
        ValueConversionHelper.registerValueConverter((ValueFunction)new StringToLoadBalancingStrategyFunction());
        ValueConversionHelper.registerValueConverter((ValueFunction)new StringToCalendarMethodFunction());
        ValueConversionHelper.registerValueConverter((ValueFunction)new StringToContentTransferEncodingFunction());
    }
}

