/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.clisupport;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bbottema.javareflection.TypeUtils;
import org.bbottema.javareflection.valueconverter.IncompatibleTypeException;
import org.bbottema.javareflection.valueconverter.ValueConversionHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.internal.clisupport.model.CliCommandType;
import org.simplejavamail.api.internal.clisupport.model.CliDeclaredOptionSpec;
import org.simplejavamail.api.internal.clisupport.model.CliReceivedCommand;
import org.simplejavamail.api.internal.clisupport.model.CliReceivedOptionData;
import org.simplejavamail.internal.util.ListUtil;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

class CliCommandLineConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CliCommandLineConsumer.class);

    CliCommandLineConsumer() {
    }

    static CliReceivedCommand consumeCommandLineInput(CommandLine.ParseResult providedCommand, Iterable<CliDeclaredOptionSpec> declaredOptions) {
        Preconditions.assumeTrue((boolean)providedCommand.hasSubcommand(), (String)("Command was empty, expected one of: " + Arrays.toString(CliCommandType.values())));
        CommandLine.ParseResult mailCommand = providedCommand.subcommand();
        CliCommandType matchedCommand = CliCommandType.valueOf((String)mailCommand.commandSpec().name());
        Map<CliDeclaredOptionSpec, CommandLine.Model.OptionSpec> matchedOptionsInOrderProvision = CliCommandLineConsumer.matchProvidedOptions(declaredOptions, mailCommand.matchedOptions());
        CliCommandLineConsumer.logParsedInput(matchedCommand, matchedOptionsInOrderProvision);
        ArrayList<CliReceivedOptionData> receivedOptions = new ArrayList<CliReceivedOptionData>();
        for (Map.Entry<CliDeclaredOptionSpec, CommandLine.Model.OptionSpec> cliOption : matchedOptionsInOrderProvision.entrySet()) {
            Method sourceMethod = cliOption.getKey().getSourceMethod();
            int mandatoryParameters = MiscUtil.countMandatoryParameters((Method)sourceMethod);
            List providedStringValues = (List)cliOption.getValue().getValue();
            Preconditions.assumeTrue((providedStringValues.size() >= mandatoryParameters ? 1 : 0) != 0, (String)String.format("provided %s arguments for '%s', but need at least %s", providedStringValues.size(), cliOption.getKey(), mandatoryParameters));
            Preconditions.assumeTrue((providedStringValues.size() <= sourceMethod.getParameterTypes().length ? 1 : 0) != 0, (String)String.format("provided %s arguments for '%s', but need at most %s", providedStringValues.size(), cliOption.getKey(), sourceMethod.getParameterTypes().length));
            receivedOptions.add(new CliReceivedOptionData(cliOption.getKey(), CliCommandLineConsumer.convertProvidedOptionValues(providedStringValues, sourceMethod)));
            LOGGER.debug("\tconverted option values: {}", (Object)((CliReceivedOptionData)ListUtil.getLast(receivedOptions)).getProvidedOptionValues());
        }
        return new CliReceivedCommand(matchedCommand, receivedOptions);
    }

    private static Map<CliDeclaredOptionSpec, CommandLine.Model.OptionSpec> matchProvidedOptions(Iterable<CliDeclaredOptionSpec> declaredOptions, List<CommandLine.Model.OptionSpec> providedOptions) {
        LinkedHashMap<CliDeclaredOptionSpec, CommandLine.Model.OptionSpec> matchedProvidedOptions = new LinkedHashMap<CliDeclaredOptionSpec, CommandLine.Model.OptionSpec>();
        for (CommandLine.Model.OptionSpec providedOption : providedOptions) {
            for (CliDeclaredOptionSpec declaredOption : declaredOptions) {
                if (!providedOption.longestName().equals(declaredOption.getName())) continue;
                matchedProvidedOptions.put(declaredOption, providedOption);
            }
        }
        return matchedProvidedOptions;
    }

    static List<Object> convertProvidedOptionValues(List<String> providedStringValues, Method m) {
        ArrayList<Object> providedValuesConverted = new ArrayList<Object>();
        Annotation[][] annotations = m.getParameterAnnotations();
        Class<?>[] declaredParameters = m.getParameterTypes();
        int mandatoryParameters = MiscUtil.countMandatoryParameters((Method)m);
        for (int i = 0; i < declaredParameters.length; ++i) {
            boolean required = !TypeUtils.containsAnnotation(Arrays.asList(annotations[i]), Nullable.class);
            Object providedValueConverted = null;
            if (required || providedStringValues.size() > mandatoryParameters) {
                providedValueConverted = CliCommandLineConsumer.parseStringInput(providedStringValues.remove(0), declaredParameters[i]);
            }
            providedValuesConverted.add(providedValueConverted);
            mandatoryParameters = required ? mandatoryParameters - 1 : mandatoryParameters;
        }
        return providedValuesConverted;
    }

    private static Object parseStringInput(@NotNull String stringValue, @NotNull Class<?> targetType) {
        try {
            return ValueConversionHelper.convert((Object)stringValue, targetType);
        }
        catch (IncompatibleTypeException e) {
            LOGGER.error("Was unable to parse input from command line. The following conversions were tried and failed:");
            for (IncompatibleTypeException cause : e.getCauses()) {
                LOGGER.error(cause.getMessage(), (Throwable)cause);
            }
            throw e;
        }
    }

    private static void logParsedInput(CliCommandType matchedCommand, Map<CliDeclaredOptionSpec, CommandLine.Model.OptionSpec> matchedOptionsInOrderProvision) {
        LOGGER.debug("processing mail command: {}", (Object)matchedCommand);
        for (Map.Entry<CliDeclaredOptionSpec, CommandLine.Model.OptionSpec> cliOption : matchedOptionsInOrderProvision.entrySet()) {
            CliDeclaredOptionSpec declaredOption = cliOption.getKey();
            CommandLine.Model.OptionSpec providedOption = cliOption.getValue();
            Collection values = (Collection)providedOption.getValue();
            LOGGER.debug("\tgot option: {}, with {} value(s): {}", new Object[]{declaredOption.getName(), values.size(), values});
        }
    }
}

