/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.clisupport;

import java.io.PrintStream;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

class CliCommandLineConsumerUsageHelper {
    private static final CommandLine.Help.ColorScheme COLOR_SCHEME = CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.AUTO).optionParams(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.fg_yellow});

    CliCommandLineConsumerUsageHelper() {
    }

    static boolean processAndApplyHelp(CommandLine.ParseResult pr, int textWidth) {
        CommandLine.Model.OptionSpec matchedOptionForHelp;
        boolean helpApplied = CommandLine.printHelpIfRequested((List)pr.asCommandLineList(), (PrintStream)System.out, (PrintStream)System.err, (CommandLine.Help.ColorScheme)COLOR_SCHEME);
        if (!helpApplied && (matchedOptionForHelp = CliCommandLineConsumerUsageHelper.checkHelpWantedForOptions(pr)) != null) {
            CommandLine.Model.CommandSpec command = CliCommandLineConsumerUsageHelper.convertOptionToCommandForUsageDisplay(matchedOptionForHelp);
            CommandLine.usage((Object)new CommandLine((Object)command).setUsageHelpWidth(textWidth), (PrintStream)System.out, (CommandLine.Help.ColorScheme)COLOR_SCHEME);
            helpApplied = true;
        }
        return helpApplied;
    }

    @Nullable
    private static CommandLine.Model.OptionSpec checkHelpWantedForOptions(CommandLine.ParseResult pr) {
        for (CommandLine.Model.OptionSpec matchedOption : pr.matchedOptions()) {
            if (!matchedOption.longestName().endsWith("--help")) continue;
            return matchedOption;
        }
        return pr.hasSubcommand() ? CliCommandLineConsumerUsageHelper.checkHelpWantedForOptions(pr.subcommand()) : null;
    }

    private static CommandLine.Model.CommandSpec convertOptionToCommandForUsageDisplay(CommandLine.Model.OptionSpec matchedOption) {
        CommandLine.Model.CommandSpec command = CommandLine.Model.CommandSpec.create();
        command.usageMessage().customSynopsis(new String[]{CliCommandLineConsumerUsageHelper.determineCustomSynopsis(matchedOption)}).description(matchedOption.description()).headerHeading("%n@|bold,underline Usage|@:").synopsisHeading(" ").descriptionHeading("%n@|bold,underline Description|@:%n").footerHeading("%n").footer(new String[]{"@|faint,italic https://www.simplejavamail.org/#/cli|@"});
        return command;
    }

    private static String determineCustomSynopsis(CommandLine.Model.OptionSpec matchedOption) {
        String styledOptionNoParameters = "@|%s %s|@";
        String stylesOptionWithParameters = "@|%s %s|@ @|%s %s|@";
        String optionName = CliCommandLineConsumerUsageHelper.determineOptionName(matchedOption);
        return matchedOption.paramLabel().equals("<empty>") ? String.format("@|%s %s|@", "cyan", optionName) : String.format("@|%s %s|@ @|%s %s|@", "cyan", optionName, "yellow", matchedOption.paramLabel());
    }

    @NotNull
    private static String determineOptionName(CommandLine.Model.OptionSpec matchedOption) {
        return matchedOption.longestName().substring(0, matchedOption.longestName().indexOf("--help"));
    }
}

